/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.report;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import zeus.actors.PlanRecord;
import zeus.concepts.ReportRec;
import zeus.gui.graph.AbstractGraphNodeEditor;
import zeus.gui.graph.Graph;
import zeus.gui.graph.GraphNode;
import zeus.gui.graph.GraphNodeRenderer;
import zeus.util.SystemProps;
import zeus.visualiser.report.ReportModel;

public class ReportGraph
extends JPanel {
    protected Graph graph;
    protected ReportModel model;

    public ReportGraph(ReportModel reportModel) {
        this.model = reportModel;
        this.graph = new Graph(3, reportModel, true, false);
        this.graph.setNodeRenderer(new ReportNodeRenderer());
        this.graph.setNodeEditor(new ReportNodeEditor());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createBevelBorder(1));
        JPanel jPanel = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBackground(Color.lightGray);
        JScrollPane jScrollPane = new JScrollPane(this.graph);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(600, 600));
        this.graph.setPreferredSize(new Dimension(2000, 2000));
        this.graph.setBackground(new Color(245, 230, 140));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Task Graph");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel.setBorder(titledBorder);
        NodesToolBar nodesToolBar = new NodesToolBar();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(nodesToolBar, gridBagConstraints);
        jPanel.add(nodesToolBar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
    }

    Graph getGraph() {
        return this.graph;
    }

    ReportModel getModel() {
        return this.model;
    }

    protected class NodesToolBar
    extends JToolBar
    implements ActionListener {
        protected JButton selectBtn;
        protected JButton selectAllBtn;
        protected JButton hideBtn;
        protected JButton showBtn;
        protected JButton collapseBtn;
        protected JButton expandBtn;
        protected JButton deleteBtn;
        protected JButton recomputeBtn;
        protected JButton redrawBtn;

        public NodesToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.recomputeBtn = new JButton(new ImageIcon(string2 + "recompute.gif"));
            this.recomputeBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.recomputeBtn);
            this.recomputeBtn.setToolTipText("Recompute node positions");
            this.recomputeBtn.addActionListener(this);
            this.redrawBtn = new JButton(new ImageIcon(string2 + "redraw.gif"));
            this.redrawBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.redrawBtn);
            this.redrawBtn.setToolTipText("Redraw");
            this.redrawBtn.addActionListener(this);
            this.addSeparator();
            this.selectBtn = new JButton(new ImageIcon(string2 + "select.gif"));
            this.selectBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.selectBtn);
            this.selectBtn.setToolTipText("Select nodes");
            this.selectBtn.addActionListener(this);
            this.selectAllBtn = new JButton(new ImageIcon(string2 + "selectAll.gif"));
            this.selectAllBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.selectAllBtn);
            this.selectAllBtn.setToolTipText("Select all nodes");
            this.selectAllBtn.addActionListener(this);
            this.addSeparator();
            this.collapseBtn = new JButton(new ImageIcon(string2 + "collapse.gif"));
            this.collapseBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.collapseBtn);
            this.collapseBtn.setToolTipText("Collapse nodes");
            this.collapseBtn.addActionListener(this);
            this.expandBtn = new JButton(new ImageIcon(string2 + "expand.gif"));
            this.expandBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.expandBtn);
            this.expandBtn.setToolTipText("Expand nodes");
            this.expandBtn.addActionListener(this);
            this.addSeparator();
            this.hideBtn = new JButton(new ImageIcon(string2 + "hide.gif"));
            this.hideBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.hideBtn);
            this.hideBtn.setToolTipText("Hide nodes");
            this.hideBtn.addActionListener(this);
            this.showBtn = new JButton(new ImageIcon(string2 + "show.gif"));
            this.showBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.showBtn);
            this.showBtn.setToolTipText("Show nodes");
            this.showBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.recomputeBtn) {
                ReportGraph.this.graph.recompute();
            } else if (object == this.redrawBtn) {
                ReportGraph.this.graph.redraw();
            } else if (object == this.selectBtn) {
                ReportGraph.this.graph.select();
            } else if (object == this.selectAllBtn) {
                ReportGraph.this.graph.selectAll();
            } else if (object == this.collapseBtn) {
                ReportGraph.this.graph.collapse();
            } else if (object == this.expandBtn) {
                ReportGraph.this.graph.expand();
            } else if (object == this.hideBtn) {
                ReportGraph.this.graph.hide();
            } else if (object == this.showBtn) {
                ReportGraph.this.graph.show();
            }
        }
    }

    class ReportNodeEditor
    extends AbstractGraphNodeEditor
    implements ActionListener {
        protected JButton button = new JButton("Click to edit");
        protected GraphNode node;
        protected ReportDialog dialog = null;

        public ReportNodeEditor() {
            this.button.setBackground(Color.lightGray);
            this.button.setHorizontalAlignment(0);
            this.button.setBorderPainted(true);
            this.button.addActionListener(this);
            this.button.setOpaque(true);
            this.button.setMinimumSize(new Dimension(120, 30));
            this.button.setPreferredSize(new Dimension(120, 30));
            this.button.setSize(120, 30);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.button) {
                ReportRec reportRec = (ReportRec)this.node.getUserObject();
                this.dialog = new ReportDialog(reportRec);
                this.dialog.setLocationRelativeTo(this.button);
                this.dialog.pack();
                this.dialog.setVisible(true);
                this.fireEditAction(1, this.node, null);
            }
        }

        public Component getNodeEditorComponent(Graph graph, GraphNode graphNode) {
            this.node = graphNode;
            return this.button;
        }

        class ReportDialog
        extends JDialog
        implements ActionListener {
            String[] attr = new String[]{"Goal", "Task", "Agent", "State", "Owner", "Start-Time", "End-Time", "Cost"};
            protected JTextField[] textfield;
            protected JButton okButton;

            public ReportDialog(ReportRec reportRec) {
                super((JFrame)SwingUtilities.getRoot(ReportGraph.this), reportRec.getGoal() + "/" + reportRec.getAgent(), false);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(1, 1, 10, 10));
                this.okButton = new JButton("OK");
                jPanel.add(this.okButton);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(10, 0, 10, 0);
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                JPanel jPanel2 = new JPanel();
                JSeparator jSeparator = new JSeparator();
                jPanel2.setLayout(gridBagLayout);
                gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
                jPanel2.add(jSeparator);
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 10, 0);
                gridBagLayout.setConstraints(jPanel, gridBagConstraints);
                jPanel2.add(jPanel);
                this.getContentPane().add("South", jPanel2);
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout(gridBagLayout);
                JLabel[] jLabelArray = new JLabel[this.attr.length];
                this.textfield = new JTextField[this.attr.length];
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.weightx = 0.0;
                for (int i = 0; i < this.attr.length; ++i) {
                    jLabelArray[i] = new JLabel(this.attr[i], 0);
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.insets = new Insets(10, 10, 0, 0);
                    gridBagLayout.setConstraints(jLabelArray[i], gridBagConstraints);
                    jPanel3.add(jLabelArray[i]);
                    this.textfield[i] = new JTextField();
                    this.textfield[i].setEditable(false);
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.insets = new Insets(10, 10, 0, 10);
                    gridBagLayout.setConstraints(this.textfield[i], gridBagConstraints);
                    jPanel3.add(this.textfield[i]);
                }
                this.getContentPane().add("Center", jPanel3);
                this.okButton.addActionListener(this);
                this.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ ReportDialog this$2;
                    {
                        this.this$2 = reportDialog;
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        this.this$2.setVisible(false);
                    }
                });
                this.update(reportRec);
            }

            protected void update(ReportRec reportRec) {
                if (reportRec == null) {
                    return;
                }
                this.textfield[0].setText(reportRec.getGoal());
                this.textfield[1].setText(reportRec.getTask());
                this.textfield[2].setText(reportRec.getAgent());
                this.textfield[3].setText(PlanRecord.state_string[reportRec.getState()]);
                this.textfield[4].setText(reportRec.getOwner());
                this.textfield[5].setText(Integer.toString(reportRec.getStartTime()));
                this.textfield[6].setText(Integer.toString(reportRec.getEndTime()));
                this.textfield[7].setText(Double.toString(reportRec.getCost()));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.setVisible(false);
            }
        }
    }

    protected class ReportNodeRenderer
    implements GraphNodeRenderer {
        protected ReportNodeRenderer() {
        }

        public Component getNodeRendererComponent(Graph graph, GraphNode graphNode) {
            ReportRec reportRec = (ReportRec)graphNode.getUserObject();
            return new NodeIcon(reportRec);
        }

        class KeyLabel
        extends JLabel {
            public KeyLabel(String string) {
                super(string, 2);
            }

            public void paint(Graphics graphics) {
                Color color = graphics.getColor();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
                graphics.setColor(color);
                super.paint(graphics);
            }
        }

        class NodeIcon
        extends JPanel {
            public NodeIcon(ReportRec reportRec) {
                Color color = PlanRecord.color[reportRec.getState()];
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                this.setBackground(color);
                KeyLabel keyLabel = new KeyLabel("Agent: " + reportRec.getAgent());
                keyLabel.setBackground(color);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new Insets(2, 2, 0, 2);
                gridBagLayout.setConstraints(keyLabel, gridBagConstraints);
                this.add(keyLabel);
                keyLabel = new KeyLabel("Task: " + reportRec.getTask());
                keyLabel.setBackground(color);
                gridBagLayout.setConstraints(keyLabel, gridBagConstraints);
                this.add(keyLabel);
                keyLabel = new KeyLabel("Goal: " + reportRec.getGoal());
                keyLabel.setBackground(color);
                gridBagConstraints.insets = new Insets(2, 2, 2, 2);
                gridBagLayout.setConstraints(keyLabel, gridBagConstraints);
                this.add(keyLabel);
            }
        }
    }
}

