/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.control;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import zeus.actors.AgentContext;
import zeus.actors.ZeusAgentContext;
import zeus.concepts.Goal;
import zeus.concepts.OntologyDb;
import zeus.concepts.Performative;
import zeus.concepts.SummaryTable;
import zeus.gui.SingleSelectionDialog;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;
import zeus.visualiser.VisualiserModel;
import zeus.visualiser.basic.BasicTool;
import zeus.visualiser.control.ControlMenuBar;
import zeus.visualiser.control.ControlToolBar;

public class ControlTool
extends BasicTool
implements ActionListener {
    private static int count = 0;
    protected ControlMenuBar menubar;
    protected SingleSelectionDialog sa_goal = null;
    protected ControlToolBar toolbar;
    protected File file;
    protected SummaryTable goalTable = new SummaryTable();
    protected String myName;
    protected AgentContext context;

    public ControlTool(AgentContext agentContext, VisualiserModel visualiserModel) {
        super(agentContext, visualiserModel);
        this.myName = agentContext.whoami();
        this.setTitle(this.myName + " -  Control Tool:" + count++);
        ImageIcon imageIcon = new ImageIcon(SystemProps.getProperty("gif.dir") + File.separator + "visualiser" + File.separator + "control-icon.gif");
        this.setIconImage(imageIcon.getImage());
        this.setBackground(Color.lightGray);
        this.getContentPane().setLayout(new BorderLayout());
        this.menubar = new ControlMenuBar(this);
        this.setJMenuBar(this.menubar);
        this.toolbar = new ControlToolBar(this);
        ImageIcon imageIcon2 = new ImageIcon(SystemProps.getProperty("gif.dir") + File.separator + "visualiser" + File.separator + "bt.gif");
        JLabel jLabel = new JLabel(imageIcon2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.toolbar.setBorder(new EmptyBorder(0, 16, 0, 16));
        jPanel.add((Component)this.toolbar, "West");
        jLabel.setBorder(new EmptyBorder(4, 8, 4, 8));
        jPanel.add((Component)jLabel, "East");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "North");
        this.pack();
        this.setVisible(true);
    }

    public void addNotify() {
        super.addNotify();
        Dimension dimension = this.getPreferredSize();
        this.setSize(dimension.width + 150, dimension.height);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Kill")) {
            this.KillAgents();
        } else if (string.equals("Help")) {
            this.showHelp();
        } else {
            JOptionPane.showMessageDialog(this, "Option not functional yet");
        }
    }

    public void SendCommand() {
        if (!this.hubOK()) {
            return;
        }
        String[] stringArray = this.model.getAgents();
    }

    public void executeCommand(String string, String[] stringArray) {
    }

    public void LoadOntology() {
        File file = this.getFile(0);
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "File does not exist!");
            return;
        }
        OntologyDb ontologyDb = this.context.OntologyDb();
        int n = ontologyDb.openFile(file);
        if ((n & 2) != 0) {
            JOptionPane.showMessageDialog(this, "Ontology File I/O Error: " + ontologyDb.getError());
            return;
        }
        if ((n & 1) != 0) {
            JOptionPane.showMessageDialog(this, "Warning: " + ontologyDb.getWarning());
        } else if ((n & 1) == 0) {
            JOptionPane.showMessageDialog(this, "Now using ontology from: " + file.getName());
        }
    }

    protected File getFile(int n) {
        FileDialog fileDialog = new FileDialog((Frame)this, "Select File", n);
        if (this.file != null) {
            fileDialog.setFile(this.file.getName());
            fileDialog.setDirectory(this.file.getParent());
        }
        fileDialog.pack();
        fileDialog.setVisible(true);
        return fileDialog.getFile() == null ? null : new File(fileDialog.getDirectory(), fileDialog.getFile());
    }

    public void AddGoal() {
        if (!this.hubOK()) {
            return;
        }
    }

    public void BrowseGoals() {
        if (!this.hubOK()) {
            return;
        }
        JOptionPane.showMessageDialog(this, "This is Incomplete");
    }

    public void StreamGoals(boolean bl) {
    }

    public void RequestGoals(String string) {
    }

    public void SuspendGoals(String string, String[] stringArray) {
    }

    public void ResumeGoals(String string, String[] stringArray) {
    }

    public void CancelGoals(String string, String[] stringArray) {
    }

    public void add(Goal goal) {
    }

    public void add(Goal goal, String string) {
    }

    private void KillAgents() {
        System.out.println(this.myName + " sending kill command");
        String[] stringArray = this.model.getAgents();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(this.myName)) continue;
            System.out.println("Killing ..." + stringArray[i]);
            this.request("kill_yourself", stringArray[i], "");
        }
        this.request("kill_yourself", this.myName, "");
    }

    public void BrowseAgents() {
    }

    public void TuneAgent() {
    }

    public void BrowseFacts() {
    }

    public void AddFact() {
    }

    public void StreamFacts(boolean bl) {
    }

    public void BrowseTasks() {
    }

    public void AddTask() {
    }

    public void StreamTasks(boolean bl) {
    }

    public void BrowseRelations() {
    }

    public void AddRelation() {
    }

    public void StreamRelations(boolean bl) {
    }

    public void BrowseStrategies() {
    }

    public void AddStrategy() {
    }

    public void StreamStrategies(boolean bl) {
    }

    protected void removeRequestKeys() {
    }

    protected void registerAgent(String string, String string2) {
    }

    protected boolean incomingMessage(Performative performative) {
        return false;
    }

    public void showHelp() {
        Point point = this.getLocation();
        HelpWindow helpWindow = new HelpWindow(this, point, "visualiser", "Control Tool");
        helpWindow.setSource(this.toolbar.helpBtn);
        helpWindow.setSize(new Dimension(this.getWidth(), 440));
        helpWindow.setLocation(point.x, point.y + this.getHeight());
        helpWindow.validate();
    }

    public static void main(String[] stringArray) {
        ZeusAgentContext zeusAgentContext = new ZeusAgentContext("Test", "visualiser");
        ControlTool controlTool = new ControlTool(zeusAgentContext, new VisualiserModel(zeusAgentContext));
    }
}

