/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import zeus.actors.AgentContext;
import zeus.concepts.Address;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;
import zeus.visualiser.VisualiserModel;
import zeus.visualiser.basic.BasicTool;
import zeus.visualiser.control.ControlTool;
import zeus.visualiser.report.ReportTool;
import zeus.visualiser.society.SocietyTool;
import zeus.visualiser.statistics.StatisticsTool;

public class VisualiserHub
extends JFrame {
    protected AgentContext context = null;
    protected VisualiserModel model = null;
    public boolean quick = false;
    protected HelpWindow helpWin = null;
    private static final String disclaimer = "This software was produced as a part of research\nactivities. It is not intended to be used as commercial\nor industrial software by any organisation. Except as\nexplicitly stated, no guarantees are given as to its\nreliability or trustworthiness if used for purposes other\nthan those for which it was originally intended.\n \n(c) British Telecommunications plc 1996-9.";
    protected String path = SystemProps.getProperty("gif.dir") + File.separator + "visualiser" + File.separator;
    protected Icon headerIcon = new ImageIcon(this.path + "header.gif");
    protected Icon societyIcon = new ImageIcon(this.path + "society.gif");
    protected Icon reportIcon = new ImageIcon(this.path + "report.gif");
    protected Icon infoIcon = new ImageIcon(this.path + "info.gif");
    protected Icon controlIcon = new ImageIcon(this.path + "control.gif");
    protected Icon statsIcon = new ImageIcon(this.path + "stats.gif");
    protected Icon helpIcon = new ImageIcon(this.path + "help.gif");

    public VisualiserHub(AgentContext agentContext, boolean bl) {
        super(agentContext.whoami());
        this.context = agentContext;
        this.model = new VisualiserModel(agentContext);
        this.quick = bl;
        for (int i = 0; i < agentContext.nameservers().size(); ++i) {
            Address address = (Address)agentContext.nameservers().elementAt(i);
            this.model.addNameserver(address.getName());
        }
        ImageIcon imageIcon = new ImageIcon(this.path + "visicon.gif");
        this.setIconImage(imageIcon.getImage());
        this.getContentPane().add(this.makeToolbar());
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                int n = JOptionPane.showConfirmDialog(VisualiserHub.this, "Exit Visualiser?", "Exit", 0);
                if (n == 0) {
                    System.exit(0);
                }
            }
        });
        this.setVisible(true);
    }

    private void quickConnection(BasicTool basicTool) {
        if (this.quick) {
            this.quick = false;
            basicTool.quickConnect();
        }
    }

    private JPanel makeToolbar() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setLayout(new GridLayout(7, 1));
        JButton jButton = new JButton(this.headerIcon);
        jButton.setToolTipText("Information");
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(VisualiserHub.this, VisualiserHub.disclaimer);
            }
        });
        JButton jButton2 = new JButton(this.societyIcon);
        jButton2.setToolTipText("View Agent Society");
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SocietyTool societyTool = new SocietyTool(VisualiserHub.this.context, VisualiserHub.this.model);
                VisualiserHub.this.quickConnection(societyTool);
                Point point = VisualiserHub.this.getLocation();
                societyTool.setLocation(point.x + VisualiserHub.this.getWidth(), point.y);
            }
        });
        JButton jButton3 = new JButton(this.reportIcon);
        jButton3.setToolTipText("View Agent Reports");
        jButton3.setMargin(new Insets(0, 0, 0, 0));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportTool reportTool = new ReportTool(VisualiserHub.this.context, VisualiserHub.this.model);
                VisualiserHub.this.quickConnection(reportTool);
                Point point = VisualiserHub.this.getLocation();
                reportTool.setLocation(point.x + VisualiserHub.this.getWidth(), point.y);
            }
        });
        JButton jButton4 = new JButton(this.statsIcon);
        jButton4.setToolTipText("View Agent Statistics");
        jButton4.setMargin(new Insets(0, 0, 0, 0));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsTool statisticsTool = new StatisticsTool(VisualiserHub.this.context, VisualiserHub.this.model);
                VisualiserHub.this.quickConnection(statisticsTool);
                Point point = VisualiserHub.this.getLocation();
                statisticsTool.setLocation(point.x + VisualiserHub.this.getWidth(), point.y);
            }
        });
        JButton jButton5 = new JButton(this.infoIcon);
        jButton5.setToolTipText("Remote Agent Viewer");
        jButton5.setMargin(new Insets(0, 0, 0, 0));
        jButton5.setEnabled(false);
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        JButton jButton6 = new JButton(this.controlIcon);
        jButton6.setToolTipText("Launch Control Tool");
        jButton6.setMargin(new Insets(0, 0, 0, 0));
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlTool controlTool = new ControlTool(VisualiserHub.this.context, VisualiserHub.this.model);
                VisualiserHub.this.quickConnection(controlTool);
                Point point = VisualiserHub.this.getLocation();
                controlTool.setLocation(point.x + VisualiserHub.this.getWidth(), point.y);
            }
        });
        JToggleButton jToggleButton = new JToggleButton(this.helpIcon);
        jToggleButton.setToolTipText("Help");
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Point point = VisualiserHub.this.getLocation();
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                if (jToggleButton.isSelected()) {
                    VisualiserHub.this.helpWin = new HelpWindow(VisualiserHub.this, point, "visualiser", "Visualiser Hub");
                    VisualiserHub.this.helpWin.setSource(jToggleButton);
                } else {
                    VisualiserHub.this.helpWin.dispose();
                }
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        jPanel.add(jButton5);
        jPanel.add(jButton6);
        jPanel.add(jToggleButton);
        return jPanel;
    }
}

