/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import zeus.agents.BasicAgent;
import zeus.agents.BasicAgentUI;
import zeus.agents.ZeusExternal;
import zeus.concepts.OntologyDb;
import zeus.concepts.ZeusParser;
import zeus.util.Core;
import zeus.util.SystemProps;
import zeus.visualiser.VisualiserHub;

public class Visualiser
extends BasicAgent {
    public Visualiser(String string, String string2, Vector vector, boolean bl) {
        super(SystemProps.getProperty("agent.names.visualiser"), string, vector);
        this.context.set(new OntologyDb(this.context.GenSym()));
        this.context.MailBox().lowerStatus();
        this.context.MsgHandler().lowerStatus();
        if (string2 != null) {
            OntologyDb ontologyDb = this.context.OntologyDb();
            int n = ontologyDb.openFile(new File(string2));
            if ((n & 2) != 0) {
                System.err.println("Ontology File I/O Error: " + ontologyDb.getError());
                System.exit(0);
            } else if ((n & 1) != 0) {
                System.err.println("Warning: " + ontologyDb.getWarning());
            }
        }
        new VisualiserHub(this.context, bl);
    }

    protected static void version() {
        System.err.println("Visualiser version: " + SystemProps.getProperty("version.id"));
        System.exit(0);
    }

    protected static void usage() {
        System.err.println("Usage: java Visualiser <name> -s <dns_file> [-o ontology_file] [-gui ViewerProg] [-e ExternalProg] [-quick] [-debug] [-h] [-v]");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        try {
            serializable = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Java cannot find java.lang.Object.\n This indicates that the rt.jar file is not in your classpath.\n Ensure that $java_install_dir\\jre\\rt.jar is present in the classpath and then continue");
            classNotFoundException.printStackTrace();
        }
        try {
            serializable = Class.forName("zeus.gui.help.HelpWindow");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Java cannot find a zeus class.\n This indicates that the zeus.jar file is not in your classpath.\n Ensure that zeus_install_dir\\lib\\zeus.jar is present in the classpath and then continue");
            classNotFoundException.printStackTrace();
        }
        serializable = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        String string4 = null;
        if (stringArray.length < 3) {
            Visualiser.usage();
        } else {
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-s") && ++i < stringArray.length) {
                    string = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-o") && ++i < stringArray.length) {
                    string2 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-e") && ++i < stringArray.length) {
                    string4 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-gui") && ++i < stringArray.length) {
                    string3 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-quick")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-debug")) {
                    Core.debug = true;
                    Core.setDebuggerOutputFile(stringArray[0] + ".log");
                    continue;
                }
                if (stringArray[i].equals("-h")) {
                    Visualiser.usage();
                    continue;
                }
                if (stringArray[i].equals("-v")) {
                    Visualiser.version();
                    continue;
                }
                Visualiser.usage();
            }
        }
        try {
            Object object;
            Class<?> clazz;
            serializable = ZeusParser.addressList(new FileInputStream(string));
            if (serializable == null || ((Vector)serializable).isEmpty()) {
                throw new IOException();
            }
            Visualiser visualiser = new Visualiser(stringArray[0], string2, (Vector)serializable, bl);
            if (string3 != null) {
                clazz = Class.forName(string3);
                object = (BasicAgentUI)clazz.newInstance();
                object.set(visualiser.getAgentContext());
            }
            if (string4 != null) {
                clazz = Class.forName(string4);
                object = (ZeusExternal)clazz.newInstance();
                object.exec(visualiser.getAgentContext());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }
}

