/*
 * Decompiled with CFR 0.152.
 */
package zeus.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.util.Assert;
import zeus.util.Misc;

public class ReferenceTable
extends Hashtable {
    protected String defaultReference = null;

    public ReferenceTable() {
    }

    public ReferenceTable(String string) {
        Assert.notNull(string);
        this.defaultReference = string;
    }

    public void add(String string, String string2) {
        this.put(string, string2);
    }

    public void replace(String string, String string2) {
        this.put(string, string2);
    }

    public void del(String string) {
        this.remove(string);
    }

    public String lookup(String string) {
        Assert.notNull(string);
        String string2 = (String)this.get(string);
        if (string2 == null && this.defaultReference != null) {
            string2 = this.defaultReference;
            this.add(string, string2);
        }
        return string2;
    }

    public String lookup(String string, String string2) {
        Assert.notNull(string2);
        if (string == null) {
            return string2;
        }
        String string3 = (String)this.get(string);
        if (string3 == null) {
            string3 = string2;
            this.add(string, string3);
        }
        return string3;
    }

    public void set(Vector vector) {
        this.clear();
        for (int i = 0; vector != null && i < vector.size(); i += 2) {
            String string = (String)vector.elementAt(i);
            String string2 = (String)vector.elementAt(i + 1);
            this.add(string, string2);
        }
    }

    public String toString() {
        Enumeration enumeration = this.keys();
        String string = new String();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.lookup(string2);
            string = string + string2 + " " + string3 + " ";
        }
        string = string.trim();
        return string;
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string;
        String string3 = new String();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            String string5 = this.lookup(string4);
            string3 = string3 + string4 + " " + string5 + string2;
        }
        return string3.trim();
    }

    public static void main(String[] stringArray) {
        ReferenceTable referenceTable = new ReferenceTable("--DefaultName--");
        referenceTable.add("divine", "aaaaa");
        referenceTable.add("john", "bbbbb");
        referenceTable.add("george", "bbbbb");
        String string = referenceTable.lookup("adam");
        System.out.println(string);
        System.out.println(referenceTable.pprint());
    }
}

