/*
 * Decompiled with CFR 0.152.
 */
package zeus.util;

import java.util.Enumeration;
import java.util.Vector;
import zeus.util.Assert;

public class PlainQueue {
    protected Vector[] data = null;

    public PlainQueue() {
        this(1);
    }

    public PlainQueue(int n) {
        Assert.notFalse(n > 0);
        this.data = new Vector[n];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new Vector();
        }
    }

    public synchronized Enumeration elements() {
        Vector vector = new Vector();
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[i].size(); ++j) {
                vector.addElement(this.data[i].elementAt(j));
            }
        }
        return vector.elements();
    }

    public synchronized boolean remove(Object object) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[i].size(); ++j) {
                if (!this.data[i].contains(object)) continue;
                this.data[i].removeElement(object);
                return true;
            }
        }
        return false;
    }

    public synchronized boolean remove(Object object, int n) {
        for (int i = 0; i < this.data[n].size(); ++i) {
            if (!this.data[n].contains(object)) continue;
            this.data[n].removeElement(object);
            return true;
        }
        return false;
    }

    public synchronized void enqueue(Object object) {
        this.enqueue(object, 0);
    }

    public synchronized void enqueue(Object object, int n) {
        Assert.notFalse(n >= 0 && n < this.data.length);
        this.data[n].addElement(object);
    }

    public synchronized Object dequeue() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].isEmpty()) continue;
            Object e = this.data[i].firstElement();
            this.data[i].removeElement(e);
            return e;
        }
        return null;
    }

    public synchronized Object peek() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].isEmpty()) continue;
            return this.data[i].firstElement();
        }
        return null;
    }

    public synchronized boolean isEmpty() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i].removeAllElements();
        }
    }
}

