/*
 * Decompiled with CFR 0.152.
 */
package zeus.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import zeus.util.Assert;

public class MsgContentHandler {
    protected String data = null;
    protected String tag = null;

    public MsgContentHandler(String string) {
        Assert.notNull(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r", true);
        this.tag = stringTokenizer.nextToken();
        while (this.tag.equals(" ") || this.tag.equals("\t") || this.tag.equals("\n") || this.tag.equals("\r")) {
            this.tag = stringTokenizer.nextToken();
        }
        if (this.tag != null) {
            this.tag = this.tag.trim();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.data = new String();
        }
        while (stringTokenizer.hasMoreTokens()) {
            this.data = this.data + stringTokenizer.nextToken();
        }
        if (this.data != null) {
            this.data = this.data.trim();
        }
        if (this.data == null) {
            this.data = new String();
        }
    }

    public String tag() {
        return this.tag;
    }

    public String data() {
        return this.data;
    }

    public String data(int n) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.data, " \t\n\r");
            for (int i = 0; i < n && stringTokenizer.hasMoreTokens(); ++i) {
                stringTokenizer.nextToken();
            }
            return stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public String rest(int n) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.data, " \t\n\r");
            for (int i = 0; i <= n && stringTokenizer.hasMoreTokens(); ++i) {
                stringTokenizer.nextToken();
            }
            String string = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string = string + " " + stringTokenizer.nextToken();
            }
            return string;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        String string = "x y z, u, v w";
        MsgContentHandler msgContentHandler = new MsgContentHandler(string);
        System.err.println("Input = " + string);
        System.err.println("Tag = " + msgContentHandler.tag());
        System.err.println("data(0) = " + msgContentHandler.data(0));
        System.err.println("data(1) = " + msgContentHandler.data(1));
        System.err.println("data(2) = " + msgContentHandler.data(2));
        System.err.println("rest(0) = " + msgContentHandler.rest(0));
        System.err.println("rest(1) = " + msgContentHandler.rest(1));
        System.err.println("rest(2) = " + msgContentHandler.rest(2));
    }
}

