/*
 * Decompiled with CFR 0.152.
 */
package zeus.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import zeus.util.HSet;

public class Misc {
    static final String DELIMITERS = "\n\r\t !%^&*()-+={[]}~,.:;#|\\";
    public static final String OPAQUE_CHAR = "#";
    public static final String QUOTE = "\"";

    public static final String literalToString(String string) {
        if (string.startsWith(QUOTE) && string.endsWith(QUOTE)) {
            return Misc.unescape(string.substring(1, string.length() - 1));
        }
        return Misc.unescape(string);
    }

    public static final String opaqueToString(String string) {
        return string.substring(1, string.length() - 1);
    }

    public static final String escape(String string) {
        String string2 = new String();
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u0000': {
                    Misc.debug("0 !");
                    string2 = string2 + '\u0000';
                    continue block11;
                }
                case '\b': {
                    string2 = string2 + "\\b";
                    continue block11;
                }
                case '\t': {
                    string2 = string2 + "\\t";
                    continue block11;
                }
                case '\n': {
                    string2 = string2 + "\\n";
                    continue block11;
                }
                case '\f': {
                    string2 = string2 + "\\f";
                    continue block11;
                }
                case '\r': {
                    string2 = string2 + "\\r";
                    continue block11;
                }
                case '\"': {
                    string2 = string2 + "\\\"";
                    continue block11;
                }
                case '\'': {
                    string2 = string2 + "\\'";
                    continue block11;
                }
                case '\\': {
                    string2 = string2 + "\\\\";
                    continue block11;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string3 = new String();
                        string3 = string3 + "0000";
                        string3 = string3 + Integer.toString(c, 16);
                        string2 = string2 + "\\u";
                        string2 = string2 + string3.substring(string3.length() - 4, string3.length());
                        continue block11;
                    }
                    string2 = string2 + c;
                }
            }
        }
        return string2;
    }

    public static final String unescape(String string) {
        String string2 = new String();
        int n = 0;
        block13: while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) != '\\') {
                string2 = string2 + c;
                continue;
            }
            c = string.charAt(n++);
            switch (c) {
                case '\u0000': {
                    continue block13;
                }
                case 'b': {
                    string2 = string2 + "\b";
                    continue block13;
                }
                case 't': {
                    string2 = string2 + "\t";
                    continue block13;
                }
                case 'n': {
                    string2 = string2 + "\n";
                    continue block13;
                }
                case 'f': {
                    string2 = string2 + "\f";
                    continue block13;
                }
                case 'r': {
                    string2 = string2 + "\r";
                    continue block13;
                }
                case '\"': {
                    string2 = string2 + QUOTE;
                    continue block13;
                }
                case '\'': {
                    string2 = string2 + "'";
                    continue block13;
                }
                case '\\': {
                    string2 = string2 + "\\";
                    continue block13;
                }
                case ' ': {
                    string2 = string2 + " ";
                    continue block13;
                }
                case 'u': {
                    String string3 = string.substring(n, n + 4);
                    Misc.debug("thisChar = " + string3);
                    n += 4;
                    int n2 = Integer.valueOf(string3, 16);
                    Misc.debug("val = " + String.valueOf(n2));
                    char c2 = (char)n2;
                    Misc.debug("appender = " + c2);
                    string2 = string2 + c2;
                    continue block13;
                }
            }
            string2 = string2 + "\\";
            string2 = string2 + c;
        }
        return string2;
    }

    public static final String relativePath(String string) {
        if (string == null) {
            return null;
        }
        return Misc.relativePath(System.getProperty("user.dir"), string);
    }

    public static final String relativePath(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        return Misc.relativePath(string, new File(string2));
    }

    public static final String relativePath(String string, File file) {
        String string2;
        if (file == null) {
            return null;
        }
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        File file2 = new File(string);
        try {
            string = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file2.getAbsolutePath();
        }
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = file.getAbsolutePath();
        }
        int n = 0;
        while (string != null) {
            if (string2.startsWith(string) && !string.equals(File.separator)) {
                String string3 = "";
                for (int i = 0; i < n; ++i) {
                    string3 = string3 + "..";
                    if (i + 1 >= n) continue;
                    string3 = string3 + File.separator;
                }
                if ((string3 = string3 + string2.substring(string.length())).startsWith(File.separator)) {
                    return "." + string3;
                }
                if (string3.equals("")) {
                    return ".";
                }
                return string3;
            }
            ++n;
            File file3 = new File(string);
            string = file3.getParent();
        }
        if (string2.equals("")) {
            return ".";
        }
        return string2;
    }

    public static final String spaces(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        return string;
    }

    public static final String concat(String string, int[] nArray) {
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            string = string + " " + nArray[i];
        }
        return string;
    }

    public static final String concat(int[] nArray) {
        String string = "";
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            string = string + nArray[i] + " ";
        }
        string = string.trim();
        return string;
    }

    public static final String concat(String string, double[] dArray) {
        for (int i = 0; dArray != null && i < dArray.length; ++i) {
            string = string + " " + dArray[i];
        }
        return string;
    }

    public static final String concat(double[] dArray) {
        String string = "";
        for (int i = 0; dArray != null && i < dArray.length; ++i) {
            string = string + dArray[i] + " ";
        }
        return string.trim();
    }

    public static final String concat(String string, Object[] objectArray) {
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            string = string + " " + objectArray[i];
        }
        return string;
    }

    public static final String concat(Object[] objectArray) {
        String string = "";
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            string = string + objectArray[i] + " ";
        }
        string = string.trim();
        return string;
    }

    public static final String concat(String string, Vector vector) {
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            string = string + " " + vector.elementAt(i);
        }
        return string;
    }

    public static final String concat(Vector vector) {
        String string = new String();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            string = string + vector.elementAt(i) + " ";
        }
        string = string.trim();
        return string;
    }

    public static final String concat(HSet hSet) {
        String string = new String();
        Enumeration enumeration = hSet.elements();
        while (enumeration.hasMoreElements()) {
            string = string + enumeration.nextElement() + " ";
        }
        string = string.trim();
        return string;
    }

    public static final String substitute(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITERS, true);
        String string4 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (string5.equals(string2)) {
                string4 = string4 + string3;
                continue;
            }
            string4 = string4 + string5;
        }
        return string4;
    }

    public static final boolean member(int n, int[] nArray) {
        if (nArray == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public static final boolean member(String string, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static final Vector intersection(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (vector3.contains(e) || !vector2.contains(e)) continue;
            vector3.addElement(e);
        }
        return vector3;
    }

    public static final Vector union(Vector vector, Vector vector2) {
        Object e;
        int n;
        Vector vector3 = new Vector();
        for (n = 0; n < vector.size(); ++n) {
            e = vector.elementAt(n);
            if (vector3.contains(e)) continue;
            vector3.addElement(e);
        }
        for (n = 0; n < vector2.size(); ++n) {
            e = vector2.elementAt(n);
            if (vector3.contains(e)) continue;
            vector3.addElement(e);
        }
        return vector3;
    }

    public static final Vector difference(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (vector3.contains(e) || vector2.contains(e)) continue;
            vector3.addElement(e);
        }
        return vector3;
    }

    public static final boolean isSubset(Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (vector2.contains(e)) continue;
            return false;
        }
        return true;
    }

    public static final boolean sameVector(Vector vector, Vector vector2) {
        if (vector.size() != vector2.size()) {
            return false;
        }
        Vector vector3 = Misc.difference(vector, vector2);
        if (!vector3.isEmpty()) {
            return false;
        }
        vector3 = Misc.difference(vector2, vector);
        return vector3.isEmpty();
    }

    public static final boolean isNumber(String string) {
        return Misc.isLong(string) || Misc.isDouble(string);
    }

    public static final boolean isLong(String string) {
        try {
            long l = Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static final boolean isDouble(String string) {
        try {
            double d = Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static final void sort(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringArray[i].compareTo(stringArray[i + 1]) <= 0) continue;
                String string = stringArray[i];
                stringArray[i] = stringArray[i + 1];
                stringArray[i + 1] = string;
                bl = true;
            }
        }
    }

    public static final void sort(Vector vector) {
        if (vector == null) {
            return;
        }
        if (vector.isEmpty()) {
            return;
        }
        if (!(vector.elementAt(0) instanceof String)) {
            return;
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < vector.size() - 1; ++i) {
                if (((String)vector.elementAt(i)).compareTo((String)vector.elementAt(i + 1)) <= 0) continue;
                Object e = vector.elementAt(i);
                vector.setElementAt(vector.elementAt(i + 1), i);
                vector.setElementAt(e, i + 1);
                bl = true;
            }
        }
    }

    public static final int whichPosition(String string, String[] stringArray) {
        if (string != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int whichPosition(String string, Vector vector) {
        if (string != null && vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!string.equals((String)vector.elementAt(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public static final Vector flatten(Vector vector) {
        Vector vector2 = new Vector();
        if (vector == null || vector.isEmpty()) {
            return vector2;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e instanceof Vector) {
                Vector vector3 = Misc.flatten((Vector)e);
                for (int j = 0; j < vector3.size(); ++j) {
                    vector2.addElement(vector3.elementAt(j));
                }
                continue;
            }
            vector2.addElement(e);
        }
        return vector2;
    }

    public static final Vector copyVector(Vector vector) {
        if (vector == null) {
            return null;
        }
        Vector vector2 = new Vector();
        if (vector.isEmpty()) {
            return vector2;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e instanceof Vector) {
                Vector vector3 = Misc.copyVector((Vector)e);
                vector2.addElement(vector3);
                continue;
            }
            vector2.addElement(e);
        }
        return vector2;
    }

    public static final String[] stringArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return Misc.stringArray(vector);
    }

    public static final String[] stringArray(Object[] objectArray) {
        if (objectArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    public static final String[] stringArray(Vector vector) {
        if (vector == null) {
            return new String[0];
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static final Vector stringVector(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
        }
        return vector;
    }

    public static final String decimalPlaces(double d, int n) {
        return Misc.decimalPlaces(Double.toString(d), n);
    }

    public static final String decimalPlaces(String string, int n) {
        String string2 = "";
        int n2 = string.indexOf("E");
        if (n2 != -1) {
            string2 = string.substring(n2);
        }
        if ((n2 = string.indexOf(".")) == -1) {
            String string3 = string + ".";
            for (int i = 0; i < n; ++i) {
                string3 = string3 + "0";
            }
            return string3 + string2;
        }
        int n3 = string.length();
        if (n3 > n2 + n) {
            return string.substring(0, n2 + n + 1) + string2;
        }
        String string4 = string;
        for (int i = 0; i < n + n2 + 1 - n3; ++i) {
            string4 = string4 + "0";
        }
        return string4 + string2;
    }

    public static final String objectToContent(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        objectOutputStream.close();
        String string = byteArrayOutputStream.toString();
        string = Misc.escape(string);
        return string;
    }

    public static final Object contentToObject(String string) throws ClassNotFoundException, StreamCorruptedException, IOException {
        string = Misc.unescape(string);
        byte[] byArray = string.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        return object;
    }

    public static final void debug(String string) {
    }

    public static final boolean isZero(double d) {
        return Math.abs(d) < 1.0E-12;
    }
}

