/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete.action;

import java.io.IOException;
import java.util.Hashtable;
import zeus.concepts.Bindings;
import zeus.concepts.fn.IdFn;
import zeus.concepts.fn.IntFn;
import zeus.concepts.fn.RealFn;
import zeus.concepts.fn.ValueFunction;
import zeus.rete.Action;
import zeus.rete.DataReader;
import zeus.rete.Info;
import zeus.rete.action.ReteAction;
import zeus.util.Core;
import zeus.util.Misc;

public class ReadAction
extends ReteAction {
    public void executeAction(Action action, Info info) {
        Hashtable hashtable = this.conflictHandler.getReaders();
        ValueFunction valueFunction = ((ValueFunction)action.head).resolve(info.getBindings());
        if (valueFunction == null || valueFunction.getID() != 2) {
            Core.USER_ERROR("Cannot resolve logical reader name '" + action.head + "' in action " + action);
            return;
        }
        ValueFunction valueFunction2 = ((ValueFunction)action.sub_head).resolve(info.getBindings());
        if (valueFunction2 == null) {
            Core.USER_ERROR("Cannot resolve '" + action.sub_head + "' in action " + action);
            return;
        }
        DataReader dataReader = (DataReader)hashtable.get(((IdFn)valueFunction).getValue());
        if (dataReader == null) {
            Core.USER_ERROR("Unknown reader '" + valueFunction + "' in " + action);
            return;
        }
        try {
            String string = null;
            string = dataReader.nextToken();
            Bindings bindings = info.getBindings();
            if (string == null) {
                Core.USER_ERROR("End of file reached while reading '" + valueFunction + "'");
            } else if (Misc.isLong(string)) {
                bindings.set(valueFunction2, new IntFn(string));
            } else if (Misc.isDouble(string)) {
                bindings.set(valueFunction2, new RealFn(string));
            } else {
                bindings.set(valueFunction2, new IdFn(string));
            }
        }
        catch (IOException iOException) {
            Core.USER_ERROR("IOException reading '" + valueFunction + "' in action " + action);
        }
    }
}

