/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete;

import java.util.Enumeration;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.rete.PatternNode;
import zeus.rete.ReteEngine;
import zeus.rete.Successor;
import zeus.util.Assert;
import zeus.util.Core;

class TypeNode
extends PatternNode {
    String fact_type = null;

    TypeNode(ReteEngine reteEngine, String string) {
        super(reteEngine);
        this.fact_type = string;
    }

    void evaluate(String string, int n, int n2, Vector vector, Bindings bindings) {
        Assert.notFalse(string == null);
        Assert.notFalse(n2 == 0);
        Assert.notFalse(vector.size() == 1);
        Fact fact = (Fact)vector.elementAt(0);
        if (fact.isa(this.fact_type)) {
            this.propagate(string, n, vector, bindings);
        }
    }

    void propagate(String string, int n, Vector vector, Bindings bindings) {
        Core.DEBUG(5, "\nPropagate: " + string + " " + this);
        Enumeration enumeration = this.successors.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Successor successor = (Successor)this.successors.get(string);
            successor.node.evaluate(string, n, successor.type, vector, new Bindings(bindings));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof TypeNode) {
            TypeNode typeNode = (TypeNode)object;
            return this.fact_type.equals(typeNode.fact_type);
        }
        return false;
    }

    public String toString() {
        return "TypeNode(" + this.fact_type + ")";
    }
}

