/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.rete.Action;
import zeus.rete.Pattern;
import zeus.rete.ReteFact;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.GenSym;
import zeus.util.Misc;

public class Rule {
    static final String IMPLIES = "=>";
    static final String INITIAL_FACT = "ZeusFact";
    static final ReteFact initial_fact = new ReteFact("ZeusFact");
    public static final int MIN_SALIENCE = 0;
    public static final int MAX_SALIENCE = 9;
    public static final int NORM_SALIENCE = 5;
    String name = null;
    int salience = 5;
    boolean service = false;
    Vector actions = new Vector();
    Vector patterns = new Vector();
    boolean can_add_patterns = true;

    public void setService() {
        this.service = !this.service;
    }

    public boolean isService() {
        return this.service;
    }

    public Rule(String string) {
        this.name = string;
    }

    protected Rule(String string, boolean bl) {
        this.name = string;
        this.can_add_patterns = bl;
    }

    public Rule(String string, int n) {
        this.name = string;
        this.setSalience(n);
    }

    protected Rule(String string, int n, boolean bl) {
        this.name = string;
        this.can_add_patterns = bl;
        this.setSalience(n);
    }

    public Rule(Rule rule) {
        int n;
        this.name = rule.name;
        this.salience = rule.salience;
        this.can_add_patterns = rule.can_add_patterns;
        for (n = 0; n < rule.patterns.size(); ++n) {
            Pattern pattern = (Pattern)rule.patterns.elementAt(n);
            this.patterns.addElement(new Pattern(pattern));
        }
        for (n = 0; n < rule.actions.size(); ++n) {
            Action action = (Action)rule.actions.elementAt(n);
            this.actions.addElement(new Action(action));
        }
    }

    public Rule duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public Rule duplicate(DuplicationTable duplicationTable) {
        int n;
        Rule rule = new Rule(this.name, this.salience, this.can_add_patterns);
        for (n = 0; n < this.patterns.size(); ++n) {
            Pattern pattern = (Pattern)this.patterns.elementAt(n);
            pattern = pattern.duplicate(duplicationTable);
            rule.patterns.addElement(pattern);
        }
        for (n = 0; n < this.actions.size(); ++n) {
            Action action = (Action)this.actions.elementAt(n);
            action = action.duplicate(duplicationTable);
            rule.actions.addElement(action);
        }
        return rule;
    }

    public void addPattern(Pattern pattern) {
        Assert.notFalse(this.can_add_patterns);
        if (this.patterns.isEmpty()) {
            switch (pattern.tag) {
                case 1: 
                case 2: {
                    this.patterns.addElement(new Pattern(initial_fact));
                    break;
                }
            }
        }
        this.patterns.addElement(pattern);
    }

    public void addAction(Action action) {
        this.can_add_patterns = false;
        if (this.patterns.isEmpty()) {
            this.patterns.addElement(new Pattern(initial_fact));
        }
        this.actions.addElement(action);
    }

    int nTerminals() {
        int n = 0;
        block3: for (int i = 0; i < this.patterns.size(); ++i) {
            Pattern pattern = (Pattern)this.patterns.elementAt(i);
            switch (pattern.tag) {
                case 0: 
                case 1: {
                    ++n;
                    continue block3;
                }
            }
        }
        return n;
    }

    public String getName() {
        return this.name;
    }

    public int getSalience() {
        return this.salience;
    }

    public void setName(String string) {
        Core.ERROR(string, 1, (Object)this);
        this.name = string;
    }

    public Vector getPatterns() {
        return this.patterns;
    }

    public void setSalience(int n) {
        if (n < 0 || n > 9) {
            Core.USER_ERROR("Invalid salience level: " + n);
            return;
        }
        this.salience = n;
    }

    public Vector getActions() {
        return this.actions;
    }

    public boolean resolve(Bindings bindings) {
        Action action;
        int n;
        Pattern pattern;
        boolean bl = true;
        for (n = 0; bl && n < this.patterns.size(); bl &= pattern.resolve(bindings), ++n) {
            pattern = (Pattern)this.patterns.elementAt(n);
        }
        for (n = 0; bl && n < this.actions.size(); bl &= action.resolve(bindings), ++n) {
            action = (Action)this.actions.elementAt(n);
        }
        return bl;
    }

    public String toString() {
        int n;
        String string = "(" + this.name + " ";
        if (this.salience != 0) {
            string = string + this.salience + " ";
        }
        for (n = 0; n < this.patterns.size(); ++n) {
            Pattern pattern = (Pattern)this.patterns.elementAt(n);
            string = string + Misc.spaces(3) + pattern.toString();
        }
        string = string + " " + Misc.spaces(3) + IMPLIES + " ";
        for (n = 0; n < this.actions.size(); ++n) {
            Action action = (Action)this.actions.elementAt(n);
            string = string + Misc.spaces(3) + action.toString();
        }
        string = string + ")";
        return string;
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        int n2;
        String string = Misc.spaces(n) + "(" + this.name;
        if (this.salience != 5) {
            string = string + " " + this.salience;
        }
        for (n2 = 0; n2 < this.patterns.size(); ++n2) {
            Pattern pattern = (Pattern)this.patterns.elementAt(n2);
            string = string + "\n" + Misc.spaces(3 + n) + pattern.toString();
        }
        string = string + "\n" + Misc.spaces(3 + n) + IMPLIES;
        for (n2 = 0; n2 < this.actions.size(); ++n2) {
            Action action = (Action)this.actions.elementAt(n2);
            string = string + "\n" + Misc.spaces(3 + n) + action.toString();
        }
        string = string + "\n" + Misc.spaces(n) + ")";
        return string;
    }
}

