/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.fn.ValueFunction;
import zeus.util.GenSym;
import zeus.util.Misc;

public class ReteFact {
    String type = null;
    public Hashtable data = null;

    public ReteFact(String string) {
        this.type = string;
        this.data = new Hashtable();
    }

    public ReteFact(ReteFact reteFact) {
        this.type = reteFact.type;
        this.data = new Hashtable();
        Enumeration enumeration = reteFact.data.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ValueFunction valueFunction = (ValueFunction)reteFact.data.get(string);
            this.data.put(string, valueFunction.mirror());
        }
    }

    public void setValue(String string, ValueFunction valueFunction) {
        this.data.put(string, valueFunction);
    }

    ValueFunction getValue(String string) {
        return (ValueFunction)this.data.get(string);
    }

    ValueFunction[] listValues() {
        ValueFunction[] valueFunctionArray = new ValueFunction[this.data.size()];
        Enumeration enumeration = this.data.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            valueFunctionArray[n] = (ValueFunction)enumeration.nextElement();
            ++n;
        }
        return valueFunctionArray;
    }

    String[] listAttributes() {
        String[] stringArray = new String[this.data.size()];
        Enumeration enumeration = this.data.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    ValueFunction[] variables() {
        Vector vector = new Vector();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            vector = Misc.union(vector, ((ValueFunction)enumeration.nextElement()).variables());
        }
        ValueFunction[] valueFunctionArray = new ValueFunction[vector.size()];
        for (int i = 0; i < valueFunctionArray.length; ++i) {
            valueFunctionArray[i] = (ValueFunction)vector.elementAt(i);
        }
        return valueFunctionArray;
    }

    public ReteFact duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public ReteFact duplicate(DuplicationTable duplicationTable) {
        ReteFact reteFact = new ReteFact(this.type);
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ValueFunction valueFunction = (ValueFunction)this.data.get(string);
            reteFact.data.put(string, valueFunction.duplicate(duplicationTable));
        }
        return reteFact;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean resolve(Bindings bindings) {
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ValueFunction valueFunction = (ValueFunction)this.data.get(string);
            if ((valueFunction = valueFunction.resolve(bindings)) == null) {
                return false;
            }
            this.data.put(string, valueFunction);
        }
        return true;
    }

    public String toString() {
        String string = "(" + this.type + " ";
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            ValueFunction valueFunction = (ValueFunction)this.data.get(string2);
            string = string + "(" + string2 + " " + valueFunction + ") ";
        }
        return string.trim() + ")";
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        return Misc.spaces(n) + this.toString();
    }
}

