/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.ResourceDb;
import zeus.actors.event.FactAdapter;
import zeus.actors.event.FactEvent;
import zeus.actors.event.ReteEngineEvent;
import zeus.actors.event.ReteEngineMonitor;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.concepts.ReteKB;
import zeus.concepts.fn.ValueFunction;
import zeus.rete.ActionNode;
import zeus.rete.AttributeNode;
import zeus.rete.ConflictSet;
import zeus.rete.IdNode;
import zeus.rete.JoinNode;
import zeus.rete.LocalFactMonitor;
import zeus.rete.Node;
import zeus.rete.NotNode;
import zeus.rete.Pattern;
import zeus.rete.ReteFact;
import zeus.rete.Rule;
import zeus.rete.TestNode;
import zeus.rete.TypeNode;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.Queue;

public class ReteEngine {
    static final int RULE_ACTIVATED = 0;
    static final int RULE_DEACTIVATED = 1;
    static final int RULE_ADDED = 2;
    static final int RULE_REMOVED = 3;
    static final int RULE_FIRED = 4;
    protected Hashtable factDb = new Hashtable();
    protected static final String PATH = "path#";
    protected static final String JPATH = "path@";
    protected Hashtable roots = new Hashtable();
    protected Hashtable ids = new Hashtable();
    protected Vector singles = new Vector();
    protected Vector joins = new Vector();
    protected Vector tests = new Vector();
    protected int pathNo = 0;
    protected int joinPathNo = 0;
    protected ConflictSet conflictSet;
    protected Fact initial_fact = null;
    protected AgentContext context = null;
    protected OntologyDb ontologyDb = null;
    private HSet[] eventMonitor = new HSet[5];
    private HSet localMonitor = new HSet();

    public ReteEngine() {
    }

    public ReteEngine(AgentContext agentContext) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        agentContext.set(this);
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
        this.conflictSet = new ConflictSet(agentContext);
        this.initial_fact = agentContext.OntologyDb().getFact(false, "ZeusFact");
        ResourceDb resourceDb = agentContext.ResourceDb();
        resourceDb.addFactMonitor(new SymFactAction(), 5L, true);
    }

    public ReteEngine(OntologyDb ontologyDb) {
        Assert.notNull(ontologyDb);
        this.ontologyDb = ontologyDb;
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
        this.conflictSet = new ConflictSet(this, ontologyDb);
        this.initial_fact = ontologyDb.getFact(false, "ZeusFact");
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public void run() {
        this.update(0, this.initial_fact);
        this.conflictSet.start();
    }

    public void reset() {
        this.conflictSet.reset();
        for (int i = 0; i < this.joins.size(); ++i) {
            JoinNode joinNode = (JoinNode)this.joins.elementAt(i);
            joinNode.reset();
        }
        Enumeration enumeration = this.factDb.elements();
        while (enumeration.hasMoreElements()) {
            this.update(0, (Fact)enumeration.nextElement());
        }
    }

    ConflictSet getConfictSet() {
        return this.conflictSet;
    }

    Hashtable getFactDb() {
        return this.factDb;
    }

    public void update(int n, ReteFact reteFact) {
        Fact fact = this.ontology().getFact(false, reteFact.type);
        Enumeration enumeration = reteFact.data.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ValueFunction valueFunction = (ValueFunction)reteFact.data.get(string);
            fact.setValue(string, valueFunction);
        }
        this.update(n, fact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int n, Fact fact) {
        Object object;
        if (this.context == null) {
            if (n == 0) {
                this.factDb.put(fact.getId(), fact);
            } else if (n == 1) {
                this.factDb.remove(fact.getId());
            }
        }
        this.fireLocalFactMonitor(n, fact);
        Vector<Fact> vector = new Vector<Fact>();
        vector.addElement(fact);
        boolean bl = false;
        TypeNode typeNode = (TypeNode)this.roots.get(fact.getType());
        if (typeNode != null) {
            bl = true;
            object = this.conflictSet.queue;
            synchronized (object) {
                typeNode.evaluate(null, n, 0, vector, new Bindings());
            }
        }
        object = this.ontology().allAncestors(fact.getType());
        while (object.hasNext() && !bl) {
            typeNode = (TypeNode)this.roots.get((String)object.next());
            if (typeNode == null) continue;
            bl = true;
            Queue queue = this.conflictSet.queue;
            synchronized (queue) {
                typeNode.evaluate(null, n, 0, vector, new Bindings());
            }
        }
    }

    private OntologyDb ontology() {
        return this.ontologyDb != null ? this.ontologyDb : this.context.OntologyDb();
    }

    public void add(ReteKB reteKB) {
        Rule[] ruleArray = reteKB.getRules();
        for (int i = 0; i < ruleArray.length; ++i) {
            ruleArray[i].setName(reteKB.getName() + "$" + ruleArray[i].getName());
            this.add(ruleArray[i]);
        }
    }

    public void add(Rule rule) {
        Object object;
        boolean bl;
        int n;
        Object object2;
        Object object3;
        ReteFact reteFact;
        String string;
        Pattern pattern;
        Object object4 = null;
        rule = rule.duplicate("var", this.ontology().GenSym());
        Core.DEBUG(2, "Compiling rule " + rule.name);
        Node[] nodeArray = new Node[rule.nTerminals()];
        int n2 = 0;
        int n3 = 0;
        while (n3 < rule.patterns.size()) {
            pattern = (Pattern)rule.patterns.elementAt(n3);
            switch (pattern.tag) {
                case 2: 
                case 3: {
                    --n2;
                    break;
                }
                default: {
                    int n4;
                    string = PATH + (this.pathNo + n2);
                    reteFact = (ReteFact)pattern.data;
                    if (this.roots.containsKey(reteFact.type)) {
                        nodeArray[n2] = (Node)this.roots.get(reteFact.type);
                        Core.DEBUG(4, "=t");
                        Core.DEBUG(5, "=t[" + nodeArray[n2] + "]");
                    } else {
                        nodeArray[n2] = new TypeNode(this, reteFact.type);
                        this.roots.put(reteFact.type, nodeArray[n2]);
                        Core.DEBUG(4, "+t");
                        Core.DEBUG(5, "+t[" + nodeArray[n2] + "]");
                    }
                    ++nodeArray[n2].use_count;
                    object4 = nodeArray[n2];
                    if (pattern.id != null) {
                        if (this.ids.containsKey(pattern.id)) {
                            nodeArray[n2] = (Node)this.ids.get(pattern.id);
                            Core.DEBUG(4, "=i");
                            Core.DEBUG(5, "=i[" + nodeArray[n2] + "]");
                        } else {
                            nodeArray[n2] = new IdNode(this, pattern.id);
                            this.ids.put(pattern.id, nodeArray[n2]);
                            Core.DEBUG(4, "+i");
                            Core.DEBUG(5, "+i[" + nodeArray[n2] + "]");
                        }
                        ++nodeArray[n2].use_count;
                        ((Node)object4).addSuccessor(string, nodeArray[n2], 0);
                        object4 = nodeArray[n2];
                    }
                    ValueFunction[] valueFunctionArray = reteFact.listValues();
                    object3 = reteFact.listAttributes();
                    object2 = new Vector();
                    for (n = 0; n < valueFunctionArray.length; ++n) {
                        if (valueFunctionArray[n].isDeterminate()) {
                            nodeArray[n2] = new AttributeNode(this, (String)object3[n], valueFunctionArray[n]);
                            bl = false;
                            for (n4 = 0; !bl && n4 < this.singles.size(); ++n4) {
                                bl = nodeArray[n2].equals(this.singles.elementAt(n4));
                                if (!bl) continue;
                                nodeArray[n2] = (Node)this.singles.elementAt(n4);
                            }
                            if (!bl) {
                                this.singles.addElement(nodeArray[n2]);
                                Core.DEBUG(4, "+d");
                                Core.DEBUG(5, "+d[" + nodeArray[n2] + "]");
                            } else {
                                Core.DEBUG(4, "=d");
                                Core.DEBUG(5, "=d[" + nodeArray[n2] + "]");
                            }
                            ++nodeArray[n2].use_count;
                            ((Node)object4).addSuccessor(string, nodeArray[n2], 0);
                            object4 = nodeArray[n2];
                            continue;
                        }
                        ((Vector)object2).addElement(object3[n]);
                        ((Vector)object2).addElement(valueFunctionArray[n]);
                    }
                    for (n = 0; n < ((Vector)object2).size(); n += 2) {
                        object = (String)((Vector)object2).elementAt(n);
                        ValueFunction valueFunction = (ValueFunction)((Vector)object2).elementAt(n + 1);
                        nodeArray[n2] = new AttributeNode(this, (String)object, valueFunction);
                        bl = false;
                        for (n4 = 0; !bl && n4 < this.singles.size(); ++n4) {
                            bl = nodeArray[n2].equals(this.singles.elementAt(n4));
                            if (!bl) continue;
                            nodeArray[n2] = (Node)this.singles.elementAt(n4);
                        }
                        if (!bl) {
                            this.singles.addElement(nodeArray[n2]);
                            Core.DEBUG(4, "+n");
                            Core.DEBUG(5, "+n[" + nodeArray[n2] + "]");
                        } else {
                            Core.DEBUG(4, "=n");
                            Core.DEBUG(5, "=n[" + nodeArray[n2] + "]");
                        }
                        ++nodeArray[n2].use_count;
                        ((Node)object4).addSuccessor(string, nodeArray[n2], 0);
                        object4 = nodeArray[n2];
                    }
                }
            }
            ++n3;
            ++n2;
        }
        n2 = 0;
        JoinNode[] joinNodeArray = new JoinNode[nodeArray.length - 1];
        int n5 = 1;
        while (n5 < rule.patterns.size()) {
            pattern = (Pattern)rule.patterns.elementAt(n5);
            switch (pattern.tag) {
                case 2: 
                case 3: {
                    --n2;
                    break;
                }
                default: {
                    reteFact = (ReteFact)pattern.data;
                    joinNodeArray[n2] = pattern.tag == 0 ? new JoinNode(this) : new NotNode(this);
                    object3 = reteFact.listValues();
                    object2 = reteFact.listAttributes();
                    object = reteFact.variables();
                    int n6 = -1;
                    for (n = 0; n < n5; ++n) {
                        int n7;
                        int n8;
                        pattern = (Pattern)rule.patterns.elementAt(n);
                        if (pattern.tag != 0) continue;
                        ++n6;
                        reteFact = (ReteFact)pattern.data;
                        ValueFunction[] valueFunctionArray = reteFact.listValues();
                        String[] stringArray = reteFact.listAttributes();
                        boolean[][] blArray = new boolean[valueFunctionArray.length][((Object)object3).length];
                        for (n8 = 0; n8 < blArray.length; ++n8) {
                            for (n7 = 0; n7 < blArray[n8].length; ++n7) {
                                blArray[n8][n7] = false;
                            }
                        }
                        for (n8 = 0; n8 < ((ValueFunction[])object).length; ++n8) {
                            for (n7 = 0; n7 < valueFunctionArray.length; ++n7) {
                                if (!valueFunctionArray[n7].references(object[n8])) continue;
                                for (int i = 0; i < ((Object)object3).length; ++i) {
                                    if (blArray[n7][i] || !((ValueFunction)object3[i]).references(object[n8])) continue;
                                    blArray[n7][i] = true;
                                    joinNodeArray[n2].add(n6, stringArray[n7], valueFunctionArray[n7], 0, (String)object2[i], (ValueFunction)object3[i]);
                                }
                            }
                        }
                    }
                }
            }
            ++n5;
            ++n2;
        }
        object3 = nodeArray[0];
        object2 = PATH + this.pathNo;
        n2 = 0;
        int n9 = 1;
        while (n9 < rule.patterns.size()) {
            pattern = (Pattern)rule.patterns.elementAt(n9);
            switch (pattern.tag) {
                case 3: {
                    --n2;
                    break;
                }
                case 2: {
                    int n10;
                    --n2;
                    object4 = object3;
                    object3 = new TestNode(this, (ValueFunction)pattern.data);
                    bl = false;
                    for (n10 = 0; !bl && n10 < this.tests.size(); ++n10) {
                        bl = object3.equals(this.tests.elementAt(n10));
                        if (!bl) continue;
                        object3 = (Node)this.tests.elementAt(n10);
                    }
                    if (!bl) {
                        this.tests.addElement(object3);
                        Core.DEBUG(4, "+c");
                        Core.DEBUG(5, "+c[" + object3 + "]");
                    } else {
                        Core.DEBUG(4, "=c");
                        Core.DEBUG(5, "=c[" + object3 + "]");
                    }
                    ++((Node)object3).use_count;
                    ((Node)object4).addSuccessor((String)object2, (Node)object3, 0);
                    break;
                }
                default: {
                    int n10;
                    bl = false;
                    for (n10 = 0; !bl && n10 < this.joins.size(); ++n10) {
                        bl = joinNodeArray[n2].equals(this.joins.elementAt(n10));
                        if (!bl) continue;
                        joinNodeArray[n2] = (JoinNode)this.joins.elementAt(n10);
                    }
                    if (!bl) {
                        this.joins.addElement(joinNodeArray[n2]);
                        Core.DEBUG(4, "+j");
                        Core.DEBUG(5, "+j[" + joinNodeArray[n2] + "]");
                    } else {
                        Core.DEBUG(4, "=j");
                        Core.DEBUG(5, "=j[" + joinNodeArray[n2] + "]");
                    }
                    ++joinNodeArray[n2].use_count;
                    string = JPATH + this.joinPathNo++;
                    String string2 = PATH + (this.pathNo + n2 + 1);
                    joinNodeArray[n2].addPath((String)object2, string2, string);
                    ((Node)object3).addSuccessor((String)object2, joinNodeArray[n2], 2);
                    nodeArray[n2 + 1].addSuccessor(string2, joinNodeArray[n2], 3);
                    object3 = joinNodeArray[n2];
                    object2 = string;
                }
            }
            ++n9;
            ++n2;
        }
        ActionNode actionNode = new ActionNode(this, rule.name, rule.salience, rule.actions);
        ++actionNode.use_count;
        ((Node)object3).addSuccessor((String)object2, actionNode, 1);
        Core.DEBUG(4, "+a");
        Core.DEBUG(5, "+a[" + actionNode + "]");
        this.pathNo += nodeArray.length;
        String string3 = "ADD [" + actionNode.rule_name + "]";
        this.fireEvent(2, actionNode, string3);
    }

    public void remove(Rule rule) {
        Core.USER_ERROR("Function ReteEngine.remove(Rule r) not yet implemented");
    }

    public void addLocalFactMonitor(LocalFactMonitor localFactMonitor) {
        this.localMonitor.add(localFactMonitor);
    }

    public void removeLocalFactMonitor(LocalFactMonitor localFactMonitor) {
        this.localMonitor.remove(localFactMonitor);
    }

    void fireLocalFactMonitor(int n, Fact fact) {
        Enumeration enumeration = this.localMonitor.elements();
        while (enumeration.hasMoreElements()) {
            LocalFactMonitor localFactMonitor = (LocalFactMonitor)enumeration.nextElement();
            if (n == 0) {
                localFactMonitor.reteFactAdded(fact);
                continue;
            }
            localFactMonitor.reteFactDeleted(fact);
        }
    }

    public void addMonitor(ReteEngineMonitor reteEngineMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[2].add(reteEngineMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[3].add(reteEngineMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[0].add(reteEngineMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[1].add(reteEngineMonitor);
        }
        if ((l & 0x10L) != 0L) {
            this.eventMonitor[4].add(reteEngineMonitor);
        }
    }

    public void removeMonitor(ReteEngineMonitor reteEngineMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[2].remove(reteEngineMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[3].remove(reteEngineMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[0].remove(reteEngineMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[1].remove(reteEngineMonitor);
        }
        if ((l & 0x10L) != 0L) {
            this.eventMonitor[4].remove(reteEngineMonitor);
        }
    }

    void fireEvent(int n, ActionNode actionNode, String string) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        switch (n) {
            case 2: {
                ReteEngineEvent reteEngineEvent = new ReteEngineEvent((Object)this, actionNode.rule_name, actionNode.salience, string, 1L);
                while (enumeration.hasMoreElements()) {
                    ReteEngineMonitor reteEngineMonitor = (ReteEngineMonitor)enumeration.nextElement();
                    reteEngineMonitor.reteRuleAddedEvent(reteEngineEvent);
                }
                break;
            }
            case 3: {
                ReteEngineEvent reteEngineEvent = new ReteEngineEvent((Object)this, actionNode.rule_name, actionNode.salience, string, 2L);
                while (enumeration.hasMoreElements()) {
                    ReteEngineMonitor reteEngineMonitor = (ReteEngineMonitor)enumeration.nextElement();
                    reteEngineMonitor.reteRuleDeletedEvent(reteEngineEvent);
                }
                break;
            }
            case 0: {
                ReteEngineEvent reteEngineEvent = new ReteEngineEvent((Object)this, actionNode.rule_name, actionNode.salience, string, 4L);
                while (enumeration.hasMoreElements()) {
                    ReteEngineMonitor reteEngineMonitor = (ReteEngineMonitor)enumeration.nextElement();
                    reteEngineMonitor.reteRuleActivatedEvent(reteEngineEvent);
                }
                break;
            }
            case 1: {
                ReteEngineEvent reteEngineEvent = new ReteEngineEvent((Object)this, actionNode.rule_name, actionNode.salience, string, 8L);
                while (enumeration.hasMoreElements()) {
                    ReteEngineMonitor reteEngineMonitor = (ReteEngineMonitor)enumeration.nextElement();
                    reteEngineMonitor.reteRuleDeactivatedEvent(reteEngineEvent);
                }
                break;
            }
            case 4: {
                ReteEngineEvent reteEngineEvent = new ReteEngineEvent((Object)this, actionNode.rule_name, actionNode.salience, string, 16L);
                while (enumeration.hasMoreElements()) {
                    ReteEngineMonitor reteEngineMonitor = (ReteEngineMonitor)enumeration.nextElement();
                    reteEngineMonitor.reteRuleFiredEvent(reteEngineEvent);
                }
                break;
            }
        }
    }

    protected class SymFactAction
    extends FactAdapter {
        protected SymFactAction() {
        }

        public void factAddedEvent(FactEvent factEvent) {
            Fact fact = factEvent.getFact();
            ReteEngine.this.update(0, fact);
        }

        public void factDeletedEvent(FactEvent factEvent) {
            Fact fact = factEvent.getFact();
            ReteEngine.this.update(1, fact);
        }
    }
}

