/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete;

import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.fn.ValueFunction;
import zeus.concepts.fn.VarFn;
import zeus.rete.ReteFact;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.GenSym;
import zeus.util.Misc;

public class Pattern {
    static final String FACT_MARKER = "<-";
    static final String NEGATION = "not";
    static final String TEST_NAME = "test";
    public static final int NONE = 0;
    public static final int NOT = 1;
    public static final int TEST = 2;
    public static final int CMD = 3;
    VarFn id = null;
    int tag = 0;
    Object data = null;

    public Pattern(ReteFact reteFact) {
        this.data = reteFact;
    }

    public Pattern(int n, ReteFact reteFact) {
        Assert.notFalse(n == 1 || n == 0);
        this.tag = n;
        this.data = reteFact;
    }

    public Pattern(int n, ValueFunction valueFunction) {
        Assert.notFalse(n == 2);
        this.tag = n;
        this.data = valueFunction;
    }

    public Pattern(Pattern pattern) {
        this.tag = pattern.tag;
        this.id = pattern.id;
        switch (pattern.tag) {
            case 0: 
            case 1: {
                this.data = new ReteFact((ReteFact)pattern.data);
                break;
            }
            case 2: {
                this.data = ((ValueFunction)pattern.data).mirror();
            }
        }
    }

    public void setId(VarFn varFn) {
        this.id = varFn;
    }

    Pattern duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    Pattern duplicate(DuplicationTable duplicationTable) {
        switch (this.tag) {
            case 0: 
            case 1: {
                ReteFact reteFact = (ReteFact)this.data;
                reteFact = reteFact.duplicate(duplicationTable);
                Pattern pattern = new Pattern(this.tag, reteFact);
                if (this.id != null) {
                    pattern.id = (VarFn)this.id.duplicate(duplicationTable);
                }
                return pattern;
            }
            case 2: {
                ValueFunction valueFunction = (ValueFunction)this.data;
                valueFunction = valueFunction.duplicate(duplicationTable);
                Pattern pattern = new Pattern(this.tag, valueFunction);
                return pattern;
            }
        }
        return this;
    }

    public boolean resolve(Bindings bindings) {
        if (this.id != null && (this.id = (VarFn)this.id.resolve(bindings)) == null) {
            return false;
        }
        switch (this.tag) {
            case 0: 
            case 1: {
                ReteFact reteFact = (ReteFact)this.data;
                return reteFact.resolve(bindings);
            }
            case 2: {
                ValueFunction valueFunction = (ValueFunction)this.data;
                valueFunction = valueFunction.resolve(bindings);
                return valueFunction != null;
            }
        }
        return false;
    }

    public String toString() {
        switch (this.tag) {
            case 0: {
                if (this.id == null) {
                    return this.data.toString();
                }
                return this.id.toString() + " " + FACT_MARKER + " " + this.data.toString();
            }
            case 1: {
                return "(not " + this.data.toString() + ")";
            }
            case 2: {
                return "(test " + this.data.toString() + ")";
            }
        }
        Core.ERROR(null, 1, (Object)this);
        return null;
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        switch (this.tag) {
            case 0: {
                return Misc.spaces(n) + this.data.toString();
            }
            case 1: {
                return Misc.spaces(n) + "(" + NEGATION + " " + this.data.toString() + ")";
            }
            case 2: {
                return Misc.spaces(n) + "(" + TEST_NAME + " " + this.data.toString() + ")";
            }
        }
        Core.ERROR(null, 1, (Object)this);
        return null;
    }
}

