/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.fn.ValueFunction;
import zeus.rete.PatternNode;
import zeus.rete.ReteEngine;
import zeus.util.Assert;

class AttributeNode
extends PatternNode {
    ValueFunction value = null;
    String attribute = null;

    AttributeNode(ReteEngine reteEngine, String string, ValueFunction valueFunction) {
        super(reteEngine);
        this.attribute = string;
        this.value = valueFunction;
    }

    void evaluate(String string, int n, int n2, Vector vector, Bindings bindings) {
        Assert.notFalse(n2 == 0);
        Assert.notFalse(vector.size() == 1);
        Fact fact = (Fact)vector.elementAt(0);
        ValueFunction valueFunction = fact.getFn(this.attribute);
        if (valueFunction != null && this.value.unifiesWith(valueFunction, bindings) != null) {
            this.propagate(string, n, vector, bindings);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AttributeNode) {
            AttributeNode attributeNode = (AttributeNode)object;
            return this.attribute.equals(attributeNode.attribute) && this.value.equals(attributeNode.value);
        }
        return false;
    }

    public String toString() {
        return "AttributeNode(" + this.attribute + "," + this.value + ")";
    }
}

