/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.fn.ValueFunction;
import zeus.rete.ReteFact;
import zeus.util.Core;
import zeus.util.GenSym;
import zeus.util.Misc;

public class Action {
    public static final int ASSERT = 0;
    public static final int RETRACT = 1;
    public static final int MODIFY = 2;
    public static final int PRINT = 3;
    public static final int MESSAGE = 4;
    public static final int ACHIEVE = 5;
    public static final int BUY = 6;
    public static final int SELL = 7;
    public static final int EXECUTE = 8;
    public static final int BIND = 9;
    public static final int IF = 10;
    public static final int WHILE = 11;
    public static final int OPEN = 12;
    public static final int CLOSE = 13;
    public static final int READ = 14;
    public static final int READLN = 15;
    public static final int SYSTEM = 16;
    public static final int CALL = 17;
    public static final int PRINTLN = 18;
    public static final String[] types = new String[]{"assert", "retract", "modify", "print", "send_message", "achieve", "buy", "sell", "execute", "bind", "if", "while", "open", "close", "read", "readln", "system", "call", "println"};
    public int type = -1;
    public Vector items = null;
    public Hashtable table = null;
    public Object head = null;
    public Object sub_head = null;
    public Object sub_sub_head = null;
    public Vector sub_items = null;

    public Action(String string) {
        this(Misc.whichPosition(string, types));
    }

    public Action(int n) {
        this.type = n;
        switch (n) {
            case 0: 
            case 8: {
                break;
            }
            case 1: {
                this.items = new Vector(10);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.table = new Hashtable();
                break;
            }
            case 10: {
                this.items = new Vector(10);
                this.sub_items = new Vector(10);
                break;
            }
            case 11: {
                this.items = new Vector(10);
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 16: 
            case 18: {
                this.items = new Vector(10);
                break;
            }
            case 9: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                Core.USER_ERROR("Unknown action type " + n);
            }
        }
    }

    public Action(Action action) {
        this.type = action.type;
        switch (this.type) {
            case 0: {
                this.head = new ReteFact((ReteFact)action.head);
                break;
            }
            case 8: 
            case 13: {
                this.head = ((ValueFunction)action.head).mirror();
                break;
            }
            case 1: 
            case 16: {
                this.items = new Vector(10);
                for (int i = 0; i < action.items.size(); ++i) {
                    ValueFunction valueFunction = (ValueFunction)action.items.elementAt(i);
                    this.items.addElement(valueFunction.mirror());
                }
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.table = new Hashtable();
                Enumeration enumeration = action.table.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    ValueFunction valueFunction = (ValueFunction)action.table.get(k);
                    this.table.put(k, valueFunction.mirror());
                }
                switch (this.type) {
                    case 2: {
                        this.head = ((ValueFunction)action.head).mirror();
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        this.head = new ReteFact((ReteFact)action.head);
                    }
                }
                break;
            }
            case 3: 
            case 18: {
                this.head = ((ValueFunction)action.head).mirror();
                this.items = new Vector(10);
                for (int i = 0; i < action.items.size(); ++i) {
                    ValueFunction valueFunction = (ValueFunction)action.items.elementAt(i);
                    this.items.addElement(valueFunction.mirror());
                }
                break;
            }
            case 10: {
                Action action2;
                int n;
                this.head = ((ValueFunction)action.head).mirror();
                this.items = new Vector(10);
                for (n = 0; n < action.items.size(); ++n) {
                    action2 = (Action)action.items.elementAt(n);
                    this.items.addElement(new Action(action2));
                }
                this.sub_items = new Vector(10);
                for (n = 0; n < action.sub_items.size(); ++n) {
                    action2 = (Action)action.sub_items.elementAt(n);
                    this.sub_items.addElement(new Action(action2));
                }
                break;
            }
            case 11: {
                this.head = ((ValueFunction)action.head).mirror();
                this.items = new Vector(10);
                for (int i = 0; i < action.items.size(); ++i) {
                    Action action3 = (Action)action.items.elementAt(i);
                    this.items.addElement(new Action(action3));
                }
                break;
            }
            case 12: {
                this.head = ((ValueFunction)action.head).mirror();
                this.sub_head = ((ValueFunction)action.sub_head).mirror();
                this.sub_sub_head = ((ValueFunction)action.sub_sub_head).mirror();
                break;
            }
            case 9: 
            case 14: 
            case 15: {
                this.head = ((ValueFunction)action.head).mirror();
                this.sub_head = ((ValueFunction)action.sub_head).mirror();
            }
        }
    }

    public Action duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public Action duplicate(DuplicationTable duplicationTable) {
        Action action = new Action(this.type);
        switch (this.type) {
            case 0: {
                action.head = ((ReteFact)this.head).duplicate(duplicationTable);
                break;
            }
            case 8: 
            case 13: {
                action.head = ((ValueFunction)this.head).duplicate(duplicationTable);
                break;
            }
            case 1: 
            case 16: {
                for (int i = 0; i < this.items.size(); ++i) {
                    ValueFunction valueFunction = (ValueFunction)this.items.elementAt(i);
                    valueFunction = valueFunction.duplicate(duplicationTable);
                    action.items.addElement(valueFunction);
                }
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Enumeration enumeration = this.table.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    ValueFunction valueFunction = (ValueFunction)this.table.get(k);
                    valueFunction = valueFunction.duplicate(duplicationTable);
                    action.table.put(k, valueFunction);
                }
                switch (this.type) {
                    case 2: {
                        action.head = ((ValueFunction)this.head).duplicate(duplicationTable);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        action.head = ((ReteFact)this.head).duplicate(duplicationTable);
                    }
                }
                break;
            }
            case 3: 
            case 18: {
                action.head = ((ValueFunction)this.head).duplicate(duplicationTable);
                for (int i = 0; i < this.items.size(); ++i) {
                    ValueFunction valueFunction = (ValueFunction)this.items.elementAt(i);
                    valueFunction = valueFunction.duplicate(duplicationTable);
                    action.items.addElement(valueFunction);
                }
                break;
            }
            case 10: {
                Action action2;
                int n;
                action.head = ((ValueFunction)this.head).duplicate(duplicationTable);
                action.items = new Vector(10);
                for (n = 0; n < this.items.size(); ++n) {
                    action2 = (Action)this.items.elementAt(n);
                    action.items.addElement(action2.duplicate(duplicationTable));
                }
                action.sub_items = new Vector(10);
                for (n = 0; n < this.sub_items.size(); ++n) {
                    action2 = (Action)this.sub_items.elementAt(n);
                    action.sub_items.addElement(action2.duplicate(duplicationTable));
                }
                break;
            }
            case 11: {
                action.head = ((ValueFunction)this.head).duplicate(duplicationTable);
                action.items = new Vector(10);
                for (int i = 0; i < this.items.size(); ++i) {
                    Action action3 = (Action)this.items.elementAt(i);
                    action.items.addElement(action3.duplicate(duplicationTable));
                }
                break;
            }
            case 12: {
                action.head = ((ValueFunction)this.head).duplicate(duplicationTable);
                action.sub_head = ((ValueFunction)this.sub_head).duplicate(duplicationTable);
                action.sub_sub_head = ((ValueFunction)this.sub_sub_head).duplicate(duplicationTable);
                break;
            }
            case 9: 
            case 14: 
            case 15: {
                action.head = ((ValueFunction)this.head).duplicate(duplicationTable);
                action.sub_head = ((ValueFunction)this.sub_head).duplicate(duplicationTable);
            }
        }
        return action;
    }

    public boolean resolve(Bindings bindings) {
        switch (this.type) {
            case 0: {
                return ((ReteFact)this.head).resolve(bindings);
            }
            case 8: {
                this.head = ((ValueFunction)this.head).resolve(bindings);
                return this.head != null;
            }
            case 1: 
            case 16: {
                for (int i = 0; i < this.items.size(); ++i) {
                    ValueFunction valueFunction = (ValueFunction)this.items.elementAt(i);
                    if ((valueFunction = valueFunction.resolve(bindings)) == null) {
                        return false;
                    }
                    this.items.setElementAt(valueFunction, i);
                }
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Enumeration enumeration = this.table.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    ValueFunction valueFunction = (ValueFunction)this.table.get(k);
                    if ((valueFunction = valueFunction.resolve(bindings)) == null) {
                        return false;
                    }
                    this.table.put(k, valueFunction);
                }
                switch (this.type) {
                    case 2: {
                        this.head = ((ValueFunction)this.head).resolve(bindings);
                        if (this.head != null) break;
                        return false;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        return ((ReteFact)this.head).resolve(bindings);
                    }
                }
                break;
            }
            case 3: 
            case 18: {
                this.head = ((ValueFunction)this.head).resolve(bindings);
                if (this.head == null) {
                    return false;
                }
                for (int i = 0; i < this.items.size(); ++i) {
                    ValueFunction valueFunction = (ValueFunction)this.items.elementAt(i);
                    if ((valueFunction = valueFunction.resolve(bindings)) == null) {
                        return false;
                    }
                    this.items.setElementAt(valueFunction, i);
                }
                break;
            }
            case 10: {
                Action action;
                int n;
                this.head = ((ValueFunction)this.head).resolve(bindings);
                if (this.head == null) {
                    return false;
                }
                for (n = 0; n < this.items.size(); ++n) {
                    action = (Action)this.items.elementAt(n);
                    if (action.resolve(bindings)) continue;
                    return false;
                }
                for (n = 0; n < this.sub_items.size(); ++n) {
                    action = (Action)this.sub_items.elementAt(n);
                    if (action.resolve(bindings)) continue;
                    return false;
                }
                break;
            }
            case 11: {
                this.head = ((ValueFunction)this.head).resolve(bindings);
                if (this.head == null) {
                    return false;
                }
                for (int i = 0; i < this.items.size(); ++i) {
                    Action action = (Action)this.items.elementAt(i);
                    if (action.resolve(bindings)) continue;
                    return false;
                }
                break;
            }
            case 12: {
                this.head = ((ValueFunction)this.head).resolve(bindings);
                this.sub_head = ((ValueFunction)this.sub_head).resolve(bindings);
                this.sub_sub_head = ((ValueFunction)this.sub_sub_head).resolve(bindings);
                return this.head != null && this.sub_head != null && this.sub_sub_head != null;
            }
            case 9: 
            case 14: 
            case 15: {
                this.head = ((ValueFunction)this.head).resolve(bindings);
                this.sub_head = ((ValueFunction)this.sub_head).resolve(bindings);
                return this.head != null && this.sub_head != null;
            }
        }
        return true;
    }

    public String toString() {
        String string = "(" + types[this.type] + " ";
        switch (this.type) {
            case 0: {
                string = string + this.head;
                break;
            }
            case 8: 
            case 13: {
                string = string + this.head;
                break;
            }
            case 1: 
            case 16: {
                string = string + Misc.concat(this.items);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                switch (this.type) {
                    case 2: {
                        string = string + this.head + " ";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        string = string + "(fact " + this.head + ") ";
                    }
                }
                Enumeration enumeration = this.table.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    ValueFunction valueFunction = (ValueFunction)this.table.get(k);
                    string = string + "(" + k + " " + valueFunction + ") ";
                }
                break;
            }
            case 3: 
            case 18: {
                string = string + this.head + " " + Misc.concat(this.items);
                break;
            }
            case 10: {
                string = string + this.head + " then\n " + Misc.concat(this.items);
                if (this.sub_items.isEmpty()) break;
                string = string + "\n else\n " + Misc.concat(this.sub_items);
                break;
            }
            case 11: {
                string = string + this.head + " do\n " + Misc.concat(this.items);
                break;
            }
            case 12: {
                string = string + this.head + " " + this.sub_head + " " + this.sub_sub_head;
                break;
            }
            case 9: 
            case 14: 
            case 15: {
                string = string + this.head + " " + this.sub_head;
            }
        }
        return string.trim() + ")";
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        return Misc.spaces(n) + this.toString();
    }
}

