/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.restrictions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.concepts.OntologyDb;
import zeus.gui.editors.ExpressionCellEditor;
import zeus.gui.editors.ValidatingCellRenderer;
import zeus.gui.fields.NameField;
import zeus.gui.help.HelpWindow;
import zeus.ontology.TypeDialog;
import zeus.ontology.TypeSelector;
import zeus.ontology.restrictions.RestrictionTableModel;
import zeus.util.SystemProps;

public class RestrictionTableUI
extends JPanel {
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};
    protected JTable table;
    protected RestrictionTableModel model;
    protected String[][] clipboard = null;

    public RestrictionTableUI(OntologyDb ontologyDb) {
        this.model = new RestrictionTableModel(ontologyDb);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12, new DefaultTableCellRenderer(), new DefaultCellEditor(new NameField()));
        tableColumn.setHeaderValue(this.model.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 12, new ValidatingCellRenderer(this.model), new TypeCellEditor(ontologyDb));
        tableColumn.setHeaderValue(this.model.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 24, new ValidatingCellRenderer(this.model), new ExpressionCellEditor(this.model));
        tableColumn.setHeaderValue(this.model.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        this.table = new JTable(this.model, defaultTableColumnModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(420, 100));
        this.table.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Known Restrictions");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        this.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RestrictionToolBar restrictionToolBar = new RestrictionToolBar();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        gridBagLayout.setConstraints(restrictionToolBar, gridBagConstraints);
        this.add(restrictionToolBar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 16, 16, 16);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
    }

    private void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    void addRows(String[][] stringArray) {
        this.model.addRows(stringArray);
    }

    void deleteSelected() {
        if (this.table.getSelectedRow() == -1) {
            this.errorMsg(1);
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        this.model.deleteRows(nArray);
    }

    String[][] getSelectedRows() {
        if (this.table.getSelectedRow() == -1) {
            this.errorMsg(1);
            return new String[0][0];
        }
        int[] nArray = this.table.getSelectedRows();
        return this.model.getRows(nArray);
    }

    String[][] cutSelectedRows() {
        String[][] stringArray = this.getSelectedRows();
        if (stringArray.length > 0) {
            this.deleteSelected();
        }
        return stringArray;
    }

    public class RestrictionToolBar
    extends JToolBar
    implements ActionListener {
        protected HelpWindow helpWin;
        protected JButton newBtn;
        protected JButton deleteBtn;
        protected JButton cutBtn;
        protected JButton copyBtn;
        protected JButton pasteBtn;
        protected JToggleButton helpBtn;

        public RestrictionToolBar() {
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "ontology" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("New");
            this.newBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.cutBtn = new JButton(new ImageIcon(string2 + "cut.gif"));
            this.cutBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.cutBtn);
            this.cutBtn.setToolTipText("Cut");
            this.cutBtn.addActionListener(this);
            this.copyBtn = new JButton(new ImageIcon(string2 + "copy.gif"));
            this.copyBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.copyBtn);
            this.copyBtn.setToolTipText("Copy");
            this.copyBtn.addActionListener(this);
            this.pasteBtn = new JButton(new ImageIcon(string2 + "paste.gif"));
            this.pasteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.pasteBtn);
            this.pasteBtn.setToolTipText("Paste");
            this.pasteBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                RestrictionTableUI.this.model.addNewRow();
            } else if (object == this.deleteBtn) {
                RestrictionTableUI.this.deleteSelected();
            } else if (object == this.copyBtn) {
                RestrictionTableUI.this.clipboard = RestrictionTableUI.this.getSelectedRows();
            } else if (object == this.pasteBtn) {
                RestrictionTableUI.this.addRows(RestrictionTableUI.this.clipboard);
            } else if (object == this.cutBtn) {
                RestrictionTableUI.this.clipboard = RestrictionTableUI.this.cutSelectedRows();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), this.getLocation(), "ontology", "Restriction Table");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    class TypeCellEditor
    extends DefaultCellEditor
    implements ActionListener,
    TypeSelector {
        protected JButton button = new JButton("");
        protected int row;
        protected int column;
        protected TypeDialog dialog;

        public TypeCellEditor(OntologyDb ontologyDb) {
            super(new JTextField());
            this.setClickCountToStart(2);
            this.dialog = new TypeDialog((Frame)SwingUtilities.getRoot(RestrictionTableUI.this.table), ontologyDb, 1);
            this.button.setBackground(Color.white);
            this.button.setHorizontalAlignment(2);
            this.button.setBorderPainted(false);
            this.button.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.button) {
                this.dialog.setLocationRelativeTo(this.button);
                this.fireEditingCanceled();
                this.dialog.display(this);
            }
        }

        public void typeSelected(String string) {
            RestrictionTableUI.this.model.setValueAt(string, this.row, this.column);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            this.button.setText(object.toString());
            return this.button;
        }
    }
}

