/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.facts;

import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import zeus.concepts.OntologyDb;
import zeus.concepts.OntologyDbChangeEvent;
import zeus.util.TreeNode;

public class FactTreeModel
extends DefaultTreeModel
implements ChangeListener {
    static final String[] ERROR_MESSAGE = new String[]{"Rename failed"};
    protected OntologyDb model;

    public FactTreeModel(OntologyDb ontologyDb) {
        super(new DefaultMutableTreeNode(ontologyDb.getRoot()));
        this.model = ontologyDb;
        this.createTree((DefaultMutableTreeNode)this.getRoot(), ontologyDb.getRoot());
        ontologyDb.addChangeListener(this);
    }

    protected void createTree(DefaultMutableTreeNode defaultMutableTreeNode, TreeNode treeNode) {
        Vector vector = treeNode.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            TreeNode treeNode2 = (TreeNode)vector.elementAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(treeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.createTree(defaultMutableTreeNode2, treeNode2);
        }
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        String string = (String)object;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        String string2 = defaultMutableTreeNode.getUserObject().toString();
        if (string2.equals(string)) {
            return;
        }
        Object object2 = this.model.renameFact(string2, string);
        if (object2 != null) {
            defaultMutableTreeNode.setUserObject(object2);
            this.nodeChanged(defaultMutableTreeNode);
        } else {
            this.errorMsg(0);
        }
    }

    void refresh() {
        this.root = new DefaultMutableTreeNode(this.model.getRoot());
        this.createTree((DefaultMutableTreeNode)this.root, this.model.getRoot());
        this.reload();
    }

    void errorMsg(int n) {
        JOptionPane.showMessageDialog(null, ERROR_MESSAGE[n], "Error", 0);
    }

    public boolean isEditable(String string) {
        return this.model.isFactEditable(string);
    }

    void addNewChild(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode treeNode = (TreeNode)defaultMutableTreeNode.getUserObject();
        TreeNode treeNode2 = this.model.addChildFact(treeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(treeNode2);
        this.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
    }

    Object renameFact(String string, String string2) {
        return this.model.renameFact(string, string2);
    }

    void removeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null && defaultMutableTreeNode != (DefaultMutableTreeNode)this.getRoot()) {
            this.model.removeFact((TreeNode)defaultMutableTreeNode.getUserObject());
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            this.removeNodeFromParent(defaultMutableTreeNode);
            this.nodeStructureChanged(defaultMutableTreeNode2);
        }
    }

    DefaultMutableTreeNode cutNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null && defaultMutableTreeNode != (DefaultMutableTreeNode)this.getRoot()) {
            this.model.removeFact((TreeNode)defaultMutableTreeNode.getUserObject());
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            this.removeNodeFromParent(defaultMutableTreeNode);
            this.nodeStructureChanged(defaultMutableTreeNode2);
            return defaultMutableTreeNode;
        }
        return null;
    }

    DefaultMutableTreeNode copyNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null) {
            TreeNode treeNode = (TreeNode)defaultMutableTreeNode.getUserObject();
            TreeNode treeNode2 = this.model.copyFactTree(treeNode);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(treeNode2);
            this.createTree(defaultMutableTreeNode2, treeNode2);
            return defaultMutableTreeNode2;
        }
        return null;
    }

    void pasteNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        if (defaultMutableTreeNode2 != null) {
            TreeNode treeNode = (TreeNode)defaultMutableTreeNode.getUserObject();
            TreeNode treeNode2 = (TreeNode)defaultMutableTreeNode2.getUserObject();
            TreeNode treeNode3 = this.model.pasteFactTree(treeNode, treeNode2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(treeNode3);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            this.createTree(defaultMutableTreeNode3, treeNode3);
            this.nodeStructureChanged(defaultMutableTreeNode);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        OntologyDbChangeEvent ontologyDbChangeEvent = (OntologyDbChangeEvent)changeEvent;
        if (ontologyDbChangeEvent.getEventType() == 0) {
            this.refresh();
        }
    }
}

