/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.database;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.ontology.database.ColumnsTableModel;
import zeus.ontology.database.DatabasePane;

public class ColumnsTableUI
extends JPanel {
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};
    protected JTable table;
    protected ColumnsTableModel model;
    protected DatabasePane DBPane = null;

    public ColumnsTableUI(DatabasePane databasePane) {
        this.DBPane = databasePane;
        this.model = new ColumnsTableModel(databasePane);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 60);
        tableColumn.setHeaderValue(this.model.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        this.table = new JTable(this.model, defaultTableColumnModel);
        tableColumn = new TableColumn(1, 60);
        tableColumn.setHeaderValue(this.model.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        this.table = new JTable(this.model, defaultTableColumnModel);
        tableColumn = new TableColumn(2, 60);
        tableColumn.setHeaderValue(this.model.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        this.table = new JTable(this.model, defaultTableColumnModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(300, 180));
        this.table.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 16, 16, 16);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SymListAction());
    }

    public ColumnsTableModel getModel() {
        return this.model;
    }

    public JTable getTable() {
        return this.table;
    }

    private void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    String[][] getSelectedRows() {
        if (this.table.getSelectedRow() == -1) {
            this.errorMsg(1);
            return new String[0][0];
        }
        int[] nArray = this.table.getSelectedRows();
        return this.model.getRows(nArray);
    }

    class SymListAction
    implements ListSelectionListener {
        SymListAction() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ColumnsTableUI.this.DBPane.importBtn.setEnabled(true);
        }
    }
}

