/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.OntologyDb;
import zeus.ext.DbConnector;
import zeus.ontology.database.DatabasePane;

public class ColumnsTableModel
extends AbstractTableModel {
    protected String[] columnNames = new String[]{"Column", "Type", "Zeus Equivalent"};
    protected String[][] data = null;
    protected boolean[][] validityInfo = null;
    protected DatabasePane DBPane = null;
    protected DbConnector MYDB = null;

    public ColumnsTableModel(DatabasePane databasePane) {
        this.DBPane = databasePane;
    }

    void refresh() {
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data != null ? this.data.length : 0;
    }

    public String[] getRow(int n) {
        return this.data[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public boolean isValidEntry(int n, int n2) {
        return this.validityInfo[n][n2];
    }

    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    public String mapTypeToOntology(int n) {
        if (n == 12 || n == -1 || n == 2005 || n == 1) {
            OntologyDb cfr_ignored_0 = this.DBPane.ONTDB;
            return "String";
        }
        if (n == -7 || n == -3) {
            OntologyDb cfr_ignored_1 = this.DBPane.ONTDB;
            return "Boolean";
        }
        if (n == 4 || n == 5 || n == -6) {
            OntologyDb cfr_ignored_2 = this.DBPane.ONTDB;
            return "Integer";
        }
        if (n == 3 || n == 8 || n == 6) {
            OntologyDb cfr_ignored_3 = this.DBPane.ONTDB;
            return "Real";
        }
        if (n == 91) {
            OntologyDb cfr_ignored_4 = this.DBPane.ONTDB;
            return "Date";
        }
        if (n == 92 || n == 93) {
            OntologyDb cfr_ignored_5 = this.DBPane.ONTDB;
            return "Time";
        }
        return "Not supported";
    }

    public void setValues(ResultSet resultSet, int n) {
        try {
            this.data = new String[n][3];
            int n2 = 0;
            while (resultSet.next()) {
                String string;
                String string2;
                String string3;
                this.data[n2][0] = string3 = resultSet.getString(4);
                this.data[n2][1] = string2 = resultSet.getString(6);
                this.data[n2][2] = string = this.mapTypeToOntology(resultSet.getInt(5));
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            this.DBPane.messageArea.append("\nSQL Exception: " + sQLException + "\n");
        }
    }

    public void refreshColumns(String string) {
        this.MYDB = this.DBPane.MYDB;
        this.DBPane.messageArea.append("Getting columns of " + string);
        try {
            DatabaseMetaData databaseMetaData = this.MYDB.getConnection().getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(null, null, string, "%");
            int n = 0;
            while (resultSet.next()) {
                ++n;
            }
            resultSet = databaseMetaData.getColumns(null, null, string, "%");
            this.setValues(resultSet, n);
            this.MYDB.close();
            this.DBPane.messageArea.append(" .. OK\n");
        }
        catch (SQLException sQLException) {
            this.DBPane.messageArea.append("\nSQL Exception: " + sQLException + "\n");
        }
        this.refresh();
    }

    String[][] getRows(int[] nArray) {
        String[][] stringArray = new String[nArray.length][this.columnNames.length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                stringArray[i][j] = this.data[nArray[i]][j];
            }
        }
        return stringArray;
    }
}

