/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.attributes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.concepts.OntologyDb;
import zeus.gui.editors.ExpressionCellEditor;
import zeus.gui.editors.ValidatingCellRenderer;
import zeus.gui.fields.NameField;
import zeus.gui.help.HelpWindow;
import zeus.ontology.OntologyEditor;
import zeus.ontology.TypeDialog;
import zeus.ontology.TypeSelector;
import zeus.ontology.attributes.AttributeTableModel;
import zeus.util.SystemProps;

public class AttributeTablePanel
extends JPanel {
    protected JTable table;
    protected TitledBorder border;
    protected AttributeToolBar toolbar;
    protected OntologyEditor parent;
    protected String currentName = null;
    protected boolean showState = false;
    protected AttributeTableModel model;
    protected String[][] clipboard = null;
    static final String[] ERROR_MESSAGE = new String[]{"Please select a fact before\ncalling this operation", "Please select a row before\ncalling this operation"};

    public AttributeTablePanel(OntologyEditor ontologyEditor, OntologyDb ontologyDb) {
        this.parent = ontologyEditor;
        this.model = new AttributeTableModel(ontologyDb);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12, new NameCellRenderer(), new DefaultCellEditor(new NameField()));
        tableColumn.setHeaderValue(this.model.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 12, new ValidatingCellRenderer(this.model), new TypeCellEditor(ontologyDb));
        tableColumn.setHeaderValue(this.model.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 24, new ValidatingCellRenderer(this.model), new ExpressionCellEditor(this.model));
        tableColumn.setHeaderValue(this.model.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(3, 24, new ValidatingCellRenderer(this.model), new ExpressionCellEditor(this.model));
        tableColumn.setHeaderValue(this.model.getColumnName(3));
        defaultTableColumnModel.addColumn(tableColumn);
        this.table = new JTable(this.model, defaultTableColumnModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(420, 100));
        this.table.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(15, 15, 15, 15)));
        JPanel jPanel = new JPanel();
        this.border = BorderFactory.createTitledBorder("Fact Attributes");
        this.border.setTitlePosition(2);
        this.border.setTitleJustification(3);
        this.border.setTitleFont(new Font("Helvetica", 1, 14));
        this.border.setTitleColor(Color.blue);
        jPanel.setBorder(this.border);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.toolbar = new AttributeToolBar();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        gridBagLayout.setConstraints(this.toolbar, gridBagConstraints);
        jPanel.add(this.toolbar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 16, 16, 16);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        this.add("Center", jPanel);
    }

    public void displayAttributes(String string) {
        this.currentName = string;
        this.updateDisplay(this.showState);
    }

    void updateDisplay(boolean bl) {
        this.showState = bl;
        if (this.showState) {
            this.border.setTitle("All Attributes of '" + this.currentName + "'");
            this.model.refreshAllAttributes(this.currentName);
        } else {
            this.border.setTitle("The Attributes specific to '" + this.currentName + "'");
            this.model.refreshAttributes(this.currentName);
        }
        this.toolbar.activate(this.model.isNodeEditable());
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void clear() {
        this.currentName = null;
        this.border.setTitle("No Attributes Shown");
        this.displayAttributes(this.currentName);
        this.validate();
        this.repaint();
    }

    AttributeTableModel getModel() {
        return this.model;
    }

    private void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    void addNewRow() {
        if (this.currentName == null) {
            this.errorMsg(0);
            return;
        }
        this.model.addNewRow();
    }

    void addRows(String[][] stringArray) {
        if (this.currentName == null) {
            this.errorMsg(0);
            return;
        }
        this.model.addRows(stringArray);
    }

    void deleteSelected() {
        if (this.currentName == null) {
            this.errorMsg(0);
            return;
        }
        if (this.table.getSelectedRow() == -1) {
            this.errorMsg(1);
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        this.model.deleteRows(nArray);
    }

    String[][] getSelectedRows() {
        if (this.currentName == null) {
            this.errorMsg(0);
            return new String[0][0];
        }
        if (this.table.getSelectedRow() == -1) {
            this.errorMsg(1);
            return new String[0][0];
        }
        int[] nArray = this.table.getSelectedRows();
        return this.model.getRows(nArray);
    }

    String[][] cutSelectedRows() {
        if (this.currentName == null) {
            this.errorMsg(0);
            return new String[0][0];
        }
        if (this.table.getSelectedRow() == -1) {
            this.errorMsg(1);
            return new String[0][0];
        }
        String[][] stringArray = this.getSelectedRows();
        this.deleteSelected();
        return stringArray;
    }

    class AttributeToolBar
    extends JToolBar
    implements ActionListener {
        protected HelpWindow helpWin = null;
        protected JButton newBtn;
        protected JButton deleteBtn;
        protected JButton cutBtn;
        protected JButton copyBtn;
        protected JButton pasteBtn;
        protected JToggleButton helpBtn;
        protected JToggleButton showBtn;

        public AttributeToolBar() {
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "ontology" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("New");
            this.newBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.cutBtn = new JButton(new ImageIcon(string2 + "cut.gif"));
            this.cutBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.cutBtn);
            this.cutBtn.setToolTipText("Cut");
            this.cutBtn.addActionListener(this);
            this.copyBtn = new JButton(new ImageIcon(string2 + "copy.gif"));
            this.copyBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.copyBtn);
            this.copyBtn.setToolTipText("Copy");
            this.copyBtn.addActionListener(this);
            this.pasteBtn = new JButton(new ImageIcon(string2 + "paste.gif"));
            this.pasteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.pasteBtn);
            this.pasteBtn.setToolTipText("Paste");
            this.pasteBtn.addActionListener(this);
            this.showBtn = new JToggleButton(new ImageIcon(string2 + "row1.gif"), false);
            this.showBtn.setMargin(new Insets(0, 0, 0, 0));
            this.showBtn.setSelectedIcon(new ImageIcon(string2 + "row2.gif"));
            this.add(this.showBtn);
            this.showBtn.setToolTipText("Toggle shown attributes");
            this.showBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
            this.addSeparator();
        }

        public void activate(boolean bl) {
            this.newBtn.setEnabled(bl);
            this.deleteBtn.setEnabled(bl);
            this.cutBtn.setEnabled(bl);
            this.pasteBtn.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                AttributeTablePanel.this.addNewRow();
            } else if (object == this.deleteBtn) {
                AttributeTablePanel.this.deleteSelected();
            } else if (object == this.showBtn) {
                AttributeTablePanel.this.updateDisplay(this.showBtn.isSelected());
            } else if (object == this.copyBtn) {
                AttributeTablePanel.this.clipboard = AttributeTablePanel.this.getSelectedRows();
            } else if (object == this.pasteBtn) {
                if (AttributeTablePanel.this.clipboard != null) {
                    AttributeTablePanel.this.model.addRows(AttributeTablePanel.this.clipboard);
                }
            } else if (object == this.cutBtn) {
                AttributeTablePanel.this.clipboard = AttributeTablePanel.this.cutSelectedRows();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this.helpBtn), point, "ontology", "Attribute Table");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    class NameCellRenderer
    extends DefaultTableCellRenderer {
        NameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (AttributeTablePanel.this.model.isCellEditable(n, n2)) {
                this.setForeground(Color.black);
            } else {
                this.setForeground(Color.green);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class TypeCellEditor
    extends DefaultCellEditor
    implements ActionListener,
    TypeSelector {
        protected JButton button = new JButton("");
        protected int row;
        protected int column;
        protected TypeDialog dialog;

        public TypeCellEditor(OntologyDb ontologyDb) {
            super(new JTextField());
            this.setClickCountToStart(2);
            this.dialog = new TypeDialog((Frame)SwingUtilities.getRoot(AttributeTablePanel.this.table), ontologyDb, 0);
            this.button.setBackground(Color.white);
            this.button.setHorizontalAlignment(2);
            this.button.setBorderPainted(false);
            this.button.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.button) {
                this.dialog.setLocationRelativeTo(this.button);
                this.fireEditingCanceled();
                this.dialog.display(this);
            }
        }

        public void typeSelected(String string) {
            AttributeTablePanel.this.model.setValueAt(string, this.row, this.column);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            this.button.setText(object.toString());
            return this.button;
        }
    }
}

