/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import zeus.concepts.OntologyDb;

public class TypesHandler
extends DefaultHandler {
    private List types = new Vector();
    private String name;
    private String type;
    private String value;
    private int unionTracker = 0;

    public void addRestrictions(OntologyDb ontologyDb) {
        List<String> list = Arrays.asList(ontologyDb.getAllRestrictionNames());
        Iterator iterator = this.types.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            String string = stringArray[0];
            if (list.contains(string)) continue;
            ontologyDb.addRestrictions(new String[][]{stringArray});
        }
    }

    private void addRestriction() {
        if (this.name == null || this.name.equals("") || this.type == null || this.type.equals("") || this.value == null || this.value.equals("")) {
            this.clear();
            return;
        }
        String[] stringArray = new String[]{this.name, this.type, this.value};
        this.types.add(stringArray);
        this.clear();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if (string4.equals("")) {
            string4 = string3;
        }
        if (string4.matches("(?i).*:union")) {
            ++this.unionTracker;
        } else if (string4.matches("(?i).*:simpleType")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equalsIgnoreCase("name")) continue;
                this.name = attributes.getValue(i);
                break;
            }
        } else if (this.name != null && !this.name.equals("")) {
            if (string4.matches("(?i).*:restriction")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equalsIgnoreCase("base")) continue;
                    this.parseType(attributes.getValue(i));
                    break;
                }
            } else if (this.type != null && !this.type.equals("")) {
                this.parseRestriction(string4, attributes);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2;
        if (string4.equals("")) {
            string4 = string3;
        }
        if (string4.matches("(?i).*:simpletype") && this.unionTracker == 0) {
            this.addRestriction();
        } else if (string4.matches("(?i).*:union")) {
            --this.unionTracker;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    private void parseRestriction(String string, Attributes attributes) {
        if (string.matches("(?i).*:minInclusive")) {
            this.joinRestriction(">= " + attributes.getValue("value"));
        } else if (string.matches("(?i).*:maxInclusive")) {
            this.joinRestriction("<= " + attributes.getValue("value"));
        } else if (string.matches("(?i).*:minExclusive")) {
            this.joinRestriction("> " + attributes.getValue("value"));
        } else if (string.matches("(?i).*:maxExclusive")) {
            this.joinRestriction("< " + attributes.getValue("value"));
        } else if (string.matches("(?i).*:enumeration")) {
            this.disjoinRestriction(attributes.getValue("value"));
        }
    }

    private void joinRestriction(String string) {
        if (this.unionTracker > 0) {
            this.disjoinRestriction(string);
        } else {
            this.conjoinRestriction(string);
        }
    }

    private void conjoinRestriction(String string) {
        this.value = this.value == null || this.value.equals("") ? string : this.value + " & " + string;
    }

    private void disjoinRestriction(String string) {
        this.value = this.value == null || this.value.equals("") ? string : this.value + " | " + string;
    }

    private void clear() {
        this.name = "";
        this.type = "";
        this.value = "";
    }

    private void parseType(String string) {
        if (string.matches(".*:.*")) {
            string = string.substring(string.indexOf(":") + 1);
        }
        this.type = string.toLowerCase().equals("string") ? "String" : (string.toLowerCase().equals("integer") ? "Integer" : (string.toLowerCase().equals("real") ? "Real" : (string.toLowerCase().equals("boolean") ? "Boolean" : (string.toLowerCase().equals("date") ? "Date" : (string.toLowerCase().equals("time") ? "Time" : (string.toLowerCase().equals("list") ? "List" : string))))));
    }
}

