/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import zeus.concepts.OntologyDb;
import zeus.ontology.TypeSelector;
import zeus.ontology.TypeTreeModel;
import zeus.util.SystemProps;

public class TypeDialog
extends JDialog
implements ActionListener {
    protected JTree tree;
    protected TypeTreeModel model;
    protected JButton okBtn;
    protected JButton cancelBtn;
    protected TypeSelector caller = null;

    public TypeDialog(Frame frame, OntologyDb ontologyDb, int n) {
        super(frame, "Select Type");
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setBackground(Color.lightGray);
        jPanel.setLayout(new BorderLayout());
        this.model = new TypeTreeModel(ontologyDb, n);
        this.tree = new JTree(this.model);
        this.tree.setEditable(false);
        this.tree.setRootVisible(false);
        String string = System.getProperty("file.separator");
        String string2 = SystemProps.getProperty("gif.dir") + "ontology" + string;
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(new ImageIcon(string2 + "cloud.gif"));
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(200, 150));
        jScrollPane.getViewport().add(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 10, 10));
        jPanel.add((Component)jPanel2, "South");
        this.okBtn = new JButton("OK");
        this.okBtn.addActionListener(this);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.addActionListener(this);
        jPanel2.add(this.okBtn);
        jPanel2.add(this.cancelBtn);
        this.setModal(true);
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okBtn) {
            this.setVisible(false);
            String string = this.getSelectedNodeName();
            if (!(string == null || string.equals("Basic Types") || string.equals("Restrictions") || string.equals("Facts"))) {
                this.caller.typeSelected(string);
            }
        } else if (actionEvent.getSource() == this.cancelBtn) {
            this.setVisible(false);
        }
    }

    public void display(TypeSelector typeSelector) {
        this.caller = typeSelector;
        this.model.refresh();
        this.pack();
        this.setVisible(true);
    }

    protected String getSelectedNodeName() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode == null) {
                return null;
            }
            return defaultMutableTreeNode.getUserObject().toString();
        }
        return null;
    }
}

