/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import zeus.util.XMLFormatter;

public class SchemaWriter {
    private HashMap namespaces = new HashMap();
    private String defaultNamespace;
    private boolean override;

    public SchemaWriter() {
        this.namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        this.setDefaultNamespace("xsd");
    }

    public void writeRestrictions(File file, List list) {
        String string = this.makeSchema(list);
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            ((Writer)fileWriter).close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public String makeSchema(List list) {
        String string = "<?xml version='1.0' encoding='ISO-8859-1'?>\n\n";
        string = string + "<xsd:schema ";
        string = string + this.getNamespaces();
        string = string + ">\n";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            string = string + this.translateType(stringArray[0], stringArray[1], stringArray[2]);
        }
        string = string + "</xsd:schema>\n";
        string = XMLFormatter.formatXML(string);
        return string;
    }

    private String translateType(String string, String string2, String string3) {
        String string4 = "";
        string4 = string4 + "<xsd:simpleType";
        if (string != null && !string.equals("")) {
            string4 = string4 + " name=\"" + string + "\" ";
        }
        string4 = string4 + ">\n";
        string4 = string4 + this.translateRestriction(string2, string3);
        string4 = string4 + "</xsd:simpleType>\n";
        return string4;
    }

    private String translateRestriction(String string, String string2) {
        String string3 = "";
        if (string2.matches("((.*[<>].*\\|.*)|(.*\\|.*[<>].*))")) {
            return this.union(string, string2);
        }
        string3 = string3 + "<xsd:restriction";
        if (string != null && this.getType(string) != null) {
            string3 = string3 + " base=\"" + this.getType(string) + "\" ";
        }
        string3 = string3 + ">\n";
        string3 = string3 + this.parseRestriction(string2);
        string3 = string3 + "</xsd:restriction>\n";
        return string3;
    }

    private String getType(String string) {
        if (this.override) {
            return this.defaultNamespace + ":" + string;
        }
        if (string.toLowerCase().equals("string")) {
            return "xsd:string";
        }
        if (string.toLowerCase().equals("integer")) {
            return "xsd:integer";
        }
        if (string.toLowerCase().equals("real")) {
            return "xsd:real";
        }
        if (string.toLowerCase().equals("boolean")) {
            return "xsd:boolean";
        }
        if (string.toLowerCase().equals("date")) {
            return "xsd:date";
        }
        if (string.toLowerCase().equals("time")) {
            return "xsd:time";
        }
        return this.defaultNamespace + ":" + string.toLowerCase();
    }

    private String parseRestriction(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        if ((string = string.trim()).matches(".*\\|.*")) {
            String string2 = this.parseRestriction(this.getLHS(string, "|"));
            String string3 = this.parseRestriction(this.getRHS(string, "|"));
            return string2 + string3;
        }
        if (string.matches(".*&.*")) {
            String string4 = this.parseRestriction(this.getLHS(string, "&"));
            String string5 = this.parseRestriction(this.getRHS(string, "&"));
            return string4 + string5;
        }
        if (string.matches(".*>=.*")) {
            return "<xsd:minInclusive value=\"" + this.getRHS(string, ">=") + "\" />\n";
        }
        if (string.matches(".*<=.*")) {
            return "<xsd:maxInclusive value=\"" + this.getRHS(string, "<=") + "\" />\n";
        }
        if (string.matches(".*>.*")) {
            return "<xsd:minExclusive value=\"" + this.getRHS(string, ">") + "\" />\n";
        }
        if (string.matches(".*<.*")) {
            return "<xsd:maxExclusive value=\"" + this.getRHS(string, "<") + "\" />\n";
        }
        if (string.matches(".*=.*")) {
            return "<xsd:enumeration value=\"" + this.getRHS(string, "=") + "\" />\n";
        }
        if (string.matches("..*")) {
            return "<xsd:enumeration value=\"" + string + "\" />\n";
        }
        return "";
    }

    private String getLHS(String string, String string2) {
        return string.substring(0, string.indexOf(string2)).trim();
    }

    private String getRHS(String string, String string2) {
        return string.substring(string.indexOf(string2) + string2.length()).trim();
    }

    private String union(String string, String string2) {
        if (!string2.matches("((.*[<>].*\\|.*)|(.*\\|.*[<>].*))")) {
            return this.parseRestriction(string2);
        }
        String string3 = "";
        string3 = string3 + "<xsd:union>\n";
        string3 = string3 + this.translateType(null, string, this.getLHS(string2, "|"));
        string3 = string3 + this.translateType(null, string, this.getRHS(string2, "|"));
        string3 = string3 + "</xsd:union>\n";
        return string3;
    }

    private String getNamespaces() {
        String string = "";
        Iterator iterator = this.namespaces.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string = string + "xmlns:" + string2 + "=\"" + this.namespaces.get(string2) + "\"\n";
        }
        return string.trim();
    }

    public void setDefaultNamespace(String string) {
        if (this.namespaces.keySet().contains(string)) {
            this.defaultNamespace = string;
        }
    }

    public void addNamespace(String string, String string2) {
        if (string != null && string2 != null && !string.equals("xsd")) {
            this.namespaces.put(string, string2);
        }
    }

    public void enableOverrideNamespaces() {
        this.override = true;
    }

    public void disableOverrideNamespaces() {
        this.override = false;
    }
}

