/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import zeus.concepts.OntologyDb;
import zeus.generator.GeneratorModel;
import zeus.ontology.database.DatabasePane;
import zeus.ontology.facts.FactTreePane;
import zeus.ontology.restrictions.RestrictionTableUI;
import zeus.util.Assert;
import zeus.util.GenSym;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class OntologyEditor {
    static final String[] MESSAGE = new String[]{"Save current ontology?", "Ontology save needed", "File already exists.\nOverwrite saved file?", "Save ontology as", "Error", "Warning", "About ZEUS Ontology Editor", "About", "Using ontology: ", "No ontology loaded", "Clear current ontology?"};
    static final String ONTOLOGY_FILE_EXT = "*.*";
    static final String FILE = "File";
    static final String NEW = "New";
    static final String LOAD = "Load...";
    static final String SAVE = "Save...";
    static final String SAVE_AS = "Save as...";
    static final String SAVE_AS_XML = "Save as DAML...";
    static final String EXIT = "Exit";
    static final String ABOUT = "About";
    static final String ABOUT_ZEUS = "About ZEUS...";
    public static final String ONTOLOGY_EDITOR = "Ontology Editor";
    protected JFrame frame = null;
    protected JInternalFrame iframe = null;
    protected JTabbedPane tabbedPane;
    protected JLabel infoLabel = null;
    protected Component root = null;
    protected boolean AS_XML = false;
    protected OntologyDb ontologyDb = null;
    protected GeneratorModel genmodel = null;
    protected JMenuItem miNew;
    protected JMenuItem miOpen;
    protected JMenuItem miSave;
    protected JMenuItem miSaveAs;
    protected JMenuItem miSaveAsXML;
    protected JMenuItem miExit;
    protected JMenuItem miAbout;
    private static int NUMBER_DISPLAYED = 0;

    protected void initMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(FILE);
        this.miNew = new JMenuItem(NEW);
        this.miOpen = new JMenuItem(LOAD);
        this.miSave = new JMenuItem(SAVE);
        this.miSaveAs = new JMenuItem(SAVE_AS);
        this.miSaveAsXML = new JMenuItem(SAVE_AS_XML);
        this.miExit = new JMenuItem(EXIT);
        jMenu.add(this.miNew);
        jMenu.add(this.miOpen);
        jMenu.add(this.miSave);
        jMenu.add(this.miSaveAs);
        jMenu.add(this.miSaveAsXML);
        jMenu.addSeparator();
        jMenu.add(this.miExit);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(ABOUT);
        this.miAbout = new JMenuItem(ABOUT_ZEUS);
        jMenu2.add(this.miAbout);
        if (this.frame != null) {
            this.frame.setJMenuBar(jMenuBar);
        } else if (this.iframe != null) {
            this.iframe.setJMenuBar(jMenuBar);
        }
    }

    public OntologyEditor(OntologyDb ontologyDb, Component component, GeneratorModel generatorModel, JLabel jLabel) {
        this.ontologyDb = ontologyDb;
        this.genmodel = generatorModel;
        this.infoLabel = jLabel;
        this.root = component;
        this.setTitle("");
    }

    public OntologyEditor(OntologyDb ontologyDb, boolean bl) {
        this.ontologyDb = ontologyDb;
        if (bl) {
            this.createFrame();
        }
    }

    JTabbedPane getTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        FactTreePane factTreePane = new FactTreePane(this, this.ontologyDb);
        jTabbedPane.addTab("Known Facts", null, factTreePane, "Shows the hierarchy of known facts");
        RestrictionTableUI restrictionTableUI = new RestrictionTableUI(this.ontologyDb);
        jTabbedPane.addTab("Restriction Definitions", null, restrictionTableUI, "Shows a table containing known restrictions");
        DatabasePane databasePane = new DatabasePane(this.ontologyDb, this.genmodel);
        jTabbedPane.addTab("Database Import", null, databasePane, "Allows facts to be imported from relational database schemas");
        jTabbedPane.setSelectedIndex(0);
        jTabbedPane.setTabPlacement(3);
        return jTabbedPane;
    }

    ImageIcon getIcon() {
        String string = System.getProperty("file.separator");
        String string2 = SystemProps.getProperty("gif.dir") + "ontology" + string;
        ImageIcon imageIcon = new ImageIcon(string2 + "cloudicon.gif");
        return imageIcon;
    }

    void registerListeners() {
        SymAction symAction = new SymAction();
        this.miNew.addActionListener(symAction);
        this.miOpen.addActionListener(symAction);
        this.miSave.addActionListener(symAction);
        this.miSaveAs.addActionListener(symAction);
        this.miSaveAsXML.addActionListener(symAction);
        this.miExit.addActionListener(symAction);
        this.miAbout.addActionListener(symAction);
    }

    public JInternalFrame createInternalFrame() {
        this.iframe = new JInternalFrame("Ontology Database", true, true, true, true);
        this.iframe.setTitle("Ontology Database:" + ++NUMBER_DISPLAYED);
        this.iframe.setFrameIcon(this.getIcon());
        this.iframe.getContentPane().setBackground(Color.gray);
        this.iframe.getContentPane().setLayout(new BorderLayout());
        this.iframe.getContentPane().add((Component)this.getTabbedPane(), "Center");
        this.iframe.setBackground(Color.lightGray);
        this.iframe.pack();
        return this.iframe;
    }

    public JFrame createFrame() {
        this.frame = new JFrame();
        this.frame.setIconImage(this.getIcon().getImage());
        this.frame.getContentPane().setBackground(Color.gray);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.getTabbedPane(), "Center");
        this.initMenus();
        this.frame.addWindowListener(new SymWindow());
        this.registerListeners();
        this.frame.setDefaultCloseOperation(0);
        this.frame.setBackground(Color.lightGray);
        this.frame.setSize(540, 540);
        String string = this.ontologyDb.getFilename();
        if (string == null) {
            string = "";
        }
        this.setTitle(string);
        this.frame.pack();
        this.frame.setVisible(true);
        return this.frame;
    }

    protected void setTitle(String string) {
        if (this.frame != null) {
            if (string.equals("")) {
                this.frame.setTitle(ONTOLOGY_EDITOR);
            } else {
                this.frame.setTitle("Ontology Editor: " + string);
            }
        } else if (this.iframe != null) {
            if (string.equals("")) {
                this.iframe.setTitle(ONTOLOGY_EDITOR);
            } else {
                this.iframe.setTitle("Ontology Editor: " + string);
            }
        }
        if (this.infoLabel != null) {
            if (string.equals("")) {
                this.infoLabel.setText(MESSAGE[9]);
            } else {
                this.infoLabel.setText(MESSAGE[8] + " " + Misc.relativePath(string));
            }
        }
    }

    protected Component getRoot() {
        return this.frame != null ? this.frame : this.root;
    }

    public void showFrame() {
        if (this.frame == null) {
            this.createFrame();
        } else {
            this.frame.setVisible(true);
        }
    }

    public boolean Close() {
        if (this.ontologyDb.isSaveNeeded()) {
            int n = JOptionPane.showConfirmDialog(this.getRoot(), MESSAGE[0], MESSAGE[1], 1);
            if (n == 0 && !this.Save()) {
                return false;
            }
            if (n == 2) {
                return false;
            }
        }
        return this.closeFile();
    }

    public void Open() {
        File file = this.getFile(0);
        if (file != null && this.Close()) {
            this.openFile(file);
        }
    }

    public boolean Save() {
        if (this.ontologyDb.getFilename() == null) {
            return this.SaveAs();
        }
        return this.saveFile(new File(this.ontologyDb.getFilename()));
    }

    boolean SaveAs() {
        File file = this.getFile(1);
        if (file != null) {
            int n;
            File file2 = null;
            String string = this.ontologyDb.getFilename();
            if (string != null) {
                file2 = new File(string);
            }
            if (file.exists() && file2 != null && !file.equals(file2) && (n = JOptionPane.showConfirmDialog(this.getRoot(), MESSAGE[2], MESSAGE[3], 0)) == 1) {
                return false;
            }
            return this.saveFile(file);
        }
        if (this.AS_XML) {
            this.AS_XML = false;
        }
        return false;
    }

    boolean SaveAsXML() {
        this.AS_XML = true;
        return this.SaveAs();
    }

    void Exit() {
        if (this.root == null && this.ontologyDb.isSaveNeeded()) {
            int n = JOptionPane.showConfirmDialog(this.getRoot(), MESSAGE[0], MESSAGE[1], 1);
            if (n == 0 && !this.Save()) {
                return;
            }
            if (n == 2) {
                return;
            }
        }
        if (this.root != null) {
            this.frame.setVisible(false);
        } else if (this.frame != null) {
            this.frame.dispose();
        } else if (this.iframe != null) {
            this.frame.dispose();
        }
    }

    void About() {
        JOptionPane.showMessageDialog(this.getRoot(), MESSAGE[6], MESSAGE[7], 1);
    }

    boolean saveFile(File file) {
        Assert.notNull(file);
        Frame frame = (Frame)SwingUtilities.getRoot(this.getRoot());
        Cursor cursor = frame.getCursor();
        frame.setCursor(new Cursor(3));
        int n = this.AS_XML ? this.ontologyDb.saveDAML(file) : this.ontologyDb.saveFile(file);
        frame.setCursor(cursor);
        if ((n & 2) != 0) {
            JOptionPane.showMessageDialog(this.getRoot(), this.ontologyDb.getError(), MESSAGE[4], 0);
            return false;
        }
        if ((n & 1) != 0) {
            JOptionPane.showMessageDialog(this.getRoot(), this.ontologyDb.getWarning(), MESSAGE[5], 2);
        }
        if (!this.AS_XML) {
            this.setTitle(file.getName());
        } else {
            this.AS_XML = false;
        }
        return true;
    }

    boolean openFile(File file) {
        Assert.notNull(file);
        Frame frame = (Frame)SwingUtilities.getRoot(this.getRoot());
        Cursor cursor = frame.getCursor();
        frame.setCursor(new Cursor(3));
        int n = this.ontologyDb.openFile(file);
        frame.setCursor(cursor);
        if ((n & 2) != 0) {
            JOptionPane.showMessageDialog(this.getRoot(), this.ontologyDb.getError(), MESSAGE[4], 0);
            this.closeFile();
            return false;
        }
        if ((n & 1) != 0) {
            JOptionPane.showMessageDialog(this.getRoot(), this.ontologyDb.getWarning(), MESSAGE[5], 2);
        }
        this.setTitle(file.getName());
        return true;
    }

    public boolean closeFile() {
        this.ontologyDb.clear();
        this.setTitle("");
        return true;
    }

    protected File getFile(int n) {
        FileDialog fileDialog = new FileDialog((Frame)SwingUtilities.getRoot(this.getRoot()), "Select File", n);
        File file = null;
        String string = this.ontologyDb.getFilename();
        if (string != null) {
            file = new File(string);
        }
        if (file != null) {
            fileDialog.setFile(file.getName());
            fileDialog.setDirectory(file.getParent());
        } else {
            fileDialog.setFile(ONTOLOGY_FILE_EXT);
        }
        fileDialog.pack();
        fileDialog.setVisible(true);
        return fileDialog.getFile() == null ? null : new File(fileDialog.getDirectory(), fileDialog.getFile());
    }

    protected static void version() {
        System.err.println("OntologyEditor version: " + SystemProps.getProperty("version.id"));
    }

    protected static void usage() {
        System.err.println("Usage: java OntologyEditor [-f <file>] [-h] [-v]");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-f") && ++i < stringArray.length) {
                string = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-h")) {
                OntologyEditor.usage();
                continue;
            }
            if (stringArray[i].equals("-v")) {
                OntologyEditor.version();
                continue;
            }
            OntologyEditor.usage();
        }
        OntologyEditor ontologyEditor = new OntologyEditor(new OntologyDb(new GenSym("name")), true);
        if (string != null) {
            String string2 = System.getProperty("user.dir") + System.getProperty("file.separator");
            ontologyEditor.openFile(new File(string2 + string));
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == OntologyEditor.this.miNew) {
                OntologyEditor.this.Close();
            } else if (object == OntologyEditor.this.miOpen) {
                OntologyEditor.this.Open();
            } else if (object == OntologyEditor.this.miSave) {
                OntologyEditor.this.Save();
            } else if (object == OntologyEditor.this.miSaveAs) {
                OntologyEditor.this.SaveAs();
            } else if (object == OntologyEditor.this.miSaveAsXML) {
                OntologyEditor.this.SaveAsXML();
            } else if (object == OntologyEditor.this.miExit) {
                OntologyEditor.this.Exit();
            } else if (object == OntologyEditor.this.miAbout) {
                OntologyEditor.this.About();
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            OntologyEditor.this.Exit();
        }
    }
}

