/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology;

import com.hp.hpl.jena.daml.DAMLClass;
import com.hp.hpl.jena.daml.DAMLCommon;
import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.daml.DAMLOntology;
import com.hp.hpl.jena.daml.DAMLProperty;
import com.hp.hpl.jena.daml.common.DAMLModelImpl;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import zeus.concepts.FactDescription;
import zeus.ontology.SchemaWriter;
import zeus.util.TreeNode;

public class DAMLWriter {
    protected String namespace;
    protected List restrictions;
    protected List facts;

    public DAMLWriter(String string, Enumeration enumeration, Enumeration enumeration2) {
        this.namespace = string;
        this.restrictions = new Vector();
        while (enumeration.hasMoreElements()) {
            this.restrictions.add(enumeration.nextElement());
        }
        this.facts = new Vector();
        while (enumeration2.hasMoreElements()) {
            this.facts.add(enumeration2.nextElement());
        }
    }

    public int write(File file, String string) {
        try {
            Object object;
            DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
            DAMLOntology dAMLOntology = dAMLModelImpl.createDAMLOntology("");
            dAMLOntology.prop_comment().addValue(string);
            Object object2 = this.facts.iterator();
            while (object2.hasNext()) {
                object = (TreeNode)object2.next();
                this.translateNode((TreeNode)object, (DAMLModel)dAMLModelImpl, this.facts);
            }
            object2 = file.getAbsolutePath().replaceAll("\\.[^\\.]*$", "Types.xsd");
            object = new SchemaWriter();
            ((SchemaWriter)object).writeRestrictions(new File((String)object2), this.restrictions);
            if (this.restrictions.size() > 0) {
                dAMLOntology.prop_comment().addValue("Types: " + (String)object2);
            }
            FileWriter fileWriter = new FileWriter(file);
            dAMLModelImpl.write((Writer)fileWriter, "RDF/XML-ABBREV", this.namespace.replaceAll("#", ""));
            return 0;
        }
        catch (RDFException rDFException) {
            return 2;
        }
        catch (IOException iOException) {
            return 2;
        }
    }

    private DAMLClass translateNode(TreeNode treeNode, DAMLModel dAMLModel, List list) throws RDFException {
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        DAMLClass dAMLClass = dAMLModel.createDAMLClass(this.namespace + factDescription.getName());
        if (treeNode.getParent() != null) {
            String string = ((FactDescription)treeNode.getParent().getValue()).getName();
            Resource resource = null;
            resource = this.findResource(dAMLModel, this.namespace + string);
            if (resource == null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    TreeNode treeNode2 = (TreeNode)iterator.next();
                    FactDescription factDescription2 = (FactDescription)treeNode2.getValue();
                    if (!factDescription2.getName().equals(string)) continue;
                    resource = this.translateNode(treeNode2, dAMLModel, list);
                    break;
                }
                System.out.println("Parent fact \"" + string + "\" not found.");
            }
            dAMLClass.prop_subClassOf().add(resource);
        }
        this.addAttributes(treeNode, dAMLModel);
        return dAMLClass;
    }

    private void addAttributes(TreeNode treeNode, DAMLModel dAMLModel) {
        FactDescription factDescription = (FactDescription)treeNode.getValue();
        String[][] stringArray = factDescription.getAttributes();
        for (int i = 0; i < stringArray.length; ++i) {
            Resource resource;
            String string = stringArray[i][0];
            String string2 = stringArray[i][1];
            String string3 = stringArray[i][2];
            String string4 = stringArray[i][3];
            DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty(factDescription.getName() + "." + string);
            Resource resource2 = this.findResource(dAMLModel, factDescription.getName());
            if (resource2 != null) {
                dAMLProperty.prop_domain().add(resource2);
            }
            if ((resource = this.lookupRange(dAMLModel, string2)) != null) {
                dAMLProperty.prop_range().add(resource);
            }
            if (string3 != null && string3.length() > 0) {
                this.addRestriction(dAMLProperty, string3);
            } else {
                this.addRestriction(dAMLProperty, "");
            }
            if (string4 == null || string4.length() <= 0) continue;
            this.addDefault(dAMLProperty, string4);
        }
    }

    private Resource findResource(DAMLModel dAMLModel, String string) {
        DAMLClass dAMLClass;
        Iterator iterator = dAMLModel.listDAMLClasses();
        while (iterator.hasNext()) {
            dAMLClass = (DAMLClass)iterator.next();
            if (dAMLClass.getURI() == null || !dAMLClass.getURI().matches("(" + string + "|.*#" + string + ")")) continue;
            return dAMLClass;
        }
        iterator = dAMLModel.listDAMLProperties();
        while (iterator.hasNext()) {
            dAMLClass = (DAMLProperty)iterator.next();
            if (dAMLClass.getURI() == null || !dAMLClass.getURI().matches("(" + string + "|.*#" + string + ")")) continue;
            return dAMLClass;
        }
        return null;
    }

    private Resource lookupRange(DAMLModel dAMLModel, String string) {
        String string2 = "http://www.w3.org/2000/10/XMLSchema#";
        String string3 = "http://www.daml.org/2001/03/daml+oil#";
        String string4 = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
        String string5 = "http://www.w3.org/2000/01/rdf-schema#";
        String string6 = "";
        if (this.namespace.lastIndexOf(".") > this.namespace.lastIndexOf("/")) {
            string6 = this.namespace.substring(0, this.namespace.lastIndexOf(".")) + "Types.xsd#";
        }
        if (this.isRestriction(dAMLModel, string)) {
            return dAMLModel.createDAMLDatatype(string6 + string);
        }
        if (this.findResource(dAMLModel, string) != null) {
            return this.findResource(dAMLModel, string);
        }
        if (string.equals("String")) {
            return dAMLModel.createDAMLDatatype(string2 + "string");
        }
        if (string.equals("Integer")) {
            return dAMLModel.createDAMLDatatype(string2 + "integer");
        }
        if (string.equals("Real")) {
            return dAMLModel.createDAMLDatatype(string2 + "real");
        }
        if (string.equals("Boolean")) {
            return dAMLModel.createDAMLDatatype(string2 + "boolean");
        }
        if (string.equals("Date")) {
            return dAMLModel.createDAMLDatatype(string2 + "date");
        }
        if (string.equals("Time")) {
            return dAMLModel.createDAMLDatatype(string2 + "time");
        }
        if (string.equals("List")) {
            return dAMLModel.createDAMLDatatype(string3 + "list");
        }
        if (string.equals("JavaObject")) {
            return dAMLModel.createDAMLDatatype(string3 + "Thing");
        }
        return dAMLModel.createDAMLDatatype(this.namespace + string);
    }

    private void addRestriction(DAMLProperty dAMLProperty, String string) {
        String string2 = dAMLProperty.getURI() + ".type";
        DAMLCommon dAMLCommon = dAMLProperty.prop_range().getDAMLValue();
        String string3 = dAMLCommon.getLocalName();
        dAMLProperty.prop_range().remove(dAMLCommon);
        String[] stringArray = new String[]{string2, string3, string};
        this.restrictions.add(stringArray);
        dAMLProperty.prop_range().add(this.lookupRange(dAMLProperty.getDAMLModel(), string2));
    }

    private void addDefault(DAMLProperty dAMLProperty, String string) {
        dAMLProperty.prop_comment().addValue("Default: \"" + string + "\"");
    }

    private boolean isRestriction(DAMLModel dAMLModel, String string) {
        Iterator iterator = this.restrictions.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            if (!stringArray[0].matches("(" + string + "|.*#" + string + ")")) continue;
            return true;
        }
        return false;
    }
}

