/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import zeus.gui.help.HelpWindow;

public class HtmlPanel
extends JPanel
implements HyperlinkListener {
    protected JEditorPane html;
    protected URL currentDoc;
    protected HelpWindow parent;

    public HtmlPanel(HelpWindow helpWindow) {
        this.parent = helpWindow;
        this.setLayout(new BorderLayout());
        this.html = new JEditorPane();
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(360, 180));
        jScrollPane.setMinimumSize(new Dimension(360, 180));
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.add(this.html);
        jViewport.setBackingStoreEnabled(true);
        this.add((Component)jScrollPane, "Center");
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = hyperlinkEvent.getURL();
            this.parent.addToHistory(uRL.toString());
            this.linkActivated(hyperlinkEvent.getURL());
        }
    }

    public void setPage(String string) {
        try {
            this.linkActivated(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Malformed URL: " + malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException);
        }
    }

    protected void linkActivated(URL uRL) {
        this.currentDoc = uRL;
        Cursor cursor = this.html.getCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        this.html.setCursor(cursor2);
        SwingUtilities.invokeLater(new PageLoader(uRL, cursor));
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL uRL, Cursor cursor) {
            this.url = uRL;
            this.cursor = cursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.url == null) {
                HtmlPanel.this.html.setCursor(this.cursor);
                Container container = HtmlPanel.this.html.getParent();
                container.repaint();
            } else {
                Document document = HtmlPanel.this.html.getDocument();
                try {
                    HtmlPanel.this.html.setPage(this.url);
                }
                catch (IOException iOException) {
                    HtmlPanel.this.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

