/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui.graph;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import zeus.gui.graph.SelectPanel;

public class MovePanel
extends SelectPanel {
    protected Cursor lastCursor;

    public MovePanel() {
    }

    public MovePanel(Dimension dimension) {
        super(dimension);
    }

    public MovePanel(int n, int n2) {
        super(n, n2);
    }

    public void anchor(Point point) {
        super.anchor(point);
        if (this.regionSelected && this.region.contains(this.anchor.x, this.anchor.y)) {
            JFrame jFrame = (JFrame)SwingUtilities.getRoot(this);
            this.lastCursor = jFrame.getCursor();
            jFrame.setCursor(new Cursor(13));
        }
    }

    public void stretch(Point point) {
        super.stretch(point);
        Graphics graphics = this.getGraphics();
        if (graphics != null && this.regionSelected) {
            graphics.setXORMode(this.getBackground());
            this.drawRegion(graphics);
            this.region.translate(this.stretched.x - this.last.x, this.stretched.y - this.last.y);
            this.drawRegion(graphics);
        }
    }

    public void end(Point point) {
        boolean bl = this.regionSelected;
        super.end(point);
        Graphics graphics = this.getGraphics();
        if (graphics != null && bl) {
            graphics.setXORMode(this.getBackground());
            this.drawRegion(graphics);
            this.region.translate(this.stretched.x - this.last.x, this.stretched.y - this.last.y);
            this.moveItems();
            this.drawRegion(graphics);
            JFrame jFrame = (JFrame)SwingUtilities.getRoot(this);
            jFrame.setCursor(this.lastCursor);
        }
    }

    protected void moveItems() {
        for (int i = 0; i < this.items.size(); ++i) {
            Component component = (Component)this.items.elementAt(i);
            Point point = component.getLocation();
            component.setLocation(point.x + this.end.x - this.anchor.x, point.y + this.end.y - this.anchor.y);
        }
    }
}

