/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui.graph;

import java.util.Vector;
import zeus.util.Assert;

public class GraphNode {
    public static final int PARENT = 0;
    public static final int CHILD = 1;
    protected Vector children = new Vector();
    protected Vector parents = new Vector();
    protected Vector siblings = new Vector();
    protected int nodeType = 0;
    protected Object user_object;

    public GraphNode(Object object) {
        this.user_object = object;
    }

    public void setUserObject(Object object) {
        this.user_object = object;
    }

    public Object getUserObject() {
        return this.user_object;
    }

    public void setNodeType(int n) {
        Assert.notFalse(n == 0 || n == 1);
        this.nodeType = n;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void initialize() {
        this.children.removeAllElements();
        this.parents.removeAllElements();
        this.siblings.removeAllElements();
        this.nodeType = 0;
    }

    protected boolean addItem(GraphNode graphNode, Vector vector) {
        if (vector.contains(graphNode)) {
            return false;
        }
        vector.addElement(graphNode);
        return true;
    }

    public void addSibling(GraphNode graphNode) {
        this.addItem(graphNode, this.siblings);
    }

    public void addChild(GraphNode graphNode) {
        this.addItem(graphNode, this.children);
    }

    public void addParent(GraphNode graphNode) {
        if (this.addItem(graphNode, this.parents)) {
            this.nodeType = 1;
        }
    }

    public boolean hasSibling(GraphNode graphNode) {
        return this.siblings.contains(graphNode);
    }

    public boolean hasChild(GraphNode graphNode) {
        return this.children.contains(graphNode);
    }

    public boolean hasParent(GraphNode graphNode) {
        return this.parents.contains(graphNode);
    }

    public void removeSibling(GraphNode graphNode) {
        this.siblings.removeElement(graphNode);
    }

    public void removeChild(GraphNode graphNode) {
        this.children.removeElement(graphNode);
    }

    public void removeParent(GraphNode graphNode) {
        this.parents.removeElement(graphNode);
        if (this.parents.isEmpty()) {
            this.nodeType = 0;
        }
    }

    public GraphNode[] getChildren() {
        GraphNode[] graphNodeArray = new GraphNode[this.children.size()];
        for (int i = 0; i < this.children.size(); ++i) {
            graphNodeArray[i] = (GraphNode)this.children.elementAt(i);
        }
        return graphNodeArray;
    }

    public GraphNode[] getSiblings() {
        GraphNode[] graphNodeArray = new GraphNode[this.siblings.size()];
        for (int i = 0; i < this.siblings.size(); ++i) {
            graphNodeArray[i] = (GraphNode)this.siblings.elementAt(i);
        }
        return graphNodeArray;
    }

    public GraphNode[] getParents() {
        GraphNode[] graphNodeArray = new GraphNode[this.parents.size()];
        for (int i = 0; i < this.parents.size(); ++i) {
            graphNodeArray[i] = (GraphNode)this.parents.elementAt(i);
        }
        return graphNodeArray;
    }
}

