/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.EventListenerList;
import zeus.gui.graph.DefaultGraphNodeRenderer;
import zeus.gui.graph.Graph;
import zeus.gui.graph.GraphIconEvent;
import zeus.gui.graph.GraphIconListener;
import zeus.gui.graph.GraphNode;
import zeus.gui.graph.GraphNodeRenderer;

public class GraphIcon
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected static final int LOCATION_CHANGED = 0;
    protected static final int DOUBLE_CLICK_ACTION = 1;
    protected static final int LEFT_MOUSE_ACTION = 2;
    protected static final int RIGHT_MOUSE_PRESSED = 3;
    protected static final int RIGHT_MOUSE_DRAGGED = 4;
    protected static final int RIGHT_MOUSE_RELEASED = 5;
    protected static final int MIDDLE_MOUSE_ACTION = 6;
    protected static final int thickness = 3;
    protected Point anchor;
    protected Point graphPoint;
    protected Graph graph;
    protected Rectangle rect = null;
    protected Cursor lastCursor;
    protected Component rendererComp;
    protected GraphNode node;
    protected EventListenerList iconListeners = new EventListenerList();
    protected boolean dragging = false;
    protected boolean isSelected = false;
    protected boolean isSelectable = true;
    protected boolean isMoveable = true;
    static /* synthetic */ Class class$zeus$gui$graph$GraphIconListener;

    public GraphIcon(GraphNode graphNode, Graph graph, boolean bl, boolean bl2) {
        this(graphNode, graph);
        this.isSelectable = bl;
        this.isMoveable = bl2;
    }

    public GraphIcon(GraphNode graphNode, Graph graph) {
        this.node = graphNode;
        this.graph = graph;
        this.setBackground(Color.lightGray);
        this.setLayout(new GridBagLayout());
        this.reset();
        this.anchor = this.getLocation();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void reset() {
        this.removeAll();
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GraphNodeRenderer graphNodeRenderer = this.graph.getNodeRenderer();
        if (graphNodeRenderer == null) {
            graphNodeRenderer = new DefaultGraphNodeRenderer();
        }
        this.rendererComp = graphNodeRenderer.getNodeRendererComponent(this.graph, this.node);
        this.rendererComp.addMouseListener(this);
        this.rendererComp.addMouseMotionListener(this);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.rendererComp, gridBagConstraints);
        this.add(this.rendererComp);
        this.setBorder(new BevelBorder(0));
        this.isSelected = false;
    }

    public void addNotify() {
        super.addNotify();
        this.setSize(this.getPreferredSize());
        this.doLayout();
    }

    public void setGraphNode(GraphNode graphNode) {
        this.node = graphNode;
        this.reset();
        this.setSize(this.getPreferredSize());
        this.doLayout();
    }

    public GraphNode getGraphNode() {
        return this.node;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setMoveable(boolean bl) {
        this.isMoveable = bl;
    }

    public void setSelectable(boolean bl) {
        this.isSelectable = bl;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean bl) {
        if (this.isSelectable) {
            this.isSelected = bl;
            if (bl) {
                this.setBorder(new BevelBorder(1));
            } else {
                this.setBorder(new BevelBorder(0));
            }
        }
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        if (this.isMoveable) {
            this.fireAction(0);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.graphPoint = mouseEvent.getPoint();
        if (mouseEvent.getClickCount() == 2) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.fireAction(1);
            }
        } else if (mouseEvent.getClickCount() == 1) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.fireAction(2);
            } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.fireAction(3);
            } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                this.fireAction(6);
            }
        }
        if (this.isMoveable) {
            this.dragging = false;
            this.anchor = mouseEvent.getPoint();
            this.rect = this.getBounds();
            Graphics graphics = this.graph.getGraphics();
            if (graphics != null && this.rect != null) {
                graphics.setXORMode(this.graph.getBackground());
                graphics.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.graphPoint = mouseEvent.getPoint();
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.fireAction(5);
        } else {
            if (this.isMoveable) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = this.getLocation().x + n - this.anchor.x;
                int n4 = this.getLocation().y + n2 - this.anchor.y;
                n3 = n3 > 0 ? n3 : 0;
                n4 = n4 > 0 ? n4 : 0;
                Graphics graphics = this.graph.getGraphics();
                if (graphics != null && this.rect != null) {
                    graphics.setXORMode(this.graph.getBackground());
                    graphics.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
                }
                this.setLocation(n3, n4);
            }
            if (this.isSelectable && !this.dragging & SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.setSelected(!this.isSelected);
            } else if (this.isMoveable && this.dragging) {
                JFrame jFrame = (JFrame)SwingUtilities.getRoot(this);
                jFrame.setCursor(this.lastCursor);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.graphPoint = mouseEvent.getPoint();
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.fireAction(4);
        } else if (this.isMoveable) {
            if (!this.dragging) {
                JFrame jFrame = (JFrame)SwingUtilities.getRoot(this);
                this.lastCursor = jFrame.getCursor();
                jFrame.setCursor(new Cursor(13));
                this.dragging = true;
            } else {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                Graphics graphics = this.graph.getGraphics();
                if (graphics != null && this.rect != null) {
                    graphics.setXORMode(this.graph.getBackground());
                    graphics.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
                    this.rect.x = this.getLocation().x + n - this.anchor.x;
                    this.rect.y = this.getLocation().y + n2 - this.anchor.y;
                    graphics.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
                }
            }
        }
    }

    public void addGraphIconListener(GraphIconListener graphIconListener) {
        this.iconListeners.add(class$zeus$gui$graph$GraphIconListener == null ? (class$zeus$gui$graph$GraphIconListener = GraphIcon.class$("zeus.gui.graph.GraphIconListener")) : class$zeus$gui$graph$GraphIconListener, graphIconListener);
    }

    public void removeGraphIconListener(GraphIconListener graphIconListener) {
        this.iconListeners.remove(class$zeus$gui$graph$GraphIconListener == null ? (class$zeus$gui$graph$GraphIconListener = GraphIcon.class$("zeus.gui.graph.GraphIconListener")) : class$zeus$gui$graph$GraphIconListener, graphIconListener);
    }

    protected void fireAction(int n) {
        GraphIconEvent graphIconEvent = new GraphIconEvent(this);
        graphIconEvent.setPoint(this.graphPoint);
        Object[] objectArray = this.iconListeners.getListenerList();
        block9: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$zeus$gui$graph$GraphIconListener == null ? GraphIcon.class$("zeus.gui.graph.GraphIconListener") : class$zeus$gui$graph$GraphIconListener)) continue;
            GraphIconListener graphIconListener = (GraphIconListener)objectArray[i + 1];
            switch (n) {
                case 0: {
                    graphIconListener.locationChanged(graphIconEvent);
                    continue block9;
                }
                case 1: {
                    graphIconListener.performLeftMouseDClickAction(graphIconEvent);
                    continue block9;
                }
                case 2: {
                    graphIconListener.performLeftMouseAction(graphIconEvent);
                    continue block9;
                }
                case 3: {
                    graphIconEvent.setRightMousePressed();
                    graphIconListener.performRightMouseAction(graphIconEvent);
                    continue block9;
                }
                case 4: {
                    graphIconEvent.setRightMouseDragged();
                    graphIconListener.performRightMouseAction(graphIconEvent);
                    continue block9;
                }
                case 5: {
                    graphIconEvent.setRightMouseReleased();
                    graphIconListener.performRightMouseAction(graphIconEvent);
                    continue block9;
                }
                case 6: {
                    graphIconListener.performMiddleMouseAction(graphIconEvent);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

