/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui.fields;

import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WholeNumberField
extends JTextField
implements FocusListener,
DocumentListener {
    protected static char MINUS_CHAR = (char)45;
    protected EventListenerList changeListeners = new EventListenerList();
    protected long min;
    protected long max;
    protected boolean range_check = false;
    protected boolean range_checked = false;
    static char[] numberSet = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public WholeNumberField() {
    }

    public WholeNumberField(long l, long l2) {
        this();
        this.min = l;
        this.max = l2;
        this.range_check = true;
        this.addFocusListener(this);
    }

    public WholeNumberField(int n, int n2) {
        this();
        this.min = n;
        this.max = n2;
        this.range_check = true;
        this.addFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.range_check && !this.range_checked) {
            this.range_checked = true;
            try {
                long l = Long.valueOf(this.getText());
                if (l < this.min || l > this.max) {
                    this.errorMsg();
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.errorMsg();
                return;
            }
        }
    }

    public void setText(Integer n) {
        this.setText(n.toString());
    }

    public void setText(Long l) {
        this.setText(l.toString());
    }

    protected void errorMsg() {
        JOptionPane.showMessageDialog(this, "Illegal entry\nValue must be between " + this.min + " and " + this.max + " inclusive", "Error", 0);
    }

    public void setValue(int n) {
        this.setValue((long)n);
    }

    public void setValue(long l) {
        if (this.range_check && (l < this.min || l > this.max)) {
            this.errorMsg();
            return;
        }
        this.setText(Long.toString(l));
    }

    public Long getValue() {
        try {
            return new Long(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Long getValue(int n) {
        return this.getValue((long)n);
    }

    public Long getValue(long l) {
        Long l2 = this.getValue();
        if (l2 == null) {
            return new Long(l);
        }
        return l2;
    }

    protected Document createDefaultModel() {
        WholeNumberFieldDocument wholeNumberFieldDocument = new WholeNumberFieldDocument();
        wholeNumberFieldDocument.addDocumentListener(this);
        return wholeNumberFieldDocument;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.range_checked = false;
        this.fireChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.range_checked = false;
        this.fireChanged();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.range_checked = false;
        this.fireChanged();
    }

    static boolean member(char c, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = WholeNumberField.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = WholeNumberField.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? WholeNumberField.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class WholeNumberFieldDocument
    extends PlainDocument {
        WholeNumberFieldDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            string = string.trim();
            String string2 = this.getText(0, n) + string;
            char[] cArray = string2.toCharArray();
            if (cArray.length > 0 && cArray[0] != MINUS_CHAR && !WholeNumberField.member(cArray[0], numberSet)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            for (int i = 1; i < cArray.length; ++i) {
                if (WholeNumberField.member(cArray[i], numberSet)) continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

