/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListModel;

public class SingleSelectionDialog
extends JDialog
implements ActionListener {
    protected JButton cancelButton;
    protected String OK = "OK";
    protected String CANCEL = "Cancel";
    protected JList list;
    protected JButton okButton;
    protected Object selection = null;

    public SingleSelectionDialog(Frame frame, String string, Object[] objectArray) {
        this(frame, string);
        this.list.setListData(objectArray);
    }

    public SingleSelectionDialog(Frame frame, String string, Object[] objectArray, Object object) {
        this(frame, string);
        this.list.setListData(objectArray);
        this.list.setSelectedValue(object, true);
    }

    public SingleSelectionDialog(Frame frame, String string) {
        super(frame, string, true);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 10, 10));
        this.okButton = new JButton(this.OK);
        this.cancelButton = new JButton(this.CANCEL);
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel3 = new JPanel();
        JSeparator jSeparator = new JSeparator();
        jPanel3.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel3.add(jSeparator);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel3.add(jPanel2);
        this.list = new JList();
        this.list.setSelectionModel(new DefaultListSelectionModel());
        this.list.setSelectionMode(0);
        this.list.setPreferredSize(new Dimension(100, 100));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.list);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel4.add(jScrollPane);
        jPanel.add("South", jPanel3);
        jPanel.add("Center", jPanel4);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SingleSelectionDialog.this.setVisible(false);
            }
        });
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.selection = this.list.getSelectedValue();
            if (this.selection == null) {
                int n = JOptionPane.showConfirmDialog(this, "No value selected\nContinue?", "Warning", 0);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return;
                    }
                }
            }
            this.setVisible(false);
        } else if (object == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public Object getSelection() {
        this.selection = null;
        this.setVisible(true);
        return this.selection;
    }

    public void setListData(Object[] objectArray) {
        this.list.setListData(objectArray);
    }

    public void setSelection(Object object) {
        this.list.setSelectedValue(object, true);
    }

    public Object[] getListData() {
        ListModel listModel = this.list.getModel();
        Vector vector = new Vector();
        for (int i = 0; i < listModel.getSize(); ++i) {
            vector.addElement(listModel.getElementAt(i));
        }
        return vector.toArray();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Test");
        jFrame.setSize(200, 200);
        jFrame.show();
        Object[] objectArray = new String[]{"Dave", "John", "Henry", "Alice", "Albert"};
        SingleSelectionDialog singleSelectionDialog = new SingleSelectionDialog((Frame)jFrame, "Select Servers");
        singleSelectionDialog.setListData(objectArray);
        Object object = singleSelectionDialog.getSelection();
    }
}

