/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import zeus.gui.fields.WholeNumberField;
import zeus.util.Assert;

public class NumberDialog
extends JDialog
implements ActionListener {
    protected JLabel label;
    protected WholeNumberField textfield;
    protected JButton okButton;
    protected JButton cancelButton;
    protected String OK = "Ok";
    protected String CANCEL = "Cancel";
    protected Long answer = null;

    public NumberDialog(Frame frame, String string, String string2) {
        this(frame, string);
        this.setLabel(string2);
    }

    public NumberDialog(Frame frame, String string, String string2, int n, int n2, int n3) {
        this(frame, string, n, (long)n2);
        this.setLabel(string2);
        this.setValue(n3);
    }

    public NumberDialog(Frame frame, String string, String string2, int n) {
        this(frame, string);
        this.setLabel(string2);
        this.setValue(n);
    }

    public NumberDialog(Frame frame, String string, String string2, long l, long l2, long l3) {
        this(frame, string, l, l2);
        this.setLabel(string2);
        this.setValue(l3);
    }

    public NumberDialog(Frame frame, String string, String string2, long l) {
        this(frame, string);
        this.setLabel(string2);
        this.setValue(l);
    }

    public NumberDialog(Frame frame, String string) {
        this(frame, string, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public NumberDialog(Frame frame, String string, long l, long l2) {
        super(frame, string, true);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 10, 10));
        this.okButton = new JButton(this.OK);
        this.cancelButton = new JButton(this.CANCEL);
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        this.label = new JLabel("--Undefined--");
        this.textfield = new WholeNumberField(l, l2);
        this.textfield.setPreferredSize(new Dimension(100, 20));
        this.textfield.setMinimumSize(new Dimension(100, 20));
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.label, gridBagConstraints);
        jPanel2.add(this.label);
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.textfield, gridBagConstraints);
        jPanel2.add(this.textfield);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel2.add(jSeparator);
        this.getContentPane().add("Center", jPanel2);
        this.getContentPane().add("South", jPanel);
        this.textfield.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NumberDialog.this.setVisible(false);
            }
        });
        this.pack();
    }

    public Long getValue() {
        this.answer = null;
        this.setVisible(true);
        return this.answer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.textfield || object == this.okButton) {
            this.answer = this.textfield.getValue();
            if (this.answer == null) {
                int n = JOptionPane.showConfirmDialog(this, "Improperly specified integer value\nContinue?", "Warning", 0);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return;
                    }
                }
            }
            this.setVisible(false);
        } else if (object == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabel(String string) {
        Assert.notNull(string);
        this.label.setText(string);
    }

    public void setValue(int n) {
        this.textfield.setValue(n);
    }

    public void setValue(long l) {
        this.textfield.setValue(l);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Test");
        jFrame.setSize(200, 200);
        jFrame.show();
        NumberDialog numberDialog = new NumberDialog((Frame)jFrame, "Enter number");
        numberDialog.setValue(123);
        System.out.println(numberDialog.getValue());
        System.exit(0);
    }
}

