/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import zeus.gui.fields.NameField;

public class EditableMultipleSelectionDialog
extends JDialog
implements ActionListener {
    protected JButton cancelButton;
    protected JButton selectButton;
    protected JButton clearButton;
    protected JButton invertButton;
    protected String ENTER = "Enter new item:";
    protected String SELECT_ALL = "Select All";
    protected String CLEAR_ALL = "Clear All";
    protected String INVERT = "Invert Selection";
    protected String OK = "OK";
    protected String CANCEL = "Cancel";
    protected NameField textfield;
    protected JList list;
    protected JButton okButton;
    protected Object[] selection = null;

    public EditableMultipleSelectionDialog(Frame frame, String string, Object[] objectArray) {
        this(frame, string);
        this.list.setListData(objectArray);
    }

    public EditableMultipleSelectionDialog(Frame frame, String string, Object[] objectArray, Object[] objectArray2) {
        this(frame, string);
        this.list.setListData(objectArray);
        this.setSelection(objectArray2);
    }

    public EditableMultipleSelectionDialog(Frame frame, String string) {
        super(frame, string, true);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 10, 10));
        this.okButton = new JButton(this.OK);
        this.cancelButton = new JButton(this.CANCEL);
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel3 = new JPanel();
        JSeparator jSeparator = new JSeparator();
        jPanel3.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel3.add(jSeparator);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel3.add(jPanel2);
        this.list = new JList();
        this.list.setSelectionModel(new DefaultListSelectionModel());
        this.list.setSelectionMode(2);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.list);
        jScrollPane.setPreferredSize(new Dimension(150, 150));
        this.selectButton = new JButton(this.SELECT_ALL);
        this.clearButton = new JButton(this.CLEAR_ALL);
        this.invertButton = new JButton(this.INVERT);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(3, 1, 2, 2));
        jPanel4.add(this.selectButton);
        jPanel4.add(this.clearButton);
        jPanel4.add(this.invertButton);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel = new JLabel(this.ENTER);
        jLabel.setToolTipText("Enter new data into text field and press <return> to add to list");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel5.add(jLabel);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        this.textfield = new NameField(20);
        this.textfield.addActionListener(this);
        gridBagLayout.setConstraints(this.textfield, gridBagConstraints);
        jPanel5.add(this.textfield);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel6.add(jPanel5);
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel6.add(jScrollPane);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 40, 0, 10);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel6.add(jPanel4);
        jPanel.add("South", jPanel3);
        jPanel.add("Center", jPanel6);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.selectButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.invertButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EditableMultipleSelectionDialog.this.setVisible(false);
            }
        });
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = this.list.getModel().getSize();
        if (object == this.selectButton) {
            this.list.setSelectionInterval(0, n - 1);
        } else if (object == this.clearButton) {
            this.list.clearSelection();
        } else if (object == this.invertButton) {
            int[] nArray = this.list.getSelectedIndices();
            this.list.clearSelection();
            for (int i = 0; i < n; ++i) {
                boolean bl = false;
                for (int j = 0; !bl && j < nArray.length; ++j) {
                    bl = nArray[j] == i;
                }
                if (bl) continue;
                this.list.addSelectionInterval(i, i);
            }
        } else if (object == this.okButton) {
            if (!this.list.isSelectionEmpty()) {
                this.selection = this.list.getSelectedValues();
            }
            this.setVisible(false);
        } else if (object == this.cancelButton) {
            this.setVisible(false);
        } else if (object == this.textfield) {
            String string = this.textfield.getText();
            if (string == null) {
                return;
            }
            if ((string = string.trim()).equals("")) {
                return;
            }
            ListModel listModel = this.list.getModel();
            Vector vector = new Vector();
            for (int i = 0; i < listModel.getSize(); ++i) {
                vector.addElement(listModel.getElementAt(i));
            }
            if (!vector.contains(string)) {
                vector.addElement(string);
                this.list.setListData(vector);
            }
            this.textfield.setText("");
        }
    }

    public Object[] getPriorSelection() {
        return this.list.getSelectedValues();
    }

    public Object[] getSelection() {
        this.selection = null;
        this.setVisible(true);
        return this.selection;
    }

    public void setListData(Object[] objectArray) {
        this.list.setListData(objectArray);
    }

    public Object[] getListData() {
        ListModel listModel = this.list.getModel();
        Vector vector = new Vector();
        for (int i = 0; i < listModel.getSize(); ++i) {
            vector.addElement(listModel.getElementAt(i));
        }
        return vector.toArray();
    }

    public void setSelection(Object[] objectArray) {
        ListModel listModel = this.list.getModel();
        int n = listModel.getSize();
        this.list.clearSelection();
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                if (objectArray[i] != listModel.getElementAt(j)) continue;
                this.list.addSelectionInterval(j, j);
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Test");
        jFrame.setSize(200, 200);
        jFrame.show();
        Object[] objectArray = new String[]{"Dave", "John", "Henry", "Alice", "Albert"};
        EditableMultipleSelectionDialog editableMultipleSelectionDialog = new EditableMultipleSelectionDialog((Frame)jFrame, "Select Servers");
        editableMultipleSelectionDialog.setListData(objectArray);
        Object[] objectArray2 = editableMultipleSelectionDialog.getSelection();
        for (int i = 0; objectArray2 != null && i < objectArray2.length; ++i) {
            System.out.println(objectArray2[i]);
        }
        System.out.println("DONE...");
    }
}

