/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import zeus.util.HSet;

public class DoubleSelectionDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    protected JButton cancelButton;
    protected String OK = "OK";
    protected String CANCEL = "Cancel";
    protected JList lhsList;
    protected JList rhsList;
    protected DefaultListModel rhsListModel;
    protected DefaultListModel lhsListModel;
    protected JButton okButton;
    protected Hashtable input = new Hashtable();
    protected Object[] selection = null;

    public DoubleSelectionDialog(Frame frame, String string, String string2, String string3, Hashtable hashtable) {
        this(frame, string, string2, string3);
        this.setListData(this.input);
    }

    public DoubleSelectionDialog(Frame frame, String string, String string2, String string3, Hashtable hashtable, Object object, Object object2) {
        this(frame, string, string2, string3, hashtable);
        this.lhsList.setSelectedValue(object, true);
        this.rhsList.setSelectedValue(object2, true);
    }

    public DoubleSelectionDialog(Frame frame, String string, String string2, String string3) {
        super(frame, string, true);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 10, 10));
        this.okButton = new JButton(this.OK);
        this.cancelButton = new JButton(this.CANCEL);
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel3 = new JPanel();
        JSeparator jSeparator = new JSeparator();
        jPanel3.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel3.add(jSeparator);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel3.add(jPanel2);
        this.lhsListModel = new DefaultListModel();
        this.lhsList = new JList(this.lhsListModel);
        this.lhsList.setSelectionModel(new DefaultListSelectionModel());
        this.lhsList.setSelectionMode(0);
        this.lhsList.addListSelectionListener(this);
        this.lhsList.setPreferredSize(new Dimension(60, 100));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.lhsList);
        this.rhsListModel = new DefaultListModel();
        this.rhsList = new JList(this.rhsListModel);
        this.rhsList.setSelectionModel(new DefaultListSelectionModel());
        this.rhsList.setSelectionMode(0);
        this.rhsList.setPreferredSize(new Dimension(60, 100));
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().setView(this.rhsList);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel4.add(jScrollPane);
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        jPanel4.add(jScrollPane2);
        jPanel.add("South", jPanel3);
        jPanel.add("Center", jPanel4);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DoubleSelectionDialog.this.setVisible(false);
            }
        });
        this.pack();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        String string = (String)jList.getSelectedValue();
        if (string == null) {
            return;
        }
        if (jList == this.lhsList) {
            this.rhsList.clearSelection();
            HSet hSet = (HSet)this.input.get(string);
            Enumeration enumeration = hSet.elements();
            this.rhsListModel.removeAllElements();
            while (enumeration.hasMoreElements()) {
                this.rhsListModel.addElement(enumeration.nextElement());
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            int n;
            this.selection = new Object[2];
            this.selection[0] = this.lhsList.getSelectedValue();
            if (this.selection[0] == null) {
                n = JOptionPane.showConfirmDialog(this, "No value selected in left list\nContinue?", "Warning", 0);
                switch (n) {
                    case 0: {
                        this.selection = null;
                        this.setVisible(false);
                        return;
                    }
                    case 1: {
                        return;
                    }
                }
            }
            this.selection[1] = this.rhsList.getSelectedValue();
            if (this.selection[1] == null) {
                n = JOptionPane.showConfirmDialog(this, "No value selected in right list\nContinue?", "Warning", 0);
                switch (n) {
                    case 0: {
                        this.selection = null;
                        this.setVisible(false);
                        return;
                    }
                    case 1: {
                        return;
                    }
                }
            }
            this.setVisible(false);
        } else if (object == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public Object[] getSelection() {
        this.selection = null;
        this.setVisible(true);
        return this.selection;
    }

    public Object[] getPriorSelection() {
        Object[] objectArray = new Object[]{this.lhsList.getSelectedValue(), this.rhsList.getSelectedValue()};
        return objectArray;
    }

    public void setListData(Hashtable hashtable) {
        this.input.clear();
        this.lhsList.clearSelection();
        this.rhsList.clearSelection();
        this.lhsListModel.removeAllElements();
        this.rhsListModel.removeAllElements();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            this.lhsListModel.addElement(k);
            this.input.put(k, v);
        }
    }

    public Hashtable getListData() {
        return this.input;
    }

    public void setSelection(Object object, Object object2) {
        if (object != null) {
            this.lhsList.setSelectedValue(object, true);
        }
        if (object2 != null) {
            this.rhsList.setSelectedValue(object2, true);
        }
    }
}

