/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import zeus.concepts.Fact;
import zeus.generator.util.FactModifier;

public class ModifierDialog
extends JDialog
implements ActionListener,
ItemListener {
    protected static final String CANCEL = "Cancel";
    protected static final String OK = "Ok";
    protected static final String VARIABLE = "Is a variable";
    protected static final String NEGATIVE = "Not";
    protected static final String READONLY = "Strict Precondition (read only - not consumed)";
    protected static final String LOCAL = "Must be in local database";
    protected static final String REPLACED = "Is replaced after use";
    protected static final String SIDEEFFECT = "Is a side-effect only";
    protected JButton okButton;
    protected JButton cancelButton;
    protected JCheckBox isVariable = new JCheckBox("Is a variable", false);
    protected JCheckBox isNegative = new JCheckBox("Not", false);
    protected JCheckBox isReadOnly = new JCheckBox("Strict Precondition (read only - not consumed)", false);
    protected JCheckBox isLocal = new JCheckBox("Must be in local database", false);
    protected JCheckBox isReplaced = new JCheckBox("Is replaced after use", false);
    protected JCheckBox isSideEffect = new JCheckBox("Is a side-effect only", false);
    protected FactModifier caller = null;

    public ModifierDialog(Frame frame, String string) {
        super(frame, string, true);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 10, 10));
        this.okButton = new JButton(OK);
        this.cancelButton = new JButton(CANCEL);
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel3 = new JPanel();
        JSeparator jSeparator = new JSeparator();
        jPanel3.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel3.add(jSeparator);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(Color.lightGray);
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
        jPanel4.setBorder(compoundBorder);
        jPanel4.setLayout(new GridLayout(6, 1, 5, 5));
        jPanel4.add(this.isVariable);
        jPanel4.add(this.isNegative);
        jPanel4.add(this.isReadOnly);
        jPanel4.add(this.isLocal);
        jPanel4.add(this.isReplaced);
        jPanel4.add(this.isSideEffect);
        this.isVariable.setBackground(Color.lightGray);
        this.isNegative.setBackground(Color.lightGray);
        this.isReadOnly.setBackground(Color.lightGray);
        this.isLocal.setBackground(Color.lightGray);
        this.isReplaced.setBackground(Color.lightGray);
        this.isSideEffect.setBackground(Color.lightGray);
        jPanel.add("South", jPanel3);
        jPanel.add("Center", jPanel4);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.isVariable.addItemListener(this);
        this.isNegative.addItemListener(this);
        this.isReadOnly.addItemListener(this);
        this.isLocal.addItemListener(this);
        this.isReplaced.addItemListener(this);
        this.isSideEffect.addItemListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ModifierDialog.this.setVisible(false);
            }
        });
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.setVisible(false);
            if (this.caller != null) {
                int n = 0;
                n = Fact.setIsVariable(n, this.isVariable.isSelected());
                n = Fact.setIsNegative(n, this.isNegative.isEnabled() && this.isNegative.isSelected());
                n = Fact.setIsReadOnly(n, this.isReadOnly.isEnabled() && this.isReadOnly.isSelected());
                n = Fact.setIsLocal(n, this.isLocal.isEnabled() && this.isLocal.isSelected());
                n = Fact.setIsReplaced(n, this.isReplaced.isEnabled() && this.isReplaced.isSelected());
                n = Fact.setIsSideEffect(n, this.isSideEffect.isEnabled() && this.isSideEffect.isSelected());
                this.caller.factModifiersChanged(n);
            }
        } else if (object == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getSource();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.isNegative) {
            this.isReadOnly.setEnabled(!bl);
            this.isLocal.setEnabled(!bl);
            this.isReplaced.setEnabled(!bl);
        } else if (object == this.isReadOnly) {
            this.isNegative.setEnabled(!bl);
            this.isReplaced.setEnabled(!bl);
        } else if (object == this.isLocal) {
            this.isNegative.setEnabled(!bl);
        } else if (object == this.isReplaced) {
            this.isNegative.setEnabled(!bl);
            this.isReadOnly.setEnabled(!bl);
        }
    }

    public void display(FactModifier factModifier, int n, int n2) {
        this.caller = factModifier;
        this.isVariable.setSelected(Fact.isVariable(n));
        this.isVariable.setEnabled(false);
        if (n2 == 1) {
            this.isNegative.setEnabled(true);
            this.isReadOnly.setEnabled(true);
            this.isLocal.setEnabled(true);
            this.isReplaced.setEnabled(true);
            this.isSideEffect.setEnabled(false);
            this.isNegative.setSelected(Fact.isNegative(n));
            this.isReadOnly.setSelected(Fact.isReadOnly(n));
            this.isLocal.setSelected(Fact.isLocal(n));
            this.isReplaced.setSelected(Fact.isReplaced(n));
            this.isSideEffect.setSelected(false);
        } else {
            this.isNegative.setSelected(false);
            this.isReadOnly.setSelected(false);
            this.isLocal.setSelected(false);
            this.isReplaced.setSelected(false);
            this.isSideEffect.setSelected(Fact.isSideEffect(n));
            this.isNegative.setEnabled(false);
            this.isReadOnly.setEnabled(false);
            this.isLocal.setEnabled(false);
            this.isReplaced.setEnabled(false);
            this.isSideEffect.setEnabled(true);
        }
        this.setVisible(true);
        this.pack();
    }
}

