/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.util;

import java.util.EventListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.generator.event.FactModelEvent;
import zeus.generator.event.FactModelListener;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.generator.util.AttributeModel;
import zeus.generator.util.BasicFactModel;
import zeus.util.Core;

public class FactModel
extends AbstractTableModel
implements BasicFactModel,
ChangeListener {
    public static final int TYPE = 0;
    public static final int INSTANCE = 1;
    public static final int MODIFIERS = 2;
    public static final int FACT = 3;
    protected static int count = 0;
    protected static final boolean ERROR = true;
    protected static final boolean NO_ERROR = false;
    protected static final String[] columnNames = new String[]{"Fact Type", "Instance", "Modifiers"};
    protected EventListenerList listeners = new EventListenerList();
    protected Vector data = new Vector();
    protected int selectedRow = -1;
    protected AttributeModel attributeModel;
    protected OntologyDb ontologyDb;
    protected boolean isVariable;
    protected boolean isEditable = true;
    protected int type;
    protected Vector relatedModels = new Vector();
    static /* synthetic */ Class class$zeus$generator$event$FactModelListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$zeus$generator$event$RenameListener;

    public FactModel(OntologyDb ontologyDb, AttributeModel attributeModel, boolean bl, int n, Fact[] factArray) {
        this.ontologyDb = ontologyDb;
        this.attributeModel = attributeModel;
        this.isVariable = bl;
        this.type = n;
        ontologyDb.addChangeListener(this);
        this.reset(factArray);
    }

    public OntologyDb getOntologyDb() {
        return this.ontologyDb;
    }

    public AttributeModel getAttributeModel() {
        return this.attributeModel;
    }

    public void reset(Fact[] factArray) {
        int n = this.data.size();
        this.selectRow(-1);
        this.data.removeAllElements();
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        for (int i = 0; i < factArray.length; ++i) {
            this.data.addElement(factArray[i]);
        }
        this.fireTableRowsInserted(0, factArray.length - 1);
        this.fireTableStructureChanged();
    }

    public Fact[] getData() {
        Fact[] factArray = new Fact[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            factArray[i] = (Fact)this.data.elementAt(i);
        }
        return factArray;
    }

    public void addRelatedModel(FactModel factModel) {
        if (!this.relatedModels.contains(factModel)) {
            this.relatedModels.addElement(factModel);
        }
    }

    public void removeRelatedModel(FactModel factModel) {
        this.relatedModels.removeElement(factModel);
    }

    public void removeRows(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            Fact fact = (Fact)this.data.elementAt(nArray[i] - i);
            this.data.removeElementAt(nArray[i] - i);
            this.fireTableRowsDeleted(nArray[i] - i, nArray[i] - i);
            this.fireFactEvent(fact, 1);
        }
        this.selectRow(-1);
        this.fireChanged();
    }

    public void selectRow(int n) {
        this.selectedRow = n;
        if (this.attributeModel != null) {
            if (this.selectedRow >= 0) {
                this.attributeModel.reset((Fact)this.data.elementAt(this.selectedRow));
            } else {
                this.attributeModel.reset(null);
            }
        }
    }

    public void addNewRows(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        Fact[] factArray = new Fact[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            factArray[i] = this.ontologyDb.getFact(this.isVariable, stringArray[i]);
        }
        this.addRows(factArray);
    }

    public void addRows(Fact[] factArray) {
        if (factArray == null || factArray.length == 0) {
            return;
        }
        int n = this.data.size();
        for (int i = 0; i < factArray.length; ++i) {
            Fact fact = new Fact(factArray[i]);
            String string = fact.ID();
            while (this.contains(string, false)) {
                string = string + count++;
            }
            fact.setId(string);
            this.data.addElement(fact);
            this.fireFactEvent(fact, 0);
        }
        this.fireTableRowsInserted(n, n + factArray.length - 1);
        this.selectRow(-1);
        this.fireChanged();
    }

    public void removeRows(Fact[] factArray) {
        if (factArray == null || factArray.length == 0) {
            return;
        }
        for (int i = 0; i < factArray.length; ++i) {
            String string = factArray[i].ID();
            for (int j = 0; j < this.data.size(); ++j) {
                Fact fact = (Fact)this.data.elementAt(j);
                if (!fact.ID().equals(string)) continue;
                this.data.removeElementAt(j);
                this.fireTableRowsDeleted(j, j);
                this.fireFactEvent(fact, 1);
                --j;
            }
        }
        this.selectRow(-1);
        this.fireChanged();
    }

    public int getColumnCount() {
        if (this.type == 0) {
            return columnNames.length - 1;
        }
        return columnNames.length;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return this.isEditable && n2 != 0;
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public Object getValueAt(int n, int n2) {
        Fact fact = (Fact)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return fact.getType();
            }
            case 1: {
                return fact.getId();
            }
            case 2: {
                return new Integer(fact.getModifiers());
            }
            case 3: {
                return fact;
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object.toString().equals("")) {
            return;
        }
        Fact fact = (Fact)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                Core.ERROR(null, 1, (Object)this);
                break;
            }
            case 1: {
                String string = (String)object;
                String string2 = fact.ID();
                if (string2.equals(string)) {
                    return;
                }
                if (this.contains(string, true)) {
                    return;
                }
                String string3 = fact.getId();
                fact.setId(string);
                String string4 = fact.getId();
                this.fireTableCellUpdated(n, n2);
                this.fireNameChanged(fact, string3, string4);
                this.fireChanged();
                break;
            }
            case 2: {
                int n3 = (Integer)object;
                if (n3 == fact.getModifiers()) {
                    return;
                }
                fact.setModifiers(n3);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
                break;
            }
            case 3: {
                Core.ERROR(null, 2, (Object)this);
            }
        }
    }

    protected boolean contains(String string, boolean bl) {
        return this.contains(null, string, bl);
    }

    protected boolean contains(FactModel factModel, String string, boolean bl) {
        for (int i = 0; i < this.data.size(); ++i) {
            Fact fact = (Fact)this.data.elementAt(i);
            if (!string.equals(fact.ID())) continue;
            if (bl) {
                JOptionPane.showMessageDialog(null, "Attempting to rename fact to an already\nexisting name", "Error", 0);
            }
            return true;
        }
        for (int i = 0; i < this.relatedModels.size(); ++i) {
            FactModel factModel2 = (FactModel)this.relatedModels.elementAt(i);
            if (factModel2 == factModel || !factModel2.contains(this, string, bl)) continue;
            return true;
        }
        return false;
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void addFactModelListener(FactModelListener factModelListener) {
        this.listeners.add(class$zeus$generator$event$FactModelListener == null ? (class$zeus$generator$event$FactModelListener = FactModel.class$("zeus.generator.event.FactModelListener")) : class$zeus$generator$event$FactModelListener, factModelListener);
    }

    public void removeFactModelListener(FactModelListener factModelListener) {
        this.listeners.remove(class$zeus$generator$event$FactModelListener == null ? (class$zeus$generator$event$FactModelListener = FactModel.class$("zeus.generator.event.FactModelListener")) : class$zeus$generator$event$FactModelListener, factModelListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = FactModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = FactModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void addRenameListener(RenameListener renameListener) {
        this.listeners.add(class$zeus$generator$event$RenameListener == null ? (class$zeus$generator$event$RenameListener = FactModel.class$("zeus.generator.event.RenameListener")) : class$zeus$generator$event$RenameListener, renameListener);
    }

    public void removeRenameListener(RenameListener renameListener) {
        this.listeners.remove(class$zeus$generator$event$RenameListener == null ? (class$zeus$generator$event$RenameListener = FactModel.class$("zeus.generator.event.RenameListener")) : class$zeus$generator$event$RenameListener, renameListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? FactModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    protected void fireNameChanged(Object object, Object object2, Object object3) {
        RenameEvent renameEvent = new RenameEvent(this, object, object2, object3);
        FactModelEvent factModelEvent = new FactModelEvent(this, (Fact)object, 2, (String)object2, (String)object3);
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            EventListener eventListener;
            if (objectArray[i] == (class$zeus$generator$event$FactModelListener == null ? FactModel.class$("zeus.generator.event.FactModelListener") : class$zeus$generator$event$FactModelListener)) {
                eventListener = (FactModelListener)objectArray[i + 1];
                eventListener.factModelChanged(factModelEvent);
                continue;
            }
            if (objectArray[i] != (class$zeus$generator$event$RenameListener == null ? FactModel.class$("zeus.generator.event.RenameListener") : class$zeus$generator$event$RenameListener)) continue;
            eventListener = (RenameListener)objectArray[i + 1];
            eventListener.nameChanged(renameEvent);
        }
    }

    protected void fireFactEvent(Fact fact, int n) {
        FactModelEvent factModelEvent = new FactModelEvent(this, fact, n);
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$zeus$generator$event$FactModelListener == null ? FactModel.class$("zeus.generator.event.FactModelListener") : class$zeus$generator$event$FactModelListener)) continue;
            FactModelListener factModelListener = (FactModelListener)objectArray[i + 1];
            factModelListener.factModelChanged(factModelEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

