/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import zeus.generator.util.Editor;
import zeus.util.SystemProps;

public class ControlPanel
extends JPanel
implements ActionListener,
ChangeListener {
    protected JLabel msgField = new JLabel();
    protected JButton nextButton = new JButton();
    protected JButton previousButton = new JButton();
    protected JButton saveButton = new JButton();
    protected JToggleButton infoButton;
    protected Editor editor;

    public ControlPanel(Editor editor, String string, boolean bl, boolean bl2) {
        this.editor = editor;
        editor.addChangeListener(this);
        this.setBackground(Color.yellow);
        this.setBorder(BorderFactory.createBevelBorder(0));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Helvetica", 1, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 16, 0, 16);
        gridBagLayout.setConstraints(this.msgField, gridBagConstraints);
        this.add(this.msgField);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.yellow);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        String string2 = System.getProperty("file.separator");
        String string3 = SystemProps.getProperty("gif.dir") + "generator" + string2;
        this.previousButton.setIcon(new ImageIcon(string3 + "previous.gif"));
        this.previousButton.setDisabledIcon(new ImageIcon(string3 + "next.gif"));
        this.previousButton.addActionListener(this);
        this.previousButton.setOpaque(true);
        this.previousButton.setMargin(new Insets(0, 0, 0, 0));
        if (bl) {
            this.previousButton.setEnabled(false);
            this.previousButton.setToolTipText("No Earlier Stage");
        } else {
            this.previousButton.setToolTipText("Go Back to Previous Design Stage");
        }
        jPanel.add(this.previousButton);
        jPanel.add(Box.createHorizontalStrut(16));
        this.saveButton.setOpaque(true);
        this.saveButton.setMargin(new Insets(0, 0, 0, 0));
        this.saveButton.setIcon(new ImageIcon(string3 + "save.gif"));
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(this);
        jPanel.add(this.saveButton);
        this.infoButton = new JToggleButton(new ImageIcon(string3 + "info.gif"));
        this.infoButton.setMargin(new Insets(0, 0, 0, 0));
        this.infoButton.setOpaque(true);
        this.infoButton.addActionListener(this);
        this.infoButton.setToolTipText("Methodology Documentation");
        jPanel.add(this.infoButton);
        jPanel.add(Box.createHorizontalStrut(16));
        this.nextButton.setIcon(new ImageIcon(string3 + "next.gif"));
        this.nextButton.setMargin(new Insets(0, 0, 0, 0));
        this.nextButton.setDisabledIcon(new ImageIcon(string3 + "previous.gif"));
        this.nextButton.addActionListener(this);
        this.nextButton.setOpaque(true);
        if (bl2) {
            this.nextButton.setEnabled(false);
            this.nextButton.setToolTipText("This is the Final Stage");
        } else {
            this.nextButton.setToolTipText("Go to Next Design Stage");
        }
        jPanel.add(this.nextButton);
        this.msgField.setForeground(Color.green);
        this.msgField.setText(editor.getObjectName());
        this.msgField.setMinimumSize(new Dimension(200, 20));
        this.msgField.setPreferredSize(new Dimension(200, 20));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        boolean bl = this.editor.hasChanged();
        this.saveButton.setEnabled(bl);
        String string = this.editor.getObjectName();
        if (bl) {
            string = string + " [Modified]";
            this.saveButton.setToolTipText("Save Changes to Disk");
        } else {
            this.saveButton.setToolTipText("No Save Necessary");
        }
        this.msgField.setText(string);
        this.saveButton.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.previousButton) {
            this.editor.previous();
        } else if (object == this.infoButton) {
            this.editor.help(this.infoButton);
        } else if (object == this.saveButton) {
            this.editor.save();
        } else if (object == this.nextButton) {
            this.editor.next();
        }
    }
}

