/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.util;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.Fact;
import zeus.concepts.ZeusParser;
import zeus.concepts.fn.ValueFunction;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.gui.editors.ValidatingModel;
import zeus.util.Core;
import zeus.util.Misc;

public class AttributeModel
extends AbstractTableModel
implements ChangeListener,
ValidatingModel,
RenameListener {
    public static final int ATTRIBUTE = 0;
    public static final int VALUE = 1;
    public static final int RESTRICTION = 2;
    protected EventListenerList changeListeners = new EventListenerList();
    protected String[] columnNames = new String[]{"Attribute", "Value", "Restriction"};
    protected String[][] data = new String[0][this.columns];
    protected Fact fact;
    protected int columns = 2;
    protected boolean restrictions;
    protected boolean[] permissions = new boolean[]{false, true, true};
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public void reset(Fact fact) {
        this.fact = fact;
        if (fact == null) {
            this.data = new String[0][this.columns];
        } else {
            String[] stringArray = fact.listAttributes();
            ValueFunction[] valueFunctionArray = fact.listValues();
            this.data = new String[valueFunctionArray.length][this.columns];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i][0] = stringArray[i];
                this.data[i][1] = valueFunctionArray[i].toString();
            }
        }
        this.fireTableDataChanged();
    }

    public Fact getData() {
        return this.fact;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return this.permissions[n2];
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    public boolean isValidEntry(int n, int n2) {
        switch (n2) {
            case 1: {
                if (this.data[n][n2] == null) {
                    return true;
                }
                if (this.data[n][n2].equals("")) {
                    return true;
                }
                return ZeusParser.Expression(this.data[n][n2]) != null;
            }
            case 0: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void setRestriction(String string, int n) {
        if (string != null) {
            this.data[n][2] = string;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        String string;
        if (n2 == 2) {
            if (object != null) {
                this.data[n][2] = object.toString();
                this.fireChanged();
                this.fireTableCellUpdated(n, n2);
            }
            return;
        }
        Core.ERROR(n2 == 1, 1, (Object)this);
        String string2 = string = object == null ? null : ((String)object).trim();
        if (string.equals("")) {
            string = null;
        }
        if (string == null) {
            if (this.data[n][1] == null) {
                return;
            }
            this.data[n][1] = string;
            this.fact.setValue(this.data[n][0], this.fact.newVar());
        } else {
            string = Misc.substitute(string, this.fact.getId(), "?this");
            if (this.data[n][1] != null && this.data[n][1].equals(string)) {
                return;
            }
            this.data[n][1] = string;
            ValueFunction valueFunction = ZeusParser.Expression(this.data[n][1]);
            if (valueFunction != null) {
                this.fact.setValue(this.data[n][0], valueFunction);
            }
        }
        this.fireChanged();
        this.fireTableCellUpdated(n, n2);
    }

    public void nameChanged(RenameEvent renameEvent) {
        String string = (String)renameEvent.getOriginal();
        String string2 = (String)renameEvent.getCurrent();
        for (int i = 0; i < this.data.length; ++i) {
            String string3;
            if (this.data[i][1] == null || (string3 = Misc.substitute(this.data[i][1], string, string2)).equals(this.data[i][1])) continue;
            this.setValueAt(string3, i, 1);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.reset(this.fact);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AttributeModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AttributeModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? AttributeModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    public void enableRestrictions() {
        if (!this.restrictions) {
            ++this.columns;
            this.restrictions = true;
            this.reset(this.fact);
        }
    }

    public void disableRestrictions() {
        if (this.restrictions) {
            --this.columns;
            this.restrictions = false;
            this.reset(this.fact);
        }
    }

    public void setReadOnly(int n) {
        this.permissions[n] = false;
    }

    public void setWriteable(int n) {
        this.permissions[n] = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

