/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task.rulebase;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import zeus.concepts.OntologyDb;
import zeus.concepts.Performative;
import zeus.concepts.ReteKB;
import zeus.generator.task.rulebase.FactPanel;
import zeus.generator.task.rulebase.Rule;
import zeus.generator.task.rulebase.RuleModel;
import zeus.generator.util.ControlPanel;
import zeus.generator.util.Editor;
import zeus.gui.fields.WholeNumberField;
import zeus.rete.Action;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class RuleUI
extends JPanel
implements ListSelectionListener,
FocusListener,
ActionListener {
    private JPanel contentPane;
    private JTable ruleTable;
    private JScrollPane ruleSP;
    private JScrollPane lhsSP;
    private JScrollPane rhsSP;
    private JTextArea lhsArea;
    private JTextArea rhsArea;
    private RuleModel ruleBuffer;
    private JComboBox predicateList;
    private JComboBox actionList;
    private JComboBox functionList;
    private JButton predicateBtn;
    private JButton actionBtn;
    private JButton functionBtn;
    protected FactPanel factPanel;
    protected boolean lhsFocus;
    protected boolean rhsFocus;
    protected JMenuItem fsave;
    protected JMenuItem fexit;
    protected OntologyDb db = null;
    protected ReteKB kb = null;
    private final int WIDTH = 640;
    private final int HEIGHT = 480;
    private final int LWIDTH = 300;
    private final int LHEIGHT = 250;
    private JFrame frame;
    protected String[] precedenceWds = Action.types;
    protected String[] booleanWds = new String[]{"not", "test"};
    protected Vector methodValues;
    protected SimpleAttributeSet boolFmt;
    protected SimpleAttributeSet preFmt;
    protected SimpleAttributeSet methFmt;
    protected SimpleAttributeSet plainFmt;

    public RuleUI(OntologyDb ontologyDb, Editor editor, ReteKB reteKB, Vector vector) {
        this.methodValues = vector;
        this.db = ontologyDb;
        this.kb = reteKB;
        this.ruleBuffer = new RuleModel(reteKB, ontologyDb);
        this.ruleBuffer.addChangeListener(editor);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createBevelBorder(1));
        ControlPanel controlPanel = new ControlPanel(editor, "Rulebase Editor", true, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(controlPanel, gridBagConstraints);
        this.add(controlPanel);
        JPanel jPanel = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBackground(Color.lightGray);
        RuleToolBar ruleToolBar = new RuleToolBar();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(ruleToolBar, gridBagConstraints);
        jPanel.add(ruleToolBar);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12);
        tableColumn.setHeaderValue(this.ruleBuffer.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 12, new DefaultTableCellRenderer(), new DefaultCellEditor(new WholeNumberField(0, 9)));
        tableColumn.setHeaderValue(this.ruleBuffer.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        this.ruleTable = new JTable(this.ruleBuffer, defaultTableColumnModel);
        this.ruleTable.getTableHeader().setReorderingAllowed(false);
        this.ruleTable.setColumnSelectionAllowed(false);
        this.ruleSP = new JScrollPane(this.ruleTable);
        this.ruleSP.setPreferredSize(new Dimension(400, 150));
        this.ruleTable.getSelectionModel().setSelectionMode(0);
        this.ruleTable.getSelectionModel().addListSelectionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        gridBagLayout.setConstraints(this.ruleSP, gridBagConstraints);
        jPanel.add(this.ruleSP);
        JPanel jPanel2 = this.getIfThenPanel();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel2 = this.getUtilitiesPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.lhsFocus = false;
        this.rhsFocus = false;
    }

    public void save() {
        this.kb.setRules(this.ruleBuffer.getData());
    }

    void setTextFormats() {
        this.boolFmt = new SimpleAttributeSet();
        StyleConstants.setForeground(this.boolFmt, Color.red);
        this.preFmt = new SimpleAttributeSet();
        StyleConstants.setForeground(this.preFmt, Color.blue);
        this.methFmt = new SimpleAttributeSet();
        StyleConstants.setForeground(this.methFmt, Color.green);
        this.plainFmt = new SimpleAttributeSet();
        StyleConstants.setForeground(this.plainFmt, Color.black);
    }

    void createFrame() {
        this.frame = new JFrame("Rule Editor");
        this.frame.getContentPane().add(this);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this.fsave = new JMenuItem("Save");
        this.fsave.addActionListener(this);
        jMenu.add(this.fsave);
        this.fexit = new JMenuItem("Exit");
        this.fexit.addActionListener(this);
        jMenu.add(this.fexit);
        this.frame.setJMenuBar(jMenuBar);
        this.frame.pack();
        this.frame.show();
    }

    JPanel getUtilitiesPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBackground(Color.lightGray);
        this.functionBtn = new JButton("Insert Function");
        this.functionBtn.addActionListener(this);
        this.functionBtn.setToolTipText("Click to insert selected function");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        gridBagLayout.setConstraints(this.functionBtn, gridBagConstraints);
        jPanel.add(this.functionBtn);
        this.functionList = new JComboBox(this.methodValues){

            public void contentsChanged(ListDataEvent listDataEvent) {
                this.selectedItemReminder = null;
                super.contentsChanged(listDataEvent);
            }
        };
        this.functionList.addActionListener(this);
        this.functionList.setForeground(Color.green);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        gridBagLayout.setConstraints(this.functionList, gridBagConstraints);
        jPanel.add(this.functionList);
        this.predicateBtn = new JButton("Insert Predicate");
        this.predicateBtn.addActionListener(this);
        this.predicateBtn.setToolTipText("Click to insert selected predicate");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        gridBagLayout.setConstraints(this.predicateBtn, gridBagConstraints);
        jPanel.add(this.predicateBtn);
        this.predicateList = new JComboBox(this.booleanWds){

            public void contentsChanged(ListDataEvent listDataEvent) {
                this.selectedItemReminder = null;
                super.contentsChanged(listDataEvent);
            }
        };
        this.predicateList.addActionListener(this);
        this.functionList.setForeground(Color.red);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        gridBagLayout.setConstraints(this.predicateList, gridBagConstraints);
        jPanel.add(this.predicateList);
        this.actionBtn = new JButton("Insert Action");
        this.actionBtn.addActionListener(this);
        this.actionBtn.setToolTipText("Click to insert selected action");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        gridBagLayout.setConstraints(this.actionBtn, gridBagConstraints);
        jPanel.add(this.actionBtn);
        this.actionList = new JComboBox(this.precedenceWds){

            public void contentsChanged(ListDataEvent listDataEvent) {
                this.selectedItemReminder = null;
                super.contentsChanged(listDataEvent);
            }
        };
        this.actionList.addActionListener(this);
        this.functionList.setForeground(Color.blue);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        gridBagLayout.setConstraints(this.actionList, gridBagConstraints);
        jPanel.add(this.actionList);
        this.factPanel = new FactPanel(this, this.db);
        this.factPanel.setBorder(this.makeBorder("Ontology"));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagLayout.setConstraints(this.factPanel, gridBagConstraints);
        jPanel.add(this.factPanel);
        return jPanel;
    }

    JTextArea getLastTextAreaWithFocus() {
        if (this.lhsFocus) {
            return this.lhsArea;
        }
        if (this.rhsFocus) {
            return this.rhsArea;
        }
        return null;
    }

    void setFocus(JTextArea jTextArea) {
        if (jTextArea == this.lhsArea) {
            this.lhsFocus = true;
            this.rhsFocus = false;
        } else if (jTextArea == this.rhsArea) {
            this.rhsFocus = true;
            this.lhsFocus = false;
        }
    }

    void appendTextTo(JTextArea jTextArea, String string, boolean bl) {
        int n = jTextArea.getCaretPosition();
        Document document = null;
        if (jTextArea == this.lhsArea) {
            document = this.lhsArea.getDocument();
            this.insert(document, string, n);
        } else if (jTextArea == this.rhsArea) {
            document = this.rhsArea.getDocument();
            this.insert(document, string, n);
        }
        if (bl && !this.methodValues.contains(string)) {
            jTextArea.setCaretPosition(jTextArea.getCaretPosition() - 1);
        } else {
            jTextArea.setCaretPosition(jTextArea.getDocument().getLength());
            try {
                document.insertString(jTextArea.getCaretPosition(), "\n", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    void insert(Document document, String string, int n) {
        try {
            if (Misc.member(string, this.booleanWds)) {
                document.insertString(n, "(" + string + " )", null);
            } else if (Misc.member(string, this.precedenceWds)) {
                if (string.equals(Action.types[4])) {
                    string = string + " ";
                    for (int i = 0; i < Performative.ATTRIBUTE_TYPES.length; ++i) {
                        string = string + "(" + Performative.ATTRIBUTE_TYPES[i] + " " + "?" + this.db.GenSym().plainId("var") + ")";
                    }
                    document.insertString(n, "(" + string + ")", null);
                } else if (string.equals(Action.types[5]) || string.equals(Action.types[6]) || string.equals(Action.types[7])) {
                    string = string + " ";
                    for (int i = 0; i < OntologyDb.GOAL_ATTRIBUTES.length; ++i) {
                        string = string + "(" + OntologyDb.GOAL_ATTRIBUTES[i] + " " + "?" + this.db.GenSym().plainId("var") + ")";
                    }
                    document.insertString(n, "(" + string + ")", null);
                } else if (string.equals(Action.types[10])) {
                    document.insertString(n, "(" + string + "  \n then\n\n else\n\n)", null);
                } else if (string.equals(Action.types[11])) {
                    document.insertString(n, "(" + string + "  \n do\n\n)", null);
                } else {
                    document.insertString(n, "(" + string + " )", null);
                }
            } else if (this.methodValues.contains(string)) {
                document.insertString(n, string, null);
            } else {
                document.insertString(n, string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void appendTextTo(String string) {
        JTextArea jTextArea = this.getLastTextAreaWithFocus();
        if (jTextArea != null) {
            this.appendTextTo(jTextArea, string, false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextArea jTextArea;
        Object object = actionEvent.getSource();
        String string = null;
        if (object == this.fsave) {
            this.writeRulesToFile();
        } else if (object == this.fexit) {
            System.exit(0);
        } else if ((object == this.predicateList || object == this.predicateBtn || object == this.functionList || object == this.functionBtn || object == this.actionList || object == this.actionBtn) && (jTextArea = this.getLastTextAreaWithFocus()) != null) {
            if (object == this.predicateList || object == this.predicateBtn) {
                string = (String)this.predicateList.getSelectedItem();
            } else if (object == this.actionList || object == this.actionBtn) {
                string = (String)this.actionList.getSelectedItem();
            } else if (object == this.functionList || object == this.functionBtn) {
                string = (String)this.functionList.getSelectedItem();
            }
            if (string != null) {
                if (Misc.member(string, this.precedenceWds) && jTextArea != this.rhsArea) {
                    return;
                }
                this.appendTextTo(jTextArea, string, true);
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        JTextArea jTextArea = (JTextArea)focusEvent.getSource();
        this.setFocus(jTextArea);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    JPanel getIfThenPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel.setBackground(Color.lightGray);
        this.lhsArea = new JTextArea(new PlainDocument(), "", 6, 80);
        this.lhsSP = new JScrollPane(this.lhsArea);
        this.lhsSP.setBorder(this.makeBorder("Conditions"));
        this.lhsArea.addFocusListener(this);
        this.lhsSP.setPreferredSize(new Dimension(500, 100));
        jPanel.add(this.lhsSP);
        this.rhsArea = new JTextArea(new PlainDocument(), "", 6, 80);
        this.rhsSP = new JScrollPane(this.rhsArea);
        this.rhsSP.setBorder(this.makeBorder("Actions"));
        this.rhsSP.setPreferredSize(new Dimension(500, 100));
        this.rhsArea.addFocusListener(this);
        jPanel.add(this.rhsSP);
        this.lhsArea.setLineWrap(true);
        this.lhsArea.setWrapStyleWord(true);
        this.rhsArea.setLineWrap(true);
        this.rhsArea.setWrapStyleWord(true);
        return jPanel;
    }

    private TitledBorder makeBorder(String string) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder.setTitleColor(Color.black);
        return titledBorder;
    }

    void writeRulesToFile() {
        File file = null;
        String string = System.getProperty("file.separator");
        String string2 = SystemProps.getProperty("zeus.dir") + "rete" + string + "clp" + string;
        String string3 = SystemProps.getProperty("gir.dir") + "generator" + "kb.gif";
        JFileChooser jFileChooser = new JFileChooser(new File(string2));
        int n = jFileChooser.showSaveDialog(this.frame);
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        if (file == null) {
            JOptionPane.showMessageDialog(null, "File hasn't been specified", "Error", 0);
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            Vector vector = this.ruleBuffer.getRules();
            for (int i = 0; i < vector.size(); ++i) {
                Rule rule = (Rule)vector.elementAt(i);
                this.printRule(rule, printWriter);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void printRule(Rule rule, PrintWriter printWriter) {
        printWriter.println("   (" + rule.name);
        printWriter.println();
        printWriter.println(rule.getCondition().trim());
        printWriter.println("=>");
        printWriter.println(rule.getConclusion().trim());
        printWriter.println();
        printWriter.println("   )");
        printWriter.println();
        printWriter.println();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getSource() == this.ruleTable.getSelectionModel() && (n = this.ruleTable.getSelectedRow()) >= 0 && n < this.ruleBuffer.getRowCount()) {
            this.lhsArea.setDocument(this.ruleBuffer.getRule(n).getLHS());
            this.rhsArea.setDocument(this.ruleBuffer.getRule(n).getRHS());
        }
    }

    class RuleToolBar
    extends JToolBar
    implements ActionListener {
        protected JButton newBtn;
        protected JButton deleteBtn;

        public RuleToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new1.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("New rule");
            this.newBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete");
            this.deleteBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                RuleUI.this.ruleBuffer.addRule();
            } else if (object == this.deleteBtn) {
                int n = RuleUI.this.ruleTable.getSelectedRow();
                if (n != -1 && n <= RuleUI.this.ruleBuffer.getRowCount()) {
                    RuleUI.this.ruleBuffer.deleteRule(n);
                }
                RuleUI.this.ruleTable.clearSelection();
                RuleUI.this.lhsArea.setText("");
                RuleUI.this.rhsArea.setText("");
            }
        }
    }
}

