/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task.rulebase;

import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.OntologyDb;
import zeus.concepts.ReteKB;
import zeus.concepts.ZeusParser;
import zeus.generator.task.rulebase.Rule;
import zeus.rete.Action;
import zeus.rete.Pattern;

public class RuleModel
extends AbstractTableModel
implements ChangeListener {
    static final int RULE = 0;
    static final int PRIORITY = 1;
    static final String[] header = new String[]{"Rule", "Priority"};
    Vector rules;
    OntologyDb ontology;
    static int RULE_COUNT = 0;
    protected EventListenerList changeListeners = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public RuleModel(ReteKB reteKB, OntologyDb ontologyDb) {
        this.rules = new Vector();
        this.ontology = ontologyDb;
        zeus.rete.Rule[] ruleArray = reteKB.getRules();
        for (int i = 0; i < ruleArray.length; ++i) {
            this.addRule(ruleArray[i]);
        }
    }

    public int getRowCount() {
        return this.rules.size();
    }

    public int getColumnCount() {
        return header.length;
    }

    public String getColumnName(int n) {
        return header[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        Rule rule = (Rule)this.rules.elementAt(n);
        switch (n2) {
            case 0: {
                return rule.getName();
            }
            case 1: {
                return new Integer(rule.getPriority());
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        Rule rule = (Rule)this.rules.elementAt(n);
        switch (n2) {
            case 0: {
                String string = (String)object;
                if (string.equals(rule.getName())) {
                    return;
                }
                rule.setName(string);
                break;
            }
            case 1: {
                int n3 = Integer.parseInt((String)object);
                if (n3 == rule.getPriority()) {
                    return;
                }
                rule.setPriority(n3);
            }
        }
        this.fireChanged();
    }

    public void addRule(zeus.rete.Rule rule) {
        String string = rule.getName();
        int n = rule.getSalience();
        Rule rule2 = new Rule(string, n);
        rule2.setPatterns(rule.getPatterns());
        rule2.setActions(rule.getActions());
        rule2.addChangeListener(this);
        this.rules.addElement(rule2);
        this.fireTableDataChanged();
        this.fireChanged();
    }

    public zeus.rete.Rule[] getData() {
        zeus.rete.Rule rule = null;
        Rule rule2 = null;
        Vector vector = null;
        Vector vector2 = null;
        zeus.rete.Rule[] ruleArray = new zeus.rete.Rule[this.rules.size()];
        for (int i = 0; i < this.rules.size(); ++i) {
            rule2 = (Rule)this.rules.elementAt(i);
            rule = new zeus.rete.Rule(rule2.getName(), rule2.getPriority());
            try {
                vector2 = ZeusParser.retePatternList(this.ontology, rule2.getPatterns());
                this.addPatterns(rule, vector2);
                vector = ZeusParser.reteActionList(this.ontology, rule2.getActions());
                this.addActions(rule, vector);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Syntax error parsing rule '" + rule2.getName() + "'", "Syntax Error", 0);
            }
            ruleArray[i] = rule;
        }
        return ruleArray;
    }

    private void addActions(zeus.rete.Rule rule, Vector vector) {
        Action action = null;
        for (int i = 0; i < vector.size(); ++i) {
            action = (Action)vector.elementAt(i);
            rule.addAction(action);
        }
    }

    private void addPatterns(zeus.rete.Rule rule, Vector vector) {
        Pattern pattern = null;
        for (int i = 0; i < vector.size(); ++i) {
            pattern = (Pattern)vector.elementAt(i);
            rule.addPattern(pattern);
        }
    }

    public void addRule() {
        String string = "Rule" + RULE_COUNT++;
        while (this.existRuleName(string)) {
            string = "Rule" + RULE_COUNT++;
        }
        Rule rule = new Rule(string, 5);
        rule.addChangeListener(this);
        this.rules.addElement(rule);
        this.fireTableDataChanged();
        this.fireChanged();
    }

    public void deleteRule(int n) {
        Rule rule = (Rule)this.rules.elementAt(n);
        this.rules.removeElementAt(n);
        rule.removeChangeListener(this);
        this.fireTableDataChanged();
        this.fireChanged();
    }

    private boolean existRuleName(String string) {
        for (int i = 0; i < this.rules.size(); ++i) {
            Rule rule = (Rule)this.rules.elementAt(i);
            if (!rule.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Rule getRule(int n) {
        Rule rule = (Rule)this.rules.elementAt(n);
        return rule;
    }

    public Vector getRules() {
        return this.rules;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = RuleModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = RuleModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? RuleModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

