/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.concepts.TaskLink;
import zeus.concepts.TaskNode;
import zeus.generator.task.GroupManager;
import zeus.generator.task.TaskLinkBaseTreeModel;
import zeus.generator.task.TaskLinkBaseTreePanel;
import zeus.generator.task.TaskLinkMainTreeModel;
import zeus.generator.task.TaskLinkMainTreePanel;
import zeus.generator.task.TaskLinkModel;
import zeus.generator.task.TaskNodePanel;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;

public class TaskLinkPanel
extends JPanel {
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};
    protected JTable linkTable;
    protected TaskLinkModel linkModel;
    protected TaskLinkBaseTreeModel baseModel;
    protected TaskLinkMainTreeModel mainModel;

    public TaskLinkPanel(ChangeListener changeListener, TaskNodePanel taskNodePanel, GroupManager groupManager, GroupManager groupManager2) {
        this.baseModel = new TaskLinkBaseTreeModel(groupManager, groupManager2);
        this.mainModel = new TaskLinkMainTreeModel();
        taskNodePanel.addRenameListener(this.mainModel);
        taskNodePanel.addRenameListener(this.baseModel);
        TaskLinkBaseTreePanel taskLinkBaseTreePanel = new TaskLinkBaseTreePanel(this.baseModel);
        TaskLinkMainTreePanel taskLinkMainTreePanel = new TaskLinkMainTreePanel(this.mainModel);
        taskLinkBaseTreePanel.addLinkRootSelectionListener(taskLinkMainTreePanel);
        this.linkModel = new TaskLinkModel(groupManager, groupManager2);
        taskNodePanel.addRenameListener(this.linkModel);
        this.linkModel.addChangeListener(changeListener);
        taskLinkBaseTreePanel.addLinkNodeSelectionListener(this.linkModel);
        taskLinkMainTreePanel.addLinkNodeSelectionListener(this.linkModel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createBevelBorder(1));
        JPanel jPanel = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Effect-Precondition Links");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel.setBackground(Color.lightGray);
        jPanel.add(taskLinkBaseTreePanel);
        jPanel.add(taskLinkMainTreePanel);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12);
        tableColumn.setHeaderValue(this.linkModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 12);
        tableColumn.setHeaderValue(this.linkModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        this.linkTable = new JTable(this.linkModel, defaultTableColumnModel);
        this.linkTable.getTableHeader().setReorderingAllowed(false);
        this.linkTable.setColumnSelectionAllowed(false);
        TaskLinkToolBar taskLinkToolBar = new TaskLinkToolBar();
        titledBorder = BorderFactory.createTitledBorder("Links");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel2.setBorder(titledBorder);
        gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBackground(Color.lightGray);
        JScrollPane jScrollPane = new JScrollPane(this.linkTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(340, 150));
        this.linkTable.setBackground(Color.white);
        this.linkTable.setMinimumSize(new Dimension(400, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(taskLinkToolBar, gridBagConstraints);
        jPanel2.add(taskLinkToolBar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
    }

    protected boolean isRowSelected(JTable jTable) {
        int n = jTable.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return false;
        }
        return true;
    }

    protected void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    TaskLink[] getLinks() {
        return this.linkModel.getData();
    }

    void reset(TaskNode taskNode, TaskNode[] taskNodeArray, TaskLink[] taskLinkArray) {
        String string = null;
        string = taskNode.isBeginNode() ? "EFFECTS" : (taskNode.isEndNode() ? "PRECONDITIONS" : "BOTH");
        this.baseModel.reset(string, taskNode.getName());
        this.mainModel.reset(taskNodeArray, taskNode.getName());
        this.linkModel.reset(taskNode.getName(), taskLinkArray);
    }

    class TaskLinkToolBar
    extends JToolBar
    implements ActionListener {
        protected HelpWindow helpWin;
        protected JToggleButton helpBtn;
        protected JButton addBtn;
        protected JButton deleteBtn;

        public TaskLinkToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.addBtn = new JButton(new ImageIcon(string2 + "add.gif"));
            this.addBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.addBtn);
            this.addBtn.setToolTipText("New");
            this.addBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void setEnabled(boolean bl) {
            this.addBtn.setEnabled(bl);
            this.deleteBtn.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.addBtn) {
                TaskLinkPanel.this.linkModel.addNewRow();
            } else if (object == this.deleteBtn) {
                if (!TaskLinkPanel.this.isRowSelected(TaskLinkPanel.this.linkTable)) {
                    return;
                }
                TaskLinkPanel.this.linkModel.removeRows(TaskLinkPanel.this.linkTable.getSelectedRows());
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", "Summary Task Link Table");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }
}

