/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.Fact;
import zeus.concepts.TaskLink;
import zeus.generator.event.LinkNodeSelectionEvent;
import zeus.generator.event.LinkNodeSelectionListener;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.generator.task.GroupManager;
import zeus.util.Core;

public class TaskLinkModel
extends AbstractTableModel
implements ChangeListener,
RenameListener,
LinkNodeSelectionListener {
    static final int LEFT = 0;
    static final int RIGHT = 1;
    static final String SEPARATOR = "::";
    protected static final String[] columnNames = new String[]{"From/Postconditions", "To/Preconditions"};
    protected GroupManager leftGroupManager;
    protected GroupManager rightGroupManager;
    protected EventListenerList changeListeners = new EventListenerList();
    protected Vector data = new Vector();
    protected String nodeName = null;
    protected String leftNode = null;
    protected String leftGroup = null;
    protected String leftType = null;
    protected String leftArg = null;
    protected String rightNode = null;
    protected String rightGroup = null;
    protected String rightType = null;
    protected String rightArg = null;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public TaskLinkModel(GroupManager groupManager, GroupManager groupManager2) {
        this.leftGroupManager = groupManager;
        this.rightGroupManager = groupManager2;
        groupManager.addChangeListener(this);
        groupManager2.addChangeListener(this);
        groupManager.addRenameListener(this);
        groupManager2.addRenameListener(this);
    }

    public void reset(String string, TaskLink[] taskLinkArray) {
        this.nodeName = string;
        this.rightArg = null;
        this.leftArg = null;
        this.rightType = null;
        this.leftType = null;
        this.rightGroup = null;
        this.leftGroup = null;
        this.rightNode = null;
        this.leftNode = null;
        int n = this.data.size();
        this.data.removeAllElements();
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        for (int i = 0; i < taskLinkArray.length; ++i) {
            if (!taskLinkArray[i].referencesNode(string)) continue;
            this.data.addElement(new TaskLink(taskLinkArray[i]));
        }
        this.fireTableRowsInserted(0, this.data.size() - 1);
        this.fireTableStructureChanged();
    }

    public TaskLink[] getData() {
        TaskLink[] taskLinkArray = new TaskLink[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            taskLinkArray[i] = (TaskLink)this.data.elementAt(i);
        }
        return taskLinkArray;
    }

    public void removeRows(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.data.removeElementAt(nArray[i] - i);
            this.fireTableRowsDeleted(nArray[i] - i, nArray[i] - i);
        }
        this.fireTableStructureChanged();
        this.fireChanged();
    }

    public void addNewRow() {
        TaskLink taskLink = this.getAddition();
        if (taskLink != null) {
            this.data.addElement(taskLink);
            int n = this.data.size();
            this.fireTableRowsInserted(n - 1, n - 1);
            this.fireTableStructureChanged();
            this.fireChanged();
        }
    }

    protected TaskLink getAddition() {
        if (this.leftNode == null || this.leftArg == null || this.leftGroup == null || this.leftType == null || this.rightNode == null || this.rightArg == null || this.rightGroup == null || this.rightType == null) {
            JOptionPane.showMessageDialog(null, "Attempting to add improperly defined link", "Error", 0);
            return null;
        }
        if (!this.rightType.equals(this.leftType)) {
            JOptionPane.showMessageDialog(null, "Attempting to add improperly defined link\nLeft and right fact types must be the same", "Error", 0);
            return null;
        }
        return new TaskLink(this.leftNode, this.leftGroup, this.leftArg, this.rightNode, this.rightGroup, this.rightArg);
    }

    protected Vector getConditions() {
        Fact fact;
        int n;
        Vector vector;
        Vector<String> vector2 = new Vector<String>();
        Hashtable hashtable = this.leftGroupManager.getManagerData();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            vector = (Vector)enumeration.nextElement();
            for (n = 0; n < vector.size(); ++n) {
                fact = (Fact)vector.elementAt(n);
                if (vector2.contains(fact.getId())) continue;
                vector2.addElement(fact.getId());
            }
        }
        hashtable = this.rightGroupManager.getManagerData();
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            vector = (Vector)enumeration.nextElement();
            for (n = 0; n < vector.size(); ++n) {
                fact = (Fact)vector.elementAt(n);
                if (vector2.contains(fact.getId())) continue;
                vector2.addElement(fact.getId());
            }
        }
        return vector2;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        TaskLink taskLink = (TaskLink)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return taskLink.getLeftNode() + SEPARATOR + taskLink.getLeftGroup() + SEPARATOR + taskLink.getLeftArg();
            }
            case 1: {
                return taskLink.getRightNode() + SEPARATOR + taskLink.getRightGroup() + SEPARATOR + taskLink.getRightArg();
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        Core.ERROR(null, 1, (Object)this);
    }

    public void linkNodeSelected(LinkNodeSelectionEvent linkNodeSelectionEvent) {
        if (linkNodeSelectionEvent.getType().equals("EFFECTS")) {
            this.leftNode = linkNodeSelectionEvent.getNodeName();
            this.leftGroup = linkNodeSelectionEvent.getGroupName();
            this.leftArg = linkNodeSelectionEvent.getFactId();
            this.leftType = linkNodeSelectionEvent.getFactType();
            if (this.rightNode != null && this.leftNode.equals(this.rightNode)) {
                this.rightType = null;
                this.rightArg = null;
                this.rightGroup = null;
                this.rightNode = null;
            }
        } else if (linkNodeSelectionEvent.getType().equals("PRECONDITIONS")) {
            this.rightNode = linkNodeSelectionEvent.getNodeName();
            this.rightGroup = linkNodeSelectionEvent.getGroupName();
            this.rightArg = linkNodeSelectionEvent.getFactId();
            this.rightType = linkNodeSelectionEvent.getFactType();
            if (this.leftNode != null && this.rightNode.equals(this.leftNode)) {
                this.leftType = null;
                this.leftArg = null;
                this.leftGroup = null;
                this.leftNode = null;
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.leftGroupManager || changeEvent.getSource() == this.rightGroupManager) {
            Vector vector = this.getConditions();
            for (int i = 0; i < this.data.size(); ++i) {
                TaskLink taskLink = (TaskLink)this.data.elementAt(i);
                if (taskLink.getLeftNode().equals(this.nodeName)) {
                    if (vector.contains(taskLink.getLeftArg())) continue;
                    this.data.removeElementAt(i--);
                    continue;
                }
                if (!taskLink.getRightNode().equals(this.nodeName) || vector.contains(taskLink.getRightArg())) continue;
                this.data.removeElementAt(i--);
            }
            this.fireTableDataChanged();
        }
    }

    public void nameChanged(RenameEvent renameEvent) {
        String string;
        String string2 = (String)renameEvent.getOriginal();
        if (string2.equals(string = (String)renameEvent.getCurrent())) {
            return;
        }
        for (int i = 0; i < this.data.size(); ++i) {
            TaskLink taskLink = (TaskLink)this.data.elementAt(i);
            if (taskLink.getLeftNode().equals(string2)) {
                taskLink.setLeftNode(string);
                continue;
            }
            if (taskLink.getLeftGroup().equals(string2)) {
                taskLink.setLeftGroup(string);
                continue;
            }
            if (taskLink.getLeftArg().equals(string2)) {
                taskLink.setLeftArg(string);
                continue;
            }
            if (taskLink.getRightNode().equals(string2)) {
                taskLink.setRightNode(string);
                continue;
            }
            if (taskLink.getRightGroup().equals(string2)) {
                taskLink.setRightGroup(string);
                continue;
            }
            if (!taskLink.getRightArg().equals(string2)) continue;
            taskLink.setRightArg(string);
        }
        if (this.nodeName == null || this.nodeName.equals(string2)) {
            this.nodeName = string;
        }
        if (this.leftNode != null && this.leftNode.equals(string2)) {
            this.leftNode = string;
        }
        if (this.rightNode != null && this.rightNode.equals(string2)) {
            this.rightNode = string;
        }
        if (this.leftGroup != null && this.leftGroup.equals(string2)) {
            this.leftGroup = string;
        }
        if (this.rightGroup != null && this.rightGroup.equals(string2)) {
            this.rightGroup = string;
        }
        if (this.leftArg != null && this.leftArg.equals(string2)) {
            this.leftArg = string;
        }
        if (this.rightArg != null && this.rightArg.equals(string2)) {
            this.rightArg = string;
        }
        this.fireTableDataChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = TaskLinkModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = TaskLinkModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? TaskLinkModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

