/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import zeus.concepts.Fact;
import zeus.concepts.TaskNode;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.generator.task.TaskLinkBaseTreeModel;
import zeus.util.Core;

public class TaskLinkMainTreeModel
extends DefaultTreeModel
implements RenameListener {
    static final String DEFAULT_ROOT = "#Root#";
    static final String PRECONDITIONS = "PRECONDITIONS";
    static final String EFFECTS = "EFFECTS";
    protected TaskNode[] nodes = new TaskNode[0];
    protected String ignoreNode;
    protected String mode = "PRECONDITIONS";

    public TaskLinkMainTreeModel() {
        super(new DefaultMutableTreeNode(DEFAULT_ROOT));
    }

    public TaskLinkMainTreeModel(TaskNode[] taskNodeArray, String string) {
        this();
        this.reset(taskNodeArray, string);
    }

    void reset(TaskNode[] taskNodeArray, String string) {
        this.nodes = taskNodeArray;
        this.ignoreNode = string;
        this.mode = PRECONDITIONS;
        this.refresh();
    }

    void refresh(String string) {
        this.setMode(string);
    }

    void refresh() {
        this.root = new DefaultMutableTreeNode(DEFAULT_ROOT);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].getName().equals(this.ignoreNode)) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.nodes[i].getName());
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            Hashtable hashtable = null;
            if (this.mode.equals(PRECONDITIONS)) {
                hashtable = this.nodes[i].getAllPreconditions();
            } else if (this.mode.equals(EFFECTS)) {
                hashtable = this.nodes[i].getAllPostconditions();
            } else {
                Core.ERROR(null, 2, (Object)this);
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                Vector vector = (Vector)hashtable.get(string);
                for (int j = 0; j < vector.size(); ++j) {
                    Fact fact = (Fact)vector.elementAt(j);
                    String string2 = TaskLinkBaseTreeModel.compoundName(fact.getType(), fact.getId());
                    DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(string2);
                    defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                }
            }
        }
        this.reload();
    }

    public void setMode(String string) {
        if (string.equals(this.mode)) {
            return;
        }
        Core.ERROR(string.equals(PRECONDITIONS) || string.equals(EFFECTS), 1, (Object)this);
        this.mode = string;
        this.refresh();
    }

    public void setInverseMode(String string) {
        String string2 = null;
        if (string.equals(PRECONDITIONS)) {
            string2 = EFFECTS;
        } else if (string.equals(EFFECTS)) {
            string2 = PRECONDITIONS;
        } else {
            Core.ERROR(null, 1, (Object)this);
        }
        if (this.mode != null && string2.equals(this.mode)) {
            return;
        }
        this.mode = string2;
        this.refresh();
    }

    public String getMode() {
        return this.mode;
    }

    public static String getFactType(String string) {
        return TaskLinkBaseTreeModel.getFactType(string);
    }

    public static String getFactId(String string) {
        return TaskLinkBaseTreeModel.getFactId(string);
    }

    public void nameChanged(RenameEvent renameEvent) {
        String string;
        String string2 = (String)renameEvent.getOriginal();
        if (string2.equals(string = (String)renameEvent.getCurrent())) {
            return;
        }
        if (this.ignoreNode == null || this.ignoreNode.equals(string2)) {
            this.ignoreNode = string;
        }
    }
}

