/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import zeus.concepts.Fact;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.generator.task.GroupManager;
import zeus.util.Core;

public class TaskLinkBaseTreeModel
extends DefaultTreeModel
implements ChangeListener,
RenameListener {
    static final String PRECONDITIONS = "PRECONDITIONS";
    static final String EFFECTS = "EFFECTS";
    static final String BOTH = "BOTH";
    static final String LEFT_SEPARATOR = "[";
    static final String RIGHT_SEPARATOR = "] ";
    static final String[] INVISIBLE_ITEMS = new String[]{"PRECONDITIONS", "EFFECTS"};
    protected GroupManager leftGroupManager = null;
    protected GroupManager rightGroupManager = null;
    protected String mode = "BOTH";
    protected String nodeName = "--undefined--";

    public TaskLinkBaseTreeModel(GroupManager groupManager, GroupManager groupManager2) {
        super(new DefaultMutableTreeNode("--undefined--"));
        this.leftGroupManager = groupManager;
        this.rightGroupManager = groupManager2;
        groupManager.addChangeListener(this);
        groupManager2.addChangeListener(this);
        groupManager.addRenameListener(this);
        groupManager2.addRenameListener(this);
        this.refresh();
    }

    void reset(String string, String string2) {
        this.nodeName = string2;
        this.setMode(string);
    }

    String getNodeName() {
        return this.nodeName;
    }

    void refresh(String string) {
        this.setMode(string);
    }

    void refresh() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        String string;
        Fact fact;
        int n;
        Vector vector;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        String string2;
        Enumeration enumeration;
        Hashtable hashtable;
        this.root = new DefaultMutableTreeNode(this.nodeName);
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)this.root;
        if (this.mode.equals(BOTH) || this.mode.equals(PRECONDITIONS)) {
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(PRECONDITIONS);
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            hashtable = this.leftGroupManager.getManagerData();
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
                defaultMutableTreeNode4.add(defaultMutableTreeNode2);
                vector = (Vector)hashtable.get(string2);
                for (n = 0; n < vector.size(); ++n) {
                    fact = (Fact)vector.elementAt(n);
                    string = TaskLinkBaseTreeModel.compoundName(fact.getType(), fact.getId());
                    defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                }
            }
        }
        if (this.mode.equals(BOTH) || this.mode.equals(EFFECTS)) {
            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(EFFECTS);
            defaultMutableTreeNode3.add(defaultMutableTreeNode5);
            hashtable = this.rightGroupManager.getManagerData();
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
                defaultMutableTreeNode5.add(defaultMutableTreeNode2);
                vector = (Vector)hashtable.get(string2);
                for (n = 0; n < vector.size(); ++n) {
                    fact = (Fact)vector.elementAt(n);
                    string = TaskLinkBaseTreeModel.compoundName(fact.getType(), fact.getId());
                    defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                }
            }
        }
        this.reload();
    }

    public void setMode(String string) {
        Core.ERROR(string.equals(BOTH) || string.equals(PRECONDITIONS) || string.equals(EFFECTS), 1, (Object)this);
        this.mode = string;
        this.refresh();
    }

    public static String getFactType(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
        return stringTokenizer.nextToken();
    }

    public static String getFactId(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
        stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }

    public static String compoundName(String string, String string2) {
        return LEFT_SEPARATOR + string + RIGHT_SEPARATOR + string2;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.refresh();
    }

    public void nameChanged(RenameEvent renameEvent) {
        String string;
        String string2 = (String)renameEvent.getOriginal();
        if (string2.equals(string = (String)renameEvent.getCurrent())) {
            return;
        }
        if (this.nodeName.equals(string2)) {
            this.nodeName = string;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root;
            defaultMutableTreeNode.setUserObject(this.nodeName);
            this.nodeChanged(this.root);
        } else {
            this.refresh();
        }
    }
}

