/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import zeus.concepts.AbstractTask;
import zeus.concepts.OntologyDb;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.ReteKB;
import zeus.concepts.SummaryTask;
import zeus.concepts.Task;
import zeus.generator.AgentGenerator;
import zeus.generator.GeneratorModel;
import zeus.generator.task.ConditionsPanel;
import zeus.generator.task.ConstraintsPanel;
import zeus.generator.task.InformationPanel;
import zeus.generator.task.NodesPanel;
import zeus.generator.task.rulebase.RuleUI;
import zeus.generator.util.Editor;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;

public class TaskEditor
extends JFrame
implements Editor {
    protected JTabbedPane tabbedPane;
    protected AgentGenerator generator;
    protected GeneratorModel genmodel;
    protected OntologyDb ontologyDb;
    protected HelpWindow helpWin;
    protected boolean changed;
    protected EventListenerList changeListeners = new EventListenerList();
    protected AbstractTask currentTask;
    protected ConditionsPanel conditionsPanel;
    protected ConstraintsPanel constraintsPanel;
    protected InformationPanel infoPanel;
    protected NodesPanel nodesPanel;
    protected RuleUI rulebasePanel;
    static final String[] MESSAGE = new String[]{"Save task?", "Save needed", "Task Editor: "};
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public TaskEditor(AgentGenerator agentGenerator, GeneratorModel generatorModel, OntologyDb ontologyDb, AbstractTask abstractTask) {
        this.generator = agentGenerator;
        this.genmodel = generatorModel;
        this.currentTask = abstractTask;
        this.ontologyDb = ontologyDb;
        this.changed = false;
        generatorModel.addChangeListener(this);
        this.getContentPane().setBackground(Color.lightGray);
        this.getContentPane().setLayout(new BorderLayout());
        String string = System.getProperty("file.separator");
        String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
        ImageIcon imageIcon = new ImageIcon(string2 + "edit.gif");
        this.setIconImage(imageIcon.getImage());
        this.tabbedPane = new JTabbedPane();
        if (abstractTask.isPrimitive()) {
            this.conditionsPanel = new ConditionsPanel(agentGenerator, generatorModel, ontologyDb, this, (PrimitiveTask)abstractTask);
            this.constraintsPanel = new ConstraintsPanel(agentGenerator, generatorModel, ontologyDb, this, (Task)abstractTask, this.conditionsPanel.getPreconditionsModel(), this.conditionsPanel.getPostconditionsModel());
            this.infoPanel = new InformationPanel((Task)abstractTask);
            this.tabbedPane.addTab("Preconditions and Effects", this.conditionsPanel);
            this.tabbedPane.addTab("Constraints", this.constraintsPanel);
            this.tabbedPane.addTab("Information", this.infoPanel);
        } else if (abstractTask.isSummary() || abstractTask.isScript()) {
            this.nodesPanel = new NodesPanel(agentGenerator, generatorModel, ontologyDb, this, (SummaryTask)abstractTask);
            this.constraintsPanel = new ConstraintsPanel(agentGenerator, generatorModel, ontologyDb, this, (Task)abstractTask, this.nodesPanel.getPreconditionsModel(), this.nodesPanel.getPostconditionsModel());
            this.tabbedPane.addTab("Decomposition Graph", this.nodesPanel);
            this.tabbedPane.addTab("Constraints", this.constraintsPanel);
        } else if (abstractTask.isBehaviour()) {
            this.rulebasePanel = new RuleUI(ontologyDb, this, (ReteKB)abstractTask, new Vector());
            this.tabbedPane.addTab("Behaviour Rulebase", this.rulebasePanel);
        }
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.setTabPlacement(3);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TaskEditor.this.closeDown();
            }
        });
        String string3 = generatorModel.getTaskName(abstractTask.getName());
        this.setTitle(abstractTask.getTypeName() + " " + MESSAGE[2] + string3);
        this.pack();
        this.repaint();
        generatorModel.addChangeListener(new SymChangeListener());
    }

    public void previous() {
        if (this.tabbedPane.getSelectedIndex() > 0) {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.getSelectedIndex() - 1);
        }
    }

    public void next() {
        if (this.tabbedPane.getSelectedIndex() + 1 < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.getSelectedIndex() + 1);
        }
    }

    public void help(AbstractButton abstractButton) {
        if (abstractButton.isSelected()) {
            Point point = this.getLocation();
            this.helpWin = new HelpWindow(this, point, "generator", "Task Specification");
            this.helpWin.setSource(abstractButton);
        } else {
            this.helpWin.dispose();
        }
    }

    public void save() {
        if (this.currentTask.isPrimitive()) {
            this.conditionsPanel.save();
            this.constraintsPanel.save();
        } else if (this.currentTask.isSummary() || this.currentTask.isScript()) {
            this.nodesPanel.save();
            this.constraintsPanel.save();
        } else if (this.currentTask.isBehaviour()) {
            this.rulebasePanel.save();
        }
        this.genmodel.updateTask(this.currentTask);
        this.changed = false;
        this.fireChanged();
    }

    public AbstractTask getCurrentTask() {
        return this.currentTask;
    }

    public String getObjectName() {
        return this.genmodel.getTaskName(this.currentTask.getName());
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() != this.genmodel) {
            this.changed = true;
        }
        this.fireChanged();
    }

    public void closeDown() {
        if (this.changed) {
            int n = JOptionPane.showConfirmDialog(this, MESSAGE[0], MESSAGE[1], 1);
            if (n == 0) {
                this.save();
            } else if (n == 2) {
                this.setVisible(true);
                return;
            }
        }
        this.generator.taskEditorClosed(this.currentTask.getName());
        this.dispose();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = TaskEditor.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = TaskEditor.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? TaskEditor.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class SymChangeListener
    implements ChangeListener {
        protected SymChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            String string = TaskEditor.this.genmodel.getTaskName(TaskEditor.this.currentTask.getName());
            TaskEditor.this.setTitle(TaskEditor.this.currentTask.getTypeName() + " " + MESSAGE[2] + string);
            TaskEditor.this.fireChanged();
        }
    }
}

