/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import zeus.concepts.ConditionalNode;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.concepts.TaskLink;
import zeus.concepts.TaskNode;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.gui.graph.AbstractGraphModel;
import zeus.gui.graph.GraphNode;
import zeus.util.Core;

public class SummaryTaskModel
extends AbstractGraphModel
implements ChangeListener {
    static final int PRECONDITION = 0;
    static final int POSTCONDITION = 1;
    static final int BASIC_NODE = 0;
    static final int GUARD_NODE = 1;
    protected static final boolean ERROR = true;
    protected static final boolean NO_ERROR = false;
    protected static int count = 0;
    protected OntologyDb ontologyDb = null;
    protected Hashtable nodeTable = new Hashtable();
    protected Hashtable linkTable = new Hashtable();
    protected EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$zeus$generator$event$RenameListener;

    public SummaryTaskModel(OntologyDb ontologyDb, TaskNode[] taskNodeArray, TaskLink[] taskLinkArray) {
        this.ontologyDb = ontologyDb;
        ontologyDb.addChangeListener(this);
        this.reset(taskNodeArray, taskLinkArray);
    }

    public void reset(TaskNode[] taskNodeArray, TaskLink[] taskLinkArray) {
        this.nodeTable.clear();
        this.linkTable.clear();
        for (int i = 0; i < taskNodeArray.length; ++i) {
            this.nodeTable.put(taskNodeArray[i].getName(), new GraphNode(taskNodeArray[i]));
        }
        for (int i = 0; i < taskLinkArray.length; ++i) {
            this.linkTable.put(taskLinkArray[i].getId(), taskLinkArray[i]);
            GraphNode graphNode = (GraphNode)this.nodeTable.get(taskLinkArray[i].getLeftNode());
            GraphNode graphNode2 = (GraphNode)this.nodeTable.get(taskLinkArray[i].getRightNode());
            graphNode.addParent(graphNode2);
            graphNode2.addChild(graphNode);
        }
        this.fireGraphStructureChanged();
    }

    Fact[] getConditions(int n) {
        switch (n) {
            case 0: {
                GraphNode graphNode = (GraphNode)this.nodeTable.get("begin");
                TaskNode taskNode = (TaskNode)graphNode.getUserObject();
                return taskNode.getPostconditions();
            }
            case 1: {
                GraphNode graphNode = (GraphNode)this.nodeTable.get("end");
                TaskNode taskNode = (TaskNode)graphNode.getUserObject();
                return taskNode.getPreconditions();
            }
        }
        Core.ERROR(null, 1, (Object)this);
        return null;
    }

    public TaskNode[] getNodes() {
        TaskNode[] taskNodeArray = new TaskNode[this.nodeTable.size()];
        Enumeration enumeration = this.nodeTable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            GraphNode graphNode = (GraphNode)enumeration.nextElement();
            taskNodeArray[n] = (TaskNode)graphNode.getUserObject();
            ++n;
        }
        return taskNodeArray;
    }

    public TaskLink[] getLinks() {
        TaskLink[] taskLinkArray = new TaskLink[this.linkTable.size()];
        Enumeration enumeration = this.linkTable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            taskLinkArray[n] = (TaskLink)enumeration.nextElement();
            ++n;
        }
        return taskLinkArray;
    }

    public boolean isLinkVisible(GraphNode graphNode, GraphNode graphNode2) {
        TaskNode taskNode = (TaskNode)graphNode.getUserObject();
        TaskNode taskNode2 = (TaskNode)graphNode2.getUserObject();
        String string = taskNode.getName();
        String string2 = taskNode2.getName();
        Enumeration enumeration = this.linkTable.elements();
        while (enumeration.hasMoreElements()) {
            TaskLink taskLink = (TaskLink)enumeration.nextElement();
            if (!taskLink.getLeftNode().equals(string) || !taskLink.getRightNode().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public Enumeration nodes() {
        return this.nodeTable.elements();
    }

    public void setValue(GraphNode graphNode, Object object) {
        TaskLink taskLink;
        String string;
        Vector vector = (Vector)object;
        TaskNode taskNode = (TaskNode)vector.elementAt(0);
        TaskLink[] taskLinkArray = (TaskLink[])vector.elementAt(1);
        Hashtable hashtable = (Hashtable)vector.elementAt(2);
        TaskNode taskNode2 = (TaskNode)graphNode.getUserObject();
        String string2 = taskNode2.getName();
        this.nodeTable.remove(string2);
        graphNode.setUserObject(taskNode);
        this.nodeTable.put(taskNode.getName(), graphNode);
        Enumeration<Object> enumeration = this.linkTable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            taskLink = (TaskLink)this.linkTable.get(string);
            if (!taskLink.referencesNode(string2)) continue;
            this.linkTable.remove(string);
        }
        enumeration = this.nodeTable.elements();
        while (enumeration.hasMoreElements()) {
            ((GraphNode)enumeration.nextElement()).initialize();
        }
        for (int i = 0; i < taskLinkArray.length; ++i) {
            this.linkTable.put(taskLinkArray[i].getId(), taskLinkArray[i]);
        }
        enumeration = this.linkTable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            taskLink = (TaskLink)this.linkTable.get(string);
            GraphNode graphNode2 = (GraphNode)this.nodeTable.get(taskLink.getLeftNode());
            GraphNode graphNode3 = (GraphNode)this.nodeTable.get(taskLink.getRightNode());
            graphNode2.addParent(graphNode3);
            graphNode3.addChild(graphNode2);
        }
        this.fireGraphStructureChanged();
        this.fireChanged();
    }

    public boolean isNodeEditable(GraphNode graphNode) {
        return true;
    }

    public void removeNodes(GraphNode[] graphNodeArray) {
        for (int i = 0; i < graphNodeArray.length; ++i) {
            TaskNode taskNode = (TaskNode)graphNodeArray[i].getUserObject();
            String string = taskNode.getName();
            if (string.equals("begin") || string.equals("end")) {
                JOptionPane.showMessageDialog(null, "Cannot delete the BEGIN or END nodes", "Error", 0);
                continue;
            }
            this.nodeTable.remove(taskNode.getName());
            Enumeration enumeration = this.linkTable.elements();
            while (enumeration.hasMoreElements()) {
                TaskLink taskLink = (TaskLink)enumeration.nextElement();
                if (!taskLink.referencesNode(taskNode.getName())) continue;
                GraphNode graphNode = (GraphNode)this.nodeTable.get(taskLink.getLeftNode());
                GraphNode graphNode2 = (GraphNode)this.nodeTable.get(taskLink.getRightNode());
                if (graphNode == null || graphNode2 == null) continue;
                graphNode.removeParent(graphNode2);
                graphNode2.removeChild(graphNode);
            }
            this.fireGraphNodeRemoved(graphNodeArray[i]);
        }
        this.fireChanged();
    }

    public void addNewNode(int n) {
        GraphNode[] graphNodeArray = new GraphNode[1];
        String string = "node" + count++;
        while (this.contains(string, false)) {
            string = "node" + count++;
        }
        switch (n) {
            case 0: {
                graphNodeArray[0] = new GraphNode(new TaskNode(string));
                break;
            }
            case 1: {
                graphNodeArray[0] = new GraphNode(new ConditionalNode(string));
                break;
            }
            default: {
                Core.ERROR(null, 1001, (Object)this);
            }
        }
        this.addNodes(graphNodeArray);
    }

    public void addNodes(GraphNode[] graphNodeArray) {
        if (graphNodeArray == null || graphNodeArray.length == 0) {
            return;
        }
        for (int i = 0; i < graphNodeArray.length; ++i) {
            TaskNode taskNode = (TaskNode)graphNodeArray[i].getUserObject();
            taskNode = taskNode.isConditionalNode() ? new ConditionalNode((ConditionalNode)taskNode) : new TaskNode(taskNode);
            String string = taskNode.getName();
            while (this.contains(string, false)) {
                string = string + "$" + count++;
            }
            taskNode.setName(string);
            GraphNode graphNode = new GraphNode(taskNode);
            this.nodeTable.put(string, graphNode);
            this.fireGraphNodeAdded(graphNode);
        }
        this.fireChanged();
    }

    protected boolean contains(String string, boolean bl) {
        if (this.nodeTable.containsKey(string)) {
            if (bl) {
                JOptionPane.showMessageDialog(null, "Attempting to rename node to an already\nexisting name", "Error", 0);
            }
            return true;
        }
        return false;
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = SummaryTaskModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = SummaryTaskModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void addRenameListener(RenameListener renameListener) {
        this.listeners.add(class$zeus$generator$event$RenameListener == null ? (class$zeus$generator$event$RenameListener = SummaryTaskModel.class$("zeus.generator.event.RenameListener")) : class$zeus$generator$event$RenameListener, renameListener);
    }

    public void removeRenameListener(RenameListener renameListener) {
        this.listeners.remove(class$zeus$generator$event$RenameListener == null ? (class$zeus$generator$event$RenameListener = SummaryTaskModel.class$("zeus.generator.event.RenameListener")) : class$zeus$generator$event$RenameListener, renameListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? SummaryTaskModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    protected void fireNameChanged(Object object, Object object2, Object object3) {
        RenameEvent renameEvent = new RenameEvent(this, object, object2, object3);
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$zeus$generator$event$RenameListener == null ? SummaryTaskModel.class$("zeus.generator.event.RenameListener") : class$zeus$generator$event$RenameListener)) continue;
            RenameListener renameListener = (RenameListener)objectArray[i + 1];
            renameListener.nameChanged(renameEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

