/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.Fact;
import zeus.concepts.Ordering;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.generator.util.BasicFactModel;
import zeus.gui.editors.ValidatingModel;

public class OrderingModel
extends AbstractTableModel
implements ChangeListener,
ValidatingModel,
RenameListener {
    static final int BEFORE = 0;
    static final int AFTER = 1;
    protected static final String[] columnNames = new String[]{"Before", "After"};
    protected EventListenerList changeListeners = new EventListenerList();
    protected Vector data = new Vector();
    protected Vector validityInfo = new Vector();
    protected BasicFactModel preconditionsModel;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public OrderingModel(BasicFactModel basicFactModel, Ordering[] orderingArray) {
        this.preconditionsModel = basicFactModel;
        basicFactModel.addChangeListener(this);
        basicFactModel.addRenameListener(this);
        this.reset(orderingArray);
    }

    public void reset(Ordering[] orderingArray) {
        int n = this.data.size();
        this.data.removeAllElements();
        this.validityInfo.removeAllElements();
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        Vector vector = this.getPreconditionIds();
        for (int i = 0; i < orderingArray.length; ++i) {
            this.data.addElement(orderingArray[i]);
            this.validityInfo.addElement(this.isValid(orderingArray[i], vector));
        }
        this.fireTableRowsInserted(0, orderingArray.length - 1);
    }

    public Ordering[] getData() {
        Vector vector = new Vector();
        for (int i = 0; i < this.data.size(); ++i) {
            if (!this.validityInfo.elementAt(i).equals(Boolean.TRUE)) continue;
            vector.addElement(this.data.elementAt(i));
        }
        Ordering[] orderingArray = new Ordering[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            orderingArray[i] = (Ordering)vector.elementAt(i);
        }
        return orderingArray;
    }

    public void removeRows(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.data.removeElementAt(nArray[i] - i);
            this.validityInfo.removeElementAt(nArray[i] - i);
            this.fireTableRowsDeleted(nArray[i] - i, nArray[i] - i);
        }
        this.fireTableStructureChanged();
        this.fireChanged();
    }

    public void addNewRows(String string, String[] stringArray) {
        int n = 0;
        int n2 = this.data.size();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.additionOK(string, stringArray[i], -1)) continue;
            ++n;
            Ordering ordering = new Ordering(string, stringArray[i]);
            this.data.addElement(ordering);
            Vector vector = this.getPreconditionIds();
            this.validityInfo.addElement(this.isValid(ordering, vector));
        }
        if (n > 0) {
            this.fireTableRowsInserted(n2 - 1, n2 - 1 + n);
            this.fireTableStructureChanged();
            this.fireChanged();
        }
    }

    protected Vector getPreconditionIds() {
        Fact[] factArray = this.preconditionsModel.getData();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < factArray.length; ++i) {
            vector.addElement(factArray[i].getId());
        }
        return vector;
    }

    protected Boolean isValid(Ordering ordering, Vector vector) {
        boolean bl = vector.contains(ordering.getLHS()) && vector.contains(ordering.getRHS());
        return new Boolean(bl);
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public boolean isValidEntry(int n, int n2) {
        return this.validityInfo.elementAt(n).equals(Boolean.TRUE);
    }

    public Object getValueAt(int n, int n2) {
        Ordering ordering = (Ordering)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return ordering.getLHS();
            }
            case 1: {
                return ordering.getRHS();
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object.toString().equals("")) {
            return;
        }
        Ordering ordering = (Ordering)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                String string = (String)object;
                if (string.equals(ordering.getLHS())) {
                    return;
                }
                if (!this.additionOK(string, ordering.getRHS(), n)) {
                    return;
                }
                ordering.setLHS(string);
                Vector vector = this.getPreconditionIds();
                this.validityInfo.setElementAt(this.isValid(ordering, vector), n);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
                break;
            }
            case 1: {
                String string = (String)object;
                if (string.equals(ordering.getRHS())) {
                    return;
                }
                if (!this.additionOK(ordering.getLHS(), string, n)) {
                    return;
                }
                ordering.setRHS(string);
                Vector vector = this.getPreconditionIds();
                this.validityInfo.setElementAt(this.isValid(ordering, vector), n);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
            }
        }
    }

    protected boolean additionOK(String string, String string2, int n) {
        if (string.equals(string2)) {
            JOptionPane.showMessageDialog(null, "Attempting to add ordering " + string + "  --> " + string2, "Error", 0);
            return false;
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (i == n) continue;
            Ordering ordering = (Ordering)this.data.elementAt(i);
            if (ordering.getLHS().equals(string) && ordering.getRHS().equals(string2)) {
                JOptionPane.showMessageDialog(null, "Table already contains the ordering\n" + string + " < " + string2, "Error", 0);
                return false;
            }
            if (!ordering.getRHS().equals(string) || !ordering.getLHS().equals(string2)) continue;
            JOptionPane.showMessageDialog(null, "Attempting to add ordering " + string + " < " + string2 + "\nwhen table already contains ordering " + string2 + " < " + string, "Error", 0);
            return false;
        }
        return true;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Vector vector = this.getPreconditionIds();
        for (int i = 0; i < this.data.size(); ++i) {
            Ordering ordering = (Ordering)this.data.elementAt(i);
            this.validityInfo.setElementAt(this.isValid(ordering, vector), i);
        }
        this.fireTableDataChanged();
    }

    public void nameChanged(RenameEvent renameEvent) {
        String string = (String)renameEvent.getOriginal();
        String string2 = (String)renameEvent.getCurrent();
        for (int i = 0; i < this.data.size(); ++i) {
            Ordering ordering = (Ordering)this.data.elementAt(i);
            if (ordering.getLHS().equals(string)) {
                ordering.setLHS(string2);
            }
            if (!ordering.getRHS().equals(string)) continue;
            ordering.setRHS(string2);
        }
        this.fireTableDataChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = OrderingModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = OrderingModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? OrderingModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

