/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import zeus.concepts.Fact;
import zeus.generator.task.OrderingSelector;
import zeus.generator.util.BasicFactModel;

public class OrderingDialog
extends JDialog
implements ActionListener {
    protected static final String OK = "OK";
    protected static final String CANCEL = "Cancel";
    protected JList lhsList;
    protected JList rhsList;
    protected JButton okButton;
    protected JButton cancelButton;
    protected BasicFactModel model;
    protected OrderingSelector selector;

    public OrderingDialog(Frame frame, String string, BasicFactModel basicFactModel) {
        super(frame, string, true);
        this.model = basicFactModel;
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 10, 10));
        this.okButton = new JButton(OK);
        this.cancelButton = new JButton(CANCEL);
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel3 = new JPanel();
        JSeparator jSeparator = new JSeparator();
        jPanel3.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel3.add(jSeparator);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Before");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel4.setBorder(titledBorder);
        this.lhsList = new JList();
        this.lhsList.setSelectionModel(new DefaultListSelectionModel());
        this.lhsList.setSelectionMode(0);
        this.lhsList.setPreferredSize(new Dimension(100, 100));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.lhsList);
        this.lhsList.setBackground(Color.white);
        JPanel jPanel5 = new JPanel();
        titledBorder = BorderFactory.createTitledBorder("After");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel5.setBorder(titledBorder);
        this.rhsList = new JList();
        this.rhsList.setSelectionModel(new DefaultListSelectionModel());
        this.rhsList.setSelectionMode(2);
        this.rhsList.setPreferredSize(new Dimension(100, 100));
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().setView(this.rhsList);
        this.rhsList.setBackground(Color.white);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel4.add(jScrollPane);
        jPanel5.add(jScrollPane2);
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        jPanel.add("South", jPanel3);
        jPanel.add("Center", jPanel6);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OrderingDialog.this.setVisible(false);
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            int n;
            String string = (String)this.lhsList.getSelectedValue();
            Object[] objectArray = this.rhsList.getSelectedValues();
            String[] stringArray = new String[objectArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = (String)objectArray[n];
            }
            if (this.selector != null && string != null && stringArray.length != 0) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (!string.equals(stringArray[n])) continue;
                    JOptionPane.showMessageDialog(this, "The left and right items must be different:\n" + string + " < " + stringArray[n], "Error", 0);
                    return;
                }
                this.setVisible(false);
                this.selector.orderingSelected(string, stringArray);
            } else {
                this.setVisible(false);
            }
        } else if (object == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public void display(OrderingSelector orderingSelector) {
        this.selector = orderingSelector;
        Fact[] factArray = this.model.getData();
        String[] stringArray = new String[factArray.length];
        for (int i = 0; i < factArray.length; ++i) {
            stringArray[i] = factArray[i].getId();
        }
        this.lhsList.setListData(stringArray);
        this.rhsList.setListData(stringArray);
        this.pack();
        this.setVisible(true);
    }
}

