/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import zeus.concepts.OntologyDb;
import zeus.concepts.PlanScript;
import zeus.concepts.SummaryTask;
import zeus.concepts.TaskNode;
import zeus.concepts.ZeusParser;
import zeus.concepts.fn.ElseFn;
import zeus.concepts.fn.NumericFn;
import zeus.concepts.fn.ValueFunction;
import zeus.generator.AgentGenerator;
import zeus.generator.GeneratorModel;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.generator.task.SummaryTaskModel;
import zeus.generator.task.SummaryTaskNodeEditor;
import zeus.generator.task.SymBasicFactModel;
import zeus.generator.task.TaskEditor;
import zeus.generator.util.AttributeDialog;
import zeus.generator.util.AttributeSelector;
import zeus.generator.util.AttributeTreeModel;
import zeus.generator.util.BasicFactModel;
import zeus.generator.util.ControlPanel;
import zeus.gui.fields.LargeTextField;
import zeus.gui.graph.Graph;
import zeus.gui.graph.GraphNode;
import zeus.gui.graph.GraphNodeRenderer;
import zeus.gui.help.HelpWindow;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class NodesPanel
extends JPanel {
    protected SummaryTask task;
    protected Graph graph;
    protected GraphNode[] clipboard;
    protected SummaryTaskModel model;
    protected JCheckBox autorun;
    protected LargeTextField costfield;
    protected LargeTextField timefield;
    protected BasicFactModel preconditionsModel;
    protected BasicFactModel postconditionsModel;

    public NodesPanel(AgentGenerator agentGenerator, GeneratorModel generatorModel, OntologyDb ontologyDb, TaskEditor taskEditor, SummaryTask summaryTask) {
        JLabel jLabel;
        this.task = summaryTask;
        this.model = new SummaryTaskModel(ontologyDb, summaryTask.getNodes(), summaryTask.getLinks());
        this.model.addChangeListener(taskEditor);
        this.graph = new Graph(this.model);
        this.graph.setNodeRenderer(new SummaryTaskNodeRenderer());
        this.graph.setNodeEditor(new SummaryTaskNodeEditor(ontologyDb, this.model));
        this.preconditionsModel = new SymBasicFactModel(0, this.model);
        this.postconditionsModel = new SymBasicFactModel(1, this.model);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createBevelBorder(1));
        ControlPanel controlPanel = new ControlPanel(taskEditor, "Task Decomposition Graph", true, false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(controlPanel, gridBagConstraints);
        this.add(controlPanel);
        JPanel jPanel = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        String string = summaryTask.isScript() ? "Task Mode, Cost and Time" : "Task Cost and Time";
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel2.setBorder(titledBorder);
        gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBackground(Color.lightGray);
        if (summaryTask.isScript()) {
            jLabel = new JLabel("Autorun:");
            jLabel.setToolTipText("Set autorun on if task is invoked automatically");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(0, 8, 8, 0);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            this.autorun = new JCheckBox();
            this.autorun.setBackground(Color.lightGray);
            this.autorun.setSelected(((PlanScript)summaryTask).isAutorun());
            this.autorun.setEnabled(false);
            this.autorun.addChangeListener(taskEditor);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 8, 8, 8);
            gridBagLayout.setConstraints(this.autorun, gridBagConstraints);
            jPanel2.add(this.autorun);
        }
        jLabel = new JLabel("Cost:");
        jLabel.setToolTipText("Default cost of performing this task");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.costfield = new LargeTextField(2, 15);
        this.costfield.setLineWrap(true);
        this.costfield.setText(summaryTask.getCostFn().toString());
        this.costfield.addChangeListener(taskEditor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        gridBagLayout.setConstraints(this.costfield, gridBagConstraints);
        jPanel2.add(this.costfield);
        jLabel = new JLabel("Time:");
        jLabel.setToolTipText("Default duration of this task");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.timefield = new LargeTextField(2, 15);
        this.timefield.setLineWrap(true);
        this.timefield.setText(summaryTask.getTimeFn().toString());
        this.timefield.addChangeListener(taskEditor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(this.timefield, gridBagConstraints);
        jPanel2.add(this.timefield);
        gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBackground(Color.lightGray);
        JScrollPane jScrollPane = new JScrollPane(this.graph);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        this.graph.setPreferredSize(new Dimension(2000, 2000));
        this.graph.setBackground(Color.white);
        titledBorder = BorderFactory.createTitledBorder("Task Decomposition Graph");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel.setBorder(titledBorder);
        NodesToolBar nodesToolBar = new NodesToolBar(summaryTask.isScript());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(nodesToolBar, gridBagConstraints);
        jPanel.add(nodesToolBar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        SymRenameAction symRenameAction = new SymRenameAction();
        this.preconditionsModel.addRenameListener(symRenameAction);
        this.postconditionsModel.addRenameListener(symRenameAction);
        SymFocusAction symFocusAction = new SymFocusAction();
        this.costfield.addFocusListener(symFocusAction);
        this.timefield.addFocusListener(symFocusAction);
        SymMouseAction symMouseAction = new SymMouseAction();
        this.costfield.addMouseListener(symMouseAction);
        this.timefield.addMouseListener(symMouseAction);
    }

    BasicFactModel getPreconditionsModel() {
        return this.preconditionsModel;
    }

    BasicFactModel getPostconditionsModel() {
        return this.postconditionsModel;
    }

    void save() {
        this.task.setNodes(this.model.getNodes());
        this.task.setLinks(this.model.getLinks());
        this.task.setCostFn(this.costfield.getText());
        this.task.setTimeFn(this.timefield.getText());
        if (this.task.isScript()) {
            ((PlanScript)this.task).setAutorun(this.autorun.isSelected());
        }
    }

    protected void deleteSelectedNodes() {
        this.model.removeNodes(this.graph.getSelectedNodes());
        this.graph.redraw();
    }

    protected GraphNode[] cutSelectedNodes() {
        GraphNode[] graphNodeArray = this.graph.getSelectedNodes();
        this.model.removeNodes(graphNodeArray);
        this.graph.redraw();
        return graphNodeArray;
    }

    protected class NodesToolBar
    extends JToolBar
    implements ActionListener {
        protected HelpWindow helpWin;
        protected JToggleButton helpBtn;
        protected JButton nodeBtn;
        protected JButton guardBtn;
        protected JButton selectBtn;
        protected JButton selectAllBtn;
        protected JButton hideBtn;
        protected JButton showBtn;
        protected JButton collapseBtn;
        protected JButton expandBtn;
        protected JButton deleteBtn;
        protected JButton cutBtn;
        protected JButton copyBtn;
        protected JButton pasteBtn;
        protected JButton recomputeBtn;
        protected JButton redrawBtn;

        public NodesToolBar(boolean bl) {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.nodeBtn = new JButton("Node");
            this.nodeBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.nodeBtn);
            this.nodeBtn.setToolTipText("New task node");
            this.nodeBtn.addActionListener(this);
            if (bl) {
                this.guardBtn = new JButton("Guard");
                this.guardBtn.setMargin(new Insets(0, 0, 0, 0));
                this.add(this.guardBtn);
                this.guardBtn.setToolTipText("New conditional node");
                this.guardBtn.addActionListener(this);
            }
            this.addSeparator();
            this.recomputeBtn = new JButton(new ImageIcon(string2 + "recompute.gif"));
            this.recomputeBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.recomputeBtn);
            this.recomputeBtn.setToolTipText("Recompute node positions");
            this.recomputeBtn.addActionListener(this);
            this.redrawBtn = new JButton(new ImageIcon(string2 + "redraw.gif"));
            this.redrawBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.redrawBtn);
            this.redrawBtn.setToolTipText("Redraw");
            this.redrawBtn.addActionListener(this);
            this.addSeparator();
            this.selectBtn = new JButton(new ImageIcon(string2 + "select.gif"));
            this.selectBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.selectBtn);
            this.selectBtn.setToolTipText("Select nodes");
            this.selectBtn.addActionListener(this);
            this.selectAllBtn = new JButton(new ImageIcon(string2 + "selectAll.gif"));
            this.selectAllBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.selectAllBtn);
            this.selectAllBtn.setToolTipText("Select all nodes");
            this.selectAllBtn.addActionListener(this);
            this.addSeparator();
            this.collapseBtn = new JButton(new ImageIcon(string2 + "collapse.gif"));
            this.collapseBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.collapseBtn);
            this.collapseBtn.setToolTipText("Collapse nodes");
            this.collapseBtn.addActionListener(this);
            this.expandBtn = new JButton(new ImageIcon(string2 + "expand.gif"));
            this.expandBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.expandBtn);
            this.expandBtn.setToolTipText("Expand nodes");
            this.expandBtn.addActionListener(this);
            this.addSeparator();
            this.hideBtn = new JButton(new ImageIcon(string2 + "hide.gif"));
            this.hideBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.hideBtn);
            this.hideBtn.setToolTipText("Hide nodes");
            this.hideBtn.addActionListener(this);
            this.showBtn = new JButton(new ImageIcon(string2 + "show.gif"));
            this.showBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.showBtn);
            this.showBtn.setToolTipText("Show nodes");
            this.showBtn.addActionListener(this);
            this.addSeparator();
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.cutBtn = new JButton(new ImageIcon(string2 + "cut.gif"));
            this.cutBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.cutBtn);
            this.cutBtn.setToolTipText("Cut");
            this.cutBtn.addActionListener(this);
            this.copyBtn = new JButton(new ImageIcon(string2 + "copy.gif"));
            this.copyBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.copyBtn);
            this.copyBtn.setToolTipText("Copy");
            this.copyBtn.addActionListener(this);
            this.pasteBtn = new JButton(new ImageIcon(string2 + "paste.gif"));
            this.pasteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.pasteBtn);
            this.pasteBtn.setToolTipText("Paste");
            this.pasteBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.nodeBtn) {
                NodesPanel.this.model.addNewNode(0);
            } else if (object == this.guardBtn) {
                NodesPanel.this.model.addNewNode(1);
            } else if (object == this.recomputeBtn) {
                NodesPanel.this.graph.recompute();
            } else if (object == this.redrawBtn) {
                NodesPanel.this.graph.redraw();
            } else if (object == this.selectBtn) {
                NodesPanel.this.graph.select();
            } else if (object == this.selectAllBtn) {
                NodesPanel.this.graph.selectAll();
            } else if (object == this.collapseBtn) {
                NodesPanel.this.graph.collapse();
            } else if (object == this.expandBtn) {
                NodesPanel.this.graph.expand();
            } else if (object == this.hideBtn) {
                NodesPanel.this.graph.hide();
            } else if (object == this.showBtn) {
                NodesPanel.this.graph.show();
            } else if (object == this.deleteBtn) {
                NodesPanel.this.deleteSelectedNodes();
            } else if (object == this.copyBtn) {
                NodesPanel.this.clipboard = NodesPanel.this.graph.getSelectedNodes();
            } else if (object == this.pasteBtn) {
                NodesPanel.this.model.addNodes(NodesPanel.this.clipboard);
            } else if (object == this.cutBtn) {
                NodesPanel.this.clipboard = NodesPanel.this.cutSelectedNodes();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), this.getLocation(), "generator", "Summary Task Decomposition Graph");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    protected class SummaryTaskNodeRenderer
    implements GraphNodeRenderer {
        protected SummaryTaskNodeRenderer() {
        }

        public Component getNodeRendererComponent(Graph graph, GraphNode graphNode) {
            TaskNode taskNode = (TaskNode)graphNode.getUserObject();
            return new JLabel(taskNode.getName(), 0);
        }
    }

    protected class SymRenameAction
    implements RenameListener {
        protected SymRenameAction() {
        }

        public void nameChanged(RenameEvent renameEvent) {
            String string = (String)renameEvent.getOriginal();
            String string2 = (String)renameEvent.getCurrent();
            String string3 = NodesPanel.this.costfield.getText();
            NodesPanel.this.costfield.setText(Misc.substitute(string3, string, string2));
            string3 = NodesPanel.this.timefield.getText();
            NodesPanel.this.timefield.setText(Misc.substitute(string3, string, string2));
        }
    }

    protected class SymMouseAction
    extends MouseAdapter
    implements AttributeSelector {
        protected JTextComponent field = null;
        protected AttributeDialog dialog = null;
        protected AttributeTreeModel attributeTreeModel = new AttributeTreeModel();

        public SymMouseAction() {
            this.attributeTreeModel.setFactModels(NodesPanel.this.preconditionsModel, NodesPanel.this.postconditionsModel);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.field = (JTextComponent)mouseEvent.getSource();
                if (this.dialog == null) {
                    this.dialog = new AttributeDialog((Frame)SwingUtilities.getRoot(this.field), this.attributeTreeModel);
                }
                this.field = (JTextComponent)mouseEvent.getSource();
                this.dialog.setLocationRelativeTo(this.field);
                this.dialog.display(this);
            }
        }

        public void attributeSelected(String string) {
            try {
                Document document = this.field.getDocument();
                int n = document.getLength();
                AttributeSet attributeSet = document.getDefaultRootElement().getAttributes();
                document.insertString(n, string, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected class SymFocusAction
    implements FocusListener {
        protected SymFocusAction() {
        }

        public void focusLost(FocusEvent focusEvent) {
            LargeTextField largeTextField = (LargeTextField)focusEvent.getSource();
            this.validate(largeTextField);
        }

        public void focusGained(FocusEvent focusEvent) {
            LargeTextField largeTextField = (LargeTextField)focusEvent.getSource();
            largeTextField.setForeground(Color.black);
        }

        protected void validate(LargeTextField largeTextField) {
            String string = largeTextField.getText();
            ValueFunction valueFunction = ZeusParser.Expression(string);
            if (valueFunction != null && (valueFunction instanceof NumericFn || valueFunction instanceof ElseFn)) {
                largeTextField.setForeground(Color.black);
            } else {
                largeTextField.setForeground(Color.red);
            }
        }
    }
}

